/*
    Tango/Weevil - A WEB Tangler and Weaver
    Copyright (C) 1995 Corey Minyard

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Corey Minyard - minyard@metronet.com
*/


#define MAXLINESIZE 200

typedef struct linelist
{
   char *line;
   struct linelist *next;
} t_linelist;

typedef struct namelist
{
   char *name;
   struct namelist *next;
   union
   {
      int nest_val;
   } u;
} t_namelist;

typedef int bool;
#define TRUE 1
#define FALSE 0



typedef struct lpmac
{
   char *name;
   t_linelist *firstline;
   t_linelist *lastline;
   struct lpmac *next;
   char *filename;
   int  startline;
   t_namelist *staticdefs;
   t_namelist *globaldefs;
   t_namelist *pounddefs;
   t_namelist *uses;
} t_lpmac;

struct s_lptangodat;

typedef void (*input_scanner)(struct s_lptangodat *lptd,
			      char         *line,
			      int          length,
			      int          lineno);

typedef void (*linenum_output)(struct s_lptangodat *lptd,
			       int          lineno,
                               char         *filename);

typedef void (*scanner_init)(struct s_lptangodat *lptd);

typedef struct s_lptangodat
{
   FILE *infile;
   FILE *outfile;
   FILE *xreffile;
   char line[MAXLINESIZE];
   int outstate;
   char *curr_filename;
   int maxlinesize;
   int curr_lineno;
   t_lpmac *curr_macro;
   t_linelist *curr_line;
   t_lpmac *macros;
   char *start_macro;
   bool do_xref;
   bool auto_xref;
   bool instring;
   bool in_comment;
   bool do_linenums;
   void *code_info; /* Language-dependant info. */
   input_scanner scan_input;
   linenum_output output_linenum;
   int  retcode;    /* Program return code. */
} t_lptangodat;


void list_insert_unique(t_lptangodat *lptd,
			t_namelist   **list,
			t_namelist   *item);

t_namelist *find_name_in_list(t_lptangodat *lptd,
			      t_namelist *list,
			      t_namelist *item);

char *r_strtok(char *data,
	       char *sstr,
	       char **next_data);

char *stralloc(char *str,
	       int  length);

void free_namelist_item(t_lptangodat *lptd,
			t_namelist   *item);

t_namelist *create_namelist_item(t_lptangodat *lptd,
				 char         *str,
				 int          length);
