unit SpellCheckDlg;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls, Edit, Dialogs, Messages, IspellInterface;

type
  TSpellCheckDialog = class(TForm)
    WordEdit: TEdit;
    ListBox1: TListBox;
    ChangeButton: TButton;
    Button2: TButton;
    Button3: TButton;
    Button1: TButton;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormShow(Sender: TObject);
    procedure ListBox1Click(Sender: TObject);
    procedure ChangeButtonClick(Sender: TObject);
    procedure ContinueClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure ListBox1DblClick(Sender: TObject);
  private
    { Private declarations }
    iResult :IspellResult;
    list: TStringList;
  public
    { Public declarations }
    spellChecker: Ispell;

    function FindFirst (Sender: TObject; strLine: String; var first: IspellFirst): boolean;

    // Called by the current editor window to check a word
    procedure CheckWord (Sender: TObject; word: String);
  end;

var
  SpellCheckDialog: TSpellCheckDialog;

implementation

uses Frame;

{$R *.DFM}

procedure TSpellCheckDialog.FormShow(Sender: TObject);
begin
  try
    WordEdit.Text := '';
    spellChecker := nil;
    spellChecker := Ispell.Create (FrameForm.strSpellChecker);
  except
    on e: EInOutError do
    begin
      MessageDlg(e.Message, mtWarning, [mbOK], 0);
      PostMessage(self.Handle, WM_CLOSE, 0, 0);
    end;
  end;
end;


procedure TSpellCheckDialog.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  if spellChecker <> nil then spellChecker.Free;
end;


procedure TSpellCheckDialog.ListBox1Click(Sender: TObject);
begin
  if ListBox1.itemIndex >= 0 then
  begin
    WordEdit.Text := ListBox1.Items[ListBox1.itemIndex];
  end;
end;

procedure TSpellCheckDialog.ChangeButtonClick(Sender: TObject);
begin
  if FrameForm.MDIChildCount > 0 then
  begin
   (FrameForm.ActiveMDIChild as TEditForm).RichEdit.SelText := WordEdit.Text;
    ContinueClick(self);
  end;
end;


function TSpellCheckDialog.FindFirst(Sender: TObject; strLine: String; var first: IspellFirst): boolean;
begin
  result := spellChecker.FindFirst (strLine, first);
end;


// Called by the current editor window to check a word
procedure TSpellCheckDialog.CheckWord (Sender: TObject; word: String);
begin
  WordEdit.Text := word;
  iResult := spellChecker.CheckWord (word);
  if iResult.list <> nil then
  begin
    //ListBox1.Items.Clear;
    ListBox1.Items := iResult.list;
    Application.ProcessMessages;
  end
  else
    ListBox1.Items.Clear;
  iResult.Free();
end;


procedure TSpellCheckDialog.ContinueClick(Sender: TObject);
begin
  if FrameForm.MDIChildCount > 0 then
  begin
    Screen.Cursor := crHourglass;
    Button1.Enabled := false;
    Button2.Enabled := false;
    Button3.Enabled := false;
    ChangeButton.Enabled := false;

    ListBox1.Items.Clear;
    WordEdit.Text := '';
    (FrameForm.ActiveMDIChild as TEditForm).SpellCheck(self);

    Button2.Enabled := true;
    Screen.Cursor := crDefault;
    if WordEdit.Text <> '' then
    begin
      Button1.Enabled := true;
      Button3.Enabled := true;
      ChangeButton.Enabled := true;
    end;
  end;
end;

procedure TSpellCheckDialog.Button1Click(Sender: TObject);
begin
  spellChecker.AcceptWord (WordEdit.Text);
  ContinueClick(self);
end;

procedure TSpellCheckDialog.Button3Click(Sender: TObject);
begin
  spellChecker.AddWord (WordEdit.Text);
  ContinueClick(self);
end;

procedure TSpellCheckDialog.ListBox1DblClick(Sender: TObject);
begin
  ListBox1Click (self);
  ChangeButtonClick (self);
end;

end.
