unit ImageDlg;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls, Dialogs, IniFiles;

const
  LF: string = #13#10;

type
  TImageDialog = class(TForm)
    OKBtn: TButton;
    CancelBtn: TButton;
    Bevel1: TBevel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    ActionComboBox1: TComboBox;
    EditxPaper: TEdit;
    EdityPaper: TEdit;
    EditxImage: TEdit;
    EdityImage: TEdit;
    EditLaTeXHeight: TEdit;
    EditTitle: TEdit;
    EditFileName: TEdit;
    Label8: TLabel;
    Button1: TButton;
    OpenDialog1: TOpenDialog;
    Button2: TButton;
    procedure OKBtnClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
  strFigure: string;
    { Public declarations }
  end;

var
  ImageDialog: TImageDialog;

implementation

uses Frame;

{$R *.DFM}

procedure TImageDialog.OKBtnClick(Sender: TObject);
begin
  strFigure := '\begin{figure}' + LF
               + '\special{'
               + ActionComboBox1.Text + ' '
               + EditFileName.Text + ', '
               + EditxPaper.Text   + ' '
               + EdityPaper.Text   + ' '
               + EditxImage.Text   + ' '
               + EdityImage.Text   + '}' + LF
               + '\vspace{'
               + EditLaTeXHeight.Text + '}' + LF;
  if EditTitle.Text <> '' then
  begin
    strFigure :=  strFigure
                + '\caption{'
                + EditTitle.Text + '}' + LF
                + '\end{figure}' + LF
  end
  else
    strFigure := strFigure + '\end{figure}' + LF;
end;

procedure TImageDialog.Button1Click(Sender: TObject);
begin
if OpenDialog1.Execute then
  EditFileName.Text := ExtractFileName (OpenDialog1.FileName);
end;

procedure TImageDialog.FormCreate(Sender: TObject);
var iniFile: TIniFile;
begin
  iniFile := TIniFile.Create (FrameForm.iniFileName);

  ActionComboBox1.Text := iniFile.ReadString ('ImageDialog', 'Action', 'center');
  EditxPaper.Text := iniFile.ReadString ('ImageDialog', 'xPaperSize', '\the\hsize');
  EdityPaper.Text := iniFile.ReadString ('ImageDialog', 'yPaperSize', '6cm');
  EditxImage.Text := iniFile.ReadString ('ImageDialog', 'xImageSize', '6cm');
  EdityImage.Text := iniFile.ReadString ('ImageDialog', 'yImageSize', '6cm');
  EditLaTeXHeight.Text := iniFile.ReadString ('ImageDialog', 'LaTeXHeight', '7cm');

  iniFile.Free;
end;

procedure TImageDialog.FormDestroy(Sender: TObject);
var iniFile: TIniFile;
begin
  if FrameForm.lockIniFile = false then //*DS* ini file may be locked in network environment
  begin
    iniFile := TIniFile.Create (FrameForm.userIniFileName);

    iniFile.WriteString ('ImageDialog', 'Action', ActionComboBox1.Text);
    iniFile.WriteString ('ImageDialog', 'xPaperSize', EditxPaper.Text);
    iniFile.WriteString ('ImageDialog', 'yPaperSize', EdityPaper.Text);
    iniFile.WriteString ('ImageDialog', 'xImageSize', EditxImage.Text);
    iniFile.WriteString ('ImageDialog', 'yImageSize', EdityImage.Text);
    iniFile.WriteString ('ImageDialog', 'LaTeXHeight', EditLaTeXHeight.Text);

    iniFile.Free;
  end;
end;

procedure TImageDialog.Button2Click(Sender: TObject);
begin
  application.HelpJump ('InsertImageDlg');
end;

end.
