/* readlink.c -- get the filename a link is pointing to.

   Copyright (C) 1994, 1995 Ralph Schleicher  */

/* This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#include <errno.h>
#include "ansidecl.h"
#include "symlink.h"
#include "symlink/ea.h"


int
DEFUN (readlink, (name, buffer, size),
const char *name AND
char *buffer AND
size_t size)
{
  int handle, length;

  handle = ea_open (name, EA_OPEN_READ);
  if (handle == -1)
    return (-1);

  length = ea_get (handle, SYMLINK_ATTR_LINK, buffer, size);
  if (length == 0)
    {
      errno = EINVAL;
      length = (-1);
    }

  ea_close (handle);

  return (length);
}
