/* ea_set.c -- this file is part of the SYMLINK Library.

   Copyright (C) 1994, 1995 Ralph Schleicher  */

/* This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#ifdef EMX

#include <sys/ea.h>

#else /* not EMX */

#define INCL_DOSERRORS
#define INCL_DOSFILEMGR

#include <os2.h>

#endif /* not EMX */

#include <errno.h>
#include <string.h>
#include "ansidecl.h"


/* ea_set() writes the extended attribute NAME to a file.  ea_set()
   returns -1 if an error occurs, else 0.  */

int
DEFUN (symlink_ea_set, (handle, name, value, size),
int handle AND
const char *name AND
const char *value AND
size_t size)
{
#ifdef EMX

  struct _ea attr;

  if (!name || (!value && size))
    {
      errno = EINVAL;
      return (-1);
    }

  attr.flags = 0;
  attr.size = size;
  attr.value = (void *) value;

  return (_ea_put (&attr, NULL, handle, name));

#else /* not EMX */

  int error;
  int length;
  int alloc;
  EAOP2 attr;
  GEA2LIST get;
  FEA2LIST *full;

  if (!name || (!value && size))
    {
      errno = EINVAL;
      return (-1);
    }

  length = strlen (name);

  get.cbList = sizeof (GEA2LIST);

  alloc = sizeof (FEA2LIST) + length + 1 + size;
  full = malloc (alloc);
  if (full == 0)
    return (-1);

  full->cbList = alloc;
  full->list[0].oNextEntryOffset = 0;
  full->list[0].cbName = length;
  full->list[0].cbValue = size;
  strcpy (full->list[0].szName, name);
  if (size)
    memcpy (full->list[0].szName + length + 1, value, size);

  attr.fpGEA2List = &get;
  attr.fpFEA2List = full;

  error = DosSetFileInfo (handle, 2, &attr, sizeof (attr));

  free (full);

  switch (error)
    {
    case 0:

      return 0;

    case ERROR_ACCESS_DENIED:

      errno = EACCES;
      return (-1);

    case ERROR_INVALID_HANDLE:
    case ERROR_DIRECT_ACCESS_HANDLE:

      errno = EBADF;
      return (-1);

    default:

      errno = EINVAL;
      return (-1);
    }

#endif /* not EMX */
}
