/*
 * Decompiled with CFR 0.152.
 */
package nts.tex;

import java.io.File;
import java.io.StringWriter;
import nts.base.Num;
import nts.command.FileName;
import nts.io.CharCode;
import nts.io.InputLine;
import nts.io.Log;
import nts.io.Name;
import nts.io.StandardLog;

public final class TeXCharMapper
implements CharCode.Maker,
InputLine.Mapper,
StandardLog.Escape {
    private static Config config;

    public static void setConfig(Config conf) {
        config = conf;
    }

    private static CharCode forNum(int n) {
        return n >= 0 && n <= 255 ? new Char((char)n) : null;
    }

    private static CharCode forNum(Num num) {
        return TeXCharMapper.forNum(num.intVal());
    }

    private static boolean matchNum(char code, int n) {
        return n >= 0 && n <= 255 && n == code;
    }

    private static boolean matchNum(char code, Num num) {
        return TeXCharMapper.matchNum(code, num.intVal());
    }

    private static void putExpCodes(char chr, CharCode.CodeWriter out) {
        TeXCharMapper.writeCode('^', out);
        TeXCharMapper.writeCode('^', out);
        if (chr < '@') {
            TeXCharMapper.writeCode((char)(chr + 64), out);
        } else if (chr < '\u0080') {
            TeXCharMapper.writeCode((char)(chr - 64), out);
        } else {
            TeXCharMapper.writeCode(TeXCharMapper.lcHexDig(chr >> 4 & 0xF), out);
            TeXCharMapper.writeCode(TeXCharMapper.lcHexDig(chr & 0xF), out);
        }
    }

    private static void putExpChars(char chr, CharCode.CharWriter out) {
        out.writeChar('^');
        out.writeChar('^');
        if (chr < '@') {
            out.writeChar((char)(chr + 64));
        } else if (chr < '\u0080') {
            out.writeChar((char)(chr - 64));
        } else {
            out.writeChar(TeXCharMapper.lcHexDig(chr >> 4 & 0xF));
            out.writeChar(TeXCharMapper.lcHexDig(chr & 0xF));
        }
    }

    private static boolean isPrintable(char chr) {
        return chr >= ' ' && chr < '\u007f' || chr > '\u00a0';
    }

    private static void writeCode(char chr, CharCode.CodeWriter out) {
        out.writeCode(new Char(chr));
    }

    private static char lcHexDig(int d) {
        return (char)(d < 10 ? 48 + d : 97 + d - 10);
    }

    public CharCode make(char chr) {
        return new Char(chr);
    }

    public CharCode make(int num) {
        return TeXCharMapper.forNum(num);
    }

    public CharCode getEscape() {
        return TeXCharMapper.forNum(config.escapeNumCode());
    }

    public boolean isNewLine(char chr) {
        return TeXCharMapper.matchNum(chr, config.newLineNumCode());
    }

    public void writeExpCodes(char chr, CharCode.CodeWriter out) {
        if (TeXCharMapper.isPrintable(chr)) {
            TeXCharMapper.writeCode(chr, out);
        } else {
            TeXCharMapper.putExpCodes(chr, out);
        }
    }

    public void writeExpChars(char chr, CharCode.CharWriter out) {
        if (TeXCharMapper.isPrintable(chr)) {
            out.writeChar(chr);
        } else {
            TeXCharMapper.putExpChars(chr, out);
        }
    }

    public CharCode map(char chr) {
        return new Char(chr);
    }

    public CharCode map(int num) {
        return TeXCharMapper.forNum(num);
    }

    public CharCode endLine() {
        return TeXCharMapper.forNum(config.endLineNumCode());
    }

    public boolean ignoreTrailing(char chr) {
        return chr == ' ' || chr == '\t';
    }

    private static final class Char
    implements CharCode {
        private char code;

        public char toChar() {
            return this.code <= '\u00ff' ? (char)this.code : (char)'\uffff';
        }

        public char toCanonicalLetter() {
            int n = config.lcNumCode(this.code);
            return n > 0 && n <= 255 ? (char)n : (char)'\uffff';
        }

        public int numValue() {
            return this.code <= '\u00ff' ? (int)this.code : -1;
        }

        public boolean match(CharCode x) {
            return x.match(this.code);
        }

        public boolean match(char c) {
            return c == this.code;
        }

        public boolean match(int n) {
            return TeXCharMapper.matchNum(this.code, n);
        }

        public boolean match(Num num) {
            return TeXCharMapper.matchNum(this.code, num);
        }

        public CharCode toLowerCase() {
            int n = config.lcNumCode(this.code);
            return n > 0 && n <= 255 ? new Char((char)n) : this;
        }

        public CharCode toUpperCase() {
            int n = config.ucNumCode(this.code);
            return n > 0 && n <= 255 ? new Char((char)n) : this;
        }

        public int spaceFactor() {
            return config.spaceFactor(this.code);
        }

        public int mathCode() {
            return config.mathCode(this.code);
        }

        public int delCode() {
            return config.delCode(this.code);
        }

        public boolean isEscape() {
            return config.catCode(this.code) == 0;
        }

        public boolean startsExpand() {
            return config.catCode(this.code) == 7;
        }

        public boolean isLetter() {
            return config.catCode(this.code) == 11;
        }

        public boolean isEndLine() {
            return this.match(config.endLineNumCode());
        }

        public boolean isNewLine() {
            return this.match(config.newLineNumCode());
        }

        public boolean startsFileExt() {
            return this.code == '.';
        }

        public void writeExpCodes(CharCode.CodeWriter out) {
            if (TeXCharMapper.isPrintable(this.code)) {
                out.writeCode(this);
            } else {
                TeXCharMapper.putExpCodes(this.code, out);
            }
        }

        public void writeExpChars(CharCode.CharWriter out) {
            if (TeXCharMapper.isPrintable(this.code)) {
                out.writeChar(this.code);
            } else {
                TeXCharMapper.putExpChars(this.code, out);
            }
        }

        public void writeRawChars(CharCode.CharWriter out) {
            out.writeChar(this.code);
        }

        public void addOn(Log log) {
            log.add(this);
        }

        public int hashCode() {
            return this.code;
        }

        public boolean equals(Object o) {
            return o != null && o instanceof CharCode && ((CharCode)o).match(this.code);
        }

        public String toString() {
            return String.valueOf(this.code);
        }

        public Char(char chr) {
            this.code = chr;
        }
    }

    public static class TeXFileName
    implements FileName {
        private Name.Buffer data = new Name.Buffer();

        public int accept(CharCode code) {
            if (code.toChar() == '\uffff') {
                return -1;
            }
            if (code.match(' ')) {
                return 0;
            }
            this.data.append(code);
            return 1;
        }

        public String getPath() {
            StringWriter out = new StringWriter();
            int i = 0;
            while (i < this.data.length()) {
                CharCode code = this.data.codeAt(i);
                if (code instanceof Char) {
                    out.write(((Char)code).code);
                }
                ++i;
            }
            return out.toString();
        }

        public void setPath(String path) {
            this.data.clear();
            this.append(path);
        }

        public Name baseName() {
            int beg = this.indexOfName();
            int end = this.indexOfExt(beg);
            CharCode[] codes = new CharCode[end - beg];
            this.data.getCodes(beg, end, codes, 0);
            return new Name(codes);
        }

        public boolean addDefaultExt(String ext) {
            int i = this.indexOfExt(this.indexOfName());
            if (i < this.data.length()) {
                return false;
            }
            this.data.append(new Char('.'));
            this.append(ext);
            return true;
        }

        public void append(char chr) {
            this.data.append(new Char(chr));
        }

        public void append(String str) {
            int len = str.length();
            int i = 0;
            while (i < len) {
                this.append(str.charAt(i));
                ++i;
            }
        }

        private int indexOfName() {
            String name;
            String path = this.getPath();
            int i = path.lastIndexOf(name = new File(path).getName());
            return i > 0 ? i : 0;
        }

        private int indexOfExt(int start) {
            int i = this.data.length();
            while (--i > start) {
                if (!this.data.codeAt(i).startsFileExt()) continue;
                return i;
            }
            return this.data.length();
        }

        public FileName copy() {
            return new TeXFileName(this.data.toName());
        }

        public void addOn(Log log) {
            log.add(this.data.toName());
        }

        public int hashCode() {
            return this.data.hashCode();
        }

        public boolean equals(Object o) {
            return o != null && o instanceof TeXFileName && this.data.equals(((TeXFileName)o).data);
        }

        public String toString() {
            return this.getPath();
        }

        public TeXFileName() {
        }

        public TeXFileName(Name name) {
            this.data.append(name);
        }
    }

    public static interface Config {
        public int catCode(int var1);

        public int lcNumCode(int var1);

        public int ucNumCode(int var1);

        public int spaceFactor(int var1);

        public int mathCode(int var1);

        public int delCode(int var1);

        public int escapeNumCode();

        public int newLineNumCode();

        public int endLineNumCode();
    }
}

