/*# --------------------------------------------------------------------------
###  package    = "FTETX"
###  version    = "0.04"
###  date       = "1997/08/20"
###  filename   = "./CONTRIB/FTETX004/SRC/TXLAUNCH.003/str.c"
###  local      = "NO"
### --------------------------------------------------------------------------
###  txlaunch-version = "0.03"
### -------------------------- Copyright (c) 1997, Oliver John von Zydowitz */

#define __STR_C__

#include "common.h"

#include "str.h"
#include "msg.h"

/*---------------------------------------------------------------------------- 
   ULONG STR_pszString_len (PPSZ pszString)
   get length of string. checks for validity.
*/ 

ULONG STR_pszString_len(PPSZ pszString)
{
  if (!pszString)    return 0l;        /* pointer to pointer invalid */
  if (!(*pszString)) return 0l;        /* pointer points to NULL */
  return strlen(*pszString);
}


/*---------------------------------------------------------------------------- 
   ULONG STR_szString_len (PSZ szString)
   get length of string.
*/ 

ULONG STR_szString_len(PSZ szString)
{
  if (!szString) return 0l;
  return strlen(szString);
}


/*---------------------------------------------------------------------------- 
   PSZ STR_delete_string (PPSZ pszString)
   frees given string from heap. NULL pointer checked.
   given:   Address of a (char *) / (PPSZ = *PSZ = char** )
   returns: NULL
*/ 

PSZ STR_delete_string(PPSZ pszString)
{
  if (!pszString) return NULL;        /* pointer to pointer invalid */
  if (*pszString) free(*pszString);
  return (*pszString = NULL);
}


/*----------------------------------------------------------------------------
   PSZ STR_new_string(ULONG n)
   malloc for a new string of size n.
   string is cleared. requesting zero length is allowed.
   given:   length n
   returns: pointer to allocated memory
   Note:    incrementing length by 1 for terminating zero.
*/

PSZ STR_new_string(ULONG n)
{
PCH p1;

  if ((p1=malloc(n+1)))
    {
      *p1 = 0;  /* 'clear' string */
      return p1;
    }
  MSG_fatal_n(FAT_NOMEM);
  return NULL;          /* never reached */
}


/*----------------------------------------------------------------------------
   PSZ STR_renew_string(PPSZ pszString, ULONG n)
   frees given string from heap (NULL pointer checked).
   malloc for a new string of size n.
   string is cleared. requesting zero length is allowed.
   given:   Address of a (char *) / (PPSZ = *PSZ = char** ); length n
   returns: pointer to allocated memory if sucessful /
            NULL otherwise
*/

PSZ STR_renew_string(PPSZ pszString, ULONG n)
{
    STR_delete_string(pszString);
    return (*pszString = STR_new_string(n));
}


/*----------------------------------------------------------------------------
   PSZ STR_copy_string(PPSZ pszDest, PSZ szSource)
   Copies source-string to destination.
   given:   pszDest: Address of a (char *) / (PPSZ = *PSZ = char** );
            szSource: string (char *)
   returns: pointer to allocated memory for new destination-string
*/

PSZ STR_copy_string(PPSZ pszDest, PSZ szSource)
{
ULONG newlength;

   newlength = STR_szString_len(szSource);
   STR_renew_string(pszDest, newlength);
   if (szSource) strcpy(*pszDest, szSource);
   return *pszDest;
}


/*----------------------------------------------------------------------------
   PSZ STR_concat_string(PPSZ pszString1, PSZ szCatString)
   concatenates two strings.
   given:   _address_ pszString1 of string to be extended;
            string szCatString of string to be added.
   returns: (new) concatenated string.
*/

PSZ STR_concat_string(PPSZ pszString1, PSZ szCatString)
{
PSZ   tempdest = NULL;
ULONG newlength;

  newlength =   STR_pszString_len(pszString1)
              + STR_szString_len(szCatString);

  tempdest = STR_new_string(newlength);
  if (pszString1) if (*pszString1) strcat(tempdest,*pszString1);
  if (szCatString) strcat(tempdest, szCatString);
  STR_delete_string(pszString1);
  return  (*pszString1 = tempdest);
}

/*-----------------------------------------------------------------------------
  int CHR_is_whitesp(char c)
  checks for whitespace character.
  given: char to test
  returns: 1 if given ' ', '\t', '\n', '\r'
           0 otherwise
*/

int CHR_is_whitesp(char c)
{
  switch (c)
    {
      case ' '  :
      case '\t' :
      case '\n' :
      case '\r' : return 1;
      default   : return 0;
    }
  /* never reached */
}


/*-----------------------------------------------------------------------------
  PCH STR_get_terminator(PSZ szString)
  given: String
  returns: pointer to terminating null-char (0x00).
           or NULL if given NULL. 
*/

PCH STR_get_terminator(PSZ szString)
{

  if (!szString) return NULL;      /* no string */
  return strchr(szString,0);
}


/*-----------------------------------------------------------------------------
  int STR_is_quoted(PSZ szString)
  checks string for a proper quotation.
  Allowed for quoting is either  "blah", 'blah', `blah` or `blah'
  given:   String
  returns: 1 if properly quoted, 0 otherwise
*/

int STR_is_quoted(PSZ szString)
{
PCH q2;

  if (!szString) return 0;                         /* no string */
  if ((*szString!='\'') && (*szString!='"')        /* no leading quote */
      && (*szString!='`'))             return 0;
  q2 = STR_get_terminator(szString);
  q2--;                  
  if (q2==szString)                    return 0;   /* length = 1 */
  if (*q2==*szString)                  return 1;   /* found trailing quote */
  if ((*q2=='\'') && (*szString=='`')) return 1;
  return 0;
}


/*-----------------------------------------------------------------------------
  int STR_is_bracked(PSZ szString)
  checks string for a proper []-pair around.
  given:   string
  returns: 1 if proper, 0 otherwise
*/

int STR_is_bracked(PSZ szString)
{
PCH q2;

  if (!szString)      return 0;    /* no string */
  if (*szString!='[') return 0;    /* no loeading [ */
  q2 = STR_get_terminator(szString);
  q2--;
  if (*q2==']')       return 1;    /* found trailing ] */
  return 0; 
}


/*----------------------------------------------------------------------------
  PSZ STR_is_leader(PSZ szString, PSZ szLeadingStr)
  checks if szString starts with szLeadingStr.
  given: 2 strings
  returns: NULL if s doesn't start with l, 
           pointer to 1st char in szString after leader otherwise
  Note:    no new strings are allocated.
*/   

PSZ STR_is_leader(PSZ szString, PSZ szLeadingStr)
{
ULONG leaderlen;
    
  if (!szString) return NULL;
  if (!szLeadingStr) return szString;
  leaderlen = STR_szString_len(szLeadingStr);
  if (STR_szString_len(szString)<leaderlen)  return NULL;      /* s too short */
  if (strncmp(szString,szLeadingStr,leaderlen)) return NULL;  /* doesn't match */
  return (szString+leaderlen);
}


/*-----------------------------------------------------------------------------
  PSZ STR_remove_envelope(PPSZ pszString)
  removes "envelope" from string (i.e. 1st and last char).
  used to remove quotes or []-pairs from strings.
  given:   adress of string
  returns: pointer to memory allocated for new string
  Note:    no errorcheck.
*/

PSZ STR_remove_envelope(PPSZ pszString)
{
PCH p1;
PCH p2;
PSZ tempstr = NULL;

  p1  = *pszString; p1++;
  p2  = STR_get_terminator(*pszString); p2--;
  *p2 = 0;
  STR_copy_string(&tempstr, p1);
  STR_delete_string(pszString);
  return (*pszString=tempstr);
}


/*-----------------------------------------------------------------------------
  PSZ STR_unquote_string(PPSZ pszString)
  checks for proper quoted string and removes quotes.
  given:   address of string
  returns: pointer to new string if given a quoted string.
           otherwise: return NULL, leave string unchanged. 
*/

PSZ STR_unquote_string(PPSZ pszString)
{
  if (!pszString)  return NULL;
  if (!*pszString) return NULL;                 /* no string */
  if (STR_is_quoted(*pszString)) return STR_remove_envelope(pszString);
  return NULL; /* otherwise */
}


/*-----------------------------------------------------------------------------
  PSZ STR_unbrack_string(PPSZ pszString)
  checks for proper brackets arround string and removes them.
  given:   address of string
  returns: pointer to new string if given a quoted string.
           otherwise: return NULL, leave string unchanged. 
*/

PSZ STR_unbrack_string(PPSZ pszString)
{
  if (!pszString)  return NULL;
  if (!*pszString) return NULL;                 /* no string */
  if (STR_is_bracked(*pszString)) return STR_remove_envelope(pszString);
  return NULL; /* otherwise */
}


/*-----------------------------------------------------------------------------
  PSZ STR_remove_whitesp(PPSZ pszString)
  removes any leading and trailing whitespace from string. 
  whitespace is: ' ', '\t', '\n', '\r'
  given:   address of string
  returns: pointer to new string if given a proper string.
           otherwise: return NULL, leave string unchanged. 
*/

PSZ STR_remove_whitesp(PPSZ pszString)
{
PCH p1;
PCH p2;
PSZ tempstr = NULL;

  if (!pszString)  return NULL;
  if (!*pszString) return NULL;                 /* no string */
  for (p1=*pszString; CHR_is_whitesp(*p1); p1++);  /* move to 1st non-ws */
  if (*p1)                              /* skip next if remaining string */
    {                                   /* is empty */
      p2 = STR_get_terminator(p1);          /* move to last char */
      p2--;
      for(; CHR_is_whitesp(*p2); p2--);     /* loop breaks when reaching p1 */
      p2++;                                 /* move one behind last non-ws */
      *p2 = 0;                              /* and terminate string here */
    }
  
  STR_copy_string(&tempstr, p1);
  STR_delete_string(pszString);
  return (*pszString=tempstr);
}

/*-------------------------------------------------------------------------- */
