/*
 * compress.h
 *
 * data compression routines.
 *
 * idea taken from Robert Sedgewick's 'Algorithms in C'
 */
#define MAX_BYTE (0xff+1)
#define COUNTTABSIZE (sizeof(unsigned long)*MAX_BYTE)

struct Node {
    struct Node *Parent;
    struct Node *LeftChild;
    struct Node *RightChild;
    unsigned long Count;
    unsigned char Value;
    unsigned char Move;
};

    // function prototypes
void ResetCount( void );    /* resets the count array */
void AddCount( unsigned char _far *, unsigned long );
unsigned BuildTree( void );
/* can return: */
#define CE_OK	 0
#define CE_NOMEM 1
#define CE_NOTAB 2

unsigned long *GetTree( void );
void PutTree( unsigned long * );
unsigned long Encode( unsigned char _far *, unsigned long,
	     unsigned char _far *, unsigned long );
unsigned long Decode( unsigned char _far *, unsigned long,
	     unsigned char _far *, unsigned long );
