/*
    argvenv:

        - dual mode program
        - use Win32 Api if the program runs under rsxnt
*/

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>


/*
    check runtime system:

    the _emx_env variable defines runtime flags

    if the rsx bit is set, the application runs under rsx, rsxwin or rsxnt
     then the _emx_rev variable contains rsx runtime flags
     the high word defines the runtime system under rsx**
*/

#define BIT_RSX 0x1000L

#define RSX_IS_RUNNING      0
#define RSXWIN_IS_RUNNING   1
#define RSXNT_IS_RUNNING    2

static int check_rsxnt_runtime(int *version)
{
    if (_emx_env & BIT_RSX) {
        int rsx_runtime = _emx_rev >> 16;

        *version = _emx_rev & 0xFFFF;

        if (rsx_runtime == RSXNT_IS_RUNNING)
            return 1;
    }
    return 0;
}


/*
    print win32 GetVersion flags
*/

static void print_win32_version(void)
{
    DWORD ver = GetVersion();
    printf("\nWindows version %ld.%ld\n", ver & 0xff, (ver>>8) & 0xff);
    printf("version dword %08lX\n", ver);
    printf("build %d\n", (ver >> 16) & 0x3fff);
    printf("version flag 31 = %s\n", (ver & 0x80000000) ? "Win31+Win32s" : "NT");
    printf("chicago flag 30 = %s\n", (ver & 0x40000000) ? "true" : "false");
}

int main(int argc, char **argv, char **env)
{
    int i, version;

    _envargs (&argc, &argv, "ARGS");
    _response (&argc, &argv);
    _wildcard (&argc, &argv);

    printf("Environment:\n");
    for (i=0;env[i]!=NULL;++i)
	printf("%02d: %s\n",i,env[i]);

    printf("Arguments:\n");
    for (i=0;argv[i]!=NULL;++i)
	printf("%02d: %s\n",i,argv[i]);

    if (check_rsxnt_runtime(&version)) {
        printf("\nRunning under RSXNT version %X.%X\n",
                version >> 8, version & 0xff);
        print_win32_version();

    }
    return 0;
}
