## -*-Tcl-*-
 # ###################################################################
 #  None - none
 # 
 #  FILE: "scriptRunner.tcl"
 #                                    created: 04/29/98 {02:06:55 AM} 
 #                                last update: 8/5/98 {6:44:43 pm} 
 #  Author: Vince Darley
 #  E-mail: vince@biosgroup.com
 #    mail: Bios Group
 #          617 Paseo de Peralta, Santa Fe, NM 87501
 #     www: http://www.biosgroup.com/
 #  
 # ###################################################################
 ##

alpha::extension scriptRunner 0.1

namespace eval script {}

proc script::run {name args} {
    if {[info tclversion] < 8.0} {
	global tclshSig tclshSigs
	app::launchElseTryThese $tclshSigs tclshSig "Please locate the remote Tcl application"
    }
    
    global HOME
    getOpts {-script}
    set i [file tail $name]
    if {![file exists $name]} {
	if {[file exists [file join $HOME Tools $name]]} {
	    set name [file join $HOME Tools $name]
	} elseif {[file exists [file join $HOME Tools $name.tcl]]} {
	    set name [file join $HOME Tools $name.tcl]
	}
    }
    
    script::evaluate [list catch [list package require MacOSDefaults]]
    script::evaluate [list catch [list interp create $i]]
    script::copy_variables i name args
    
    # load in Tk unless we don't want it
    if {![info exists opts(-noTk)]} {
	script::evaluate {
	    load {} Tk $i
            $i eval [list wm protocol . WM_DELETE_WINDOW exit]
	}
    }
    # if there's an extra script, do that
    if {[info exists opts(-script)]} {
	script::evaluate [list $i eval $opts(-script)]
    }
    global tclshSig
    switchTo '$tclshSig'
    script::evaluate {
	namespace eval script {}
	proc script::done {args} {
	    global alphaPriv
	    set alphaPriv(scriptDone) 1
	}
	
	$i eval [list set argc [llength $args]]
	$i eval [list set argv $args]
	# catch exit conditions
	interp alias $i exit "" script::done
	
	# run it
	$i eval [list source $name]
	# wait till it's done
	global alphaPriv
	vwait alphaPriv(scriptDone)
	catch [list interp delete $i]
	unset alphaPriv(scriptDone)
    }
}

proc script::copy_variables {args} {
    if {[info tclversion] < 8.0} {
	foreach v $args {
	    uplevel 1 "script::evaluate \"set $v \[list \[set $v\]\]\""
	}
    }
}

proc script::evaluate {what} {
    if {[info tclversion] < 8.0} {
	global tclshSig
	set r [AEBuild -r -t 30000 '${tclshSig}' misc dosc ---- "$what"]
	return [aeparse::keywordValue ---- [aeparse::event $r]]
    } else {
	uplevel 1 $what
    }
}

proc script::done {args} {
    global alphaPriv
    set alphaPriv(scriptDone) 1
}
