#=============================================================================
# Browser mode.
# 
# Alpha cannot do batch searches without this file
#=============================================================================

alpha::mode Brws 1.0.3 dummyBrws 

Bind '\r'	gotoMatch  Brws
Bind enter	gotoMatch  Brws
ascii 0x3  	gotoMatch  Brws
Bind down 	downBrowse Brws
Bind up 	upBrowse   Brws
Bind 'n' <z>	downBrowse Brws
Bind 'p' <z>	upBrowse   Brws
ascii 0x20	downBrowse Brws
ascii 0x8	upBrowse   Brws
# this was below.  do we need it?
Bind 'c' <Cz>	gotoMatch

proc dummyBrws {} {}

proc upBrowse {} {
    set limit [nextLineStart [nextLineStart [minPos]]]
    if {[pos::compare [getPos] > $limit]} {
	set limit [pos::math [getPos] - 1]
    }
    select [lineStart $limit] [nextLineStart $limit]
}

proc downBrowse {} {
    set pos [getPos]
    if {[pos::compare $pos < [nextLineStart [minPos]]]} {
	set pos [nextLineStart [minPos]]
    }
    if {[pos::compare [nextLineStart $pos] != [maxPos]]} {
	select [nextLineStart $pos] [nextLineStart [nextLineStart $pos]]
    }
}

proc nextPrevMatch {{dir 1} {wname "*Batch Find*"}} {
    set wins [winNames]
    set res [lsearch $wins $wname]
    if {$res < 0} {
	set res [lsearch -regexp $wins {\*.*\*}]
	if {$res < 0} return
    }
    set win [lindex $wins $res]
    bringToFront $win
    if {$dir} {
	downBrowse
    } else {
	upBrowse
    }
    gotoMatch
    dispErr $win
}

proc nextMatch {{wname "*Batch Find*"}} {
    nextPrevMatch 1 $wname
}

proc prevMatch {{wname "*Batch Find*"}} {
    nextPrevMatch 0 $wname
}

proc dispErr {{win "* Compiler Errors *"}} {
    if {[string length $win]} {
	set text [getText -w $win [getPos -w $win] [selEnd -w $win]]
	if {[regexp {(Line.*)} $text dummy sub]} {
	    message "$sub"
	}
    }
}
		

##############################################################################
#  To be used in the windows created by "matchingLines" or by batch searches.
#
#  With the cursor positioned in a line corrsponding to a match, 
#  go back and select the line in the original file that 
#  generated this match.  (Like emacs 'Occur' functionality)
#
proc gotoMatch {} {
    global brwsGotoMatch
    foreach pat [array names brwsGotoMatch] {
	if {[string match $pat [win::CurrentTail]]} {
	    $brwsGotoMatch($pat)
	    return
	}
    }
    global tileHeight tileWidth tileTop tileLeft tileHeight \
      errorHeight errorDisp tileMargin
    set loc [getPos]
    set ind1 -1
    while {$ind1 < 0} {
	set text [getText [lineStart $loc] [pos::math [nextLineStart $loc] - 1]]
	set ind1 [string first "" $text]
	set loc [nextLineStart $loc]
    }
    set ind2 [string last "" $text]
    if {$ind1 == $ind2} {
	set fname [string trim [string range $text $ind1 end] {}]
	set msg ""
    } else {
	set tmp [string trim [string range $text 0 $ind2] {}]
	if {[string last "\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t" $tmp] < 0} {
	    set fname [string trim [string range $text $ind2 end] {}]
	    set msg ""
	} else {
	    set ind1 [string last "" $tmp]
	    set fname [string trim [string range $text $ind1 $ind2] {}]
	    set msg [string trim [string range $text $ind2 end] {}]
	}
    }
    set loc [getPos]
    set line -1
    while {![regexp {Line ([0-9]+):} $text dummy line]} {
	set text [getText [lineStart $loc] [pos::math [nextLineStart $loc] - 1]]
	set loc [pos::math [lineStart $loc] - 1]
    }
    
    set top $tileTop
    set geo [getGeometry]
    if {([lindex $geo 0] != $tileLeft) || ([lindex $geo 1] != $top) \
      || ([lindex $geo 3] != $errorHeight) } {
	moveWin $tileLeft $top
	sizeWin $tileWidth $errorHeight
    }
    set mar $tileMargin
    incr top [expr {$errorHeight + $mar}]
    if {[brwsOpenWindow $fname]} {
	edit -c -w -g $tileLeft $top $tileWidth $errorDisp $fname
	set geo [getGeometry]
	if {([lindex $geo 0] != $tileLeft) || ([lindex $geo 1] != $top) \
	  || ([lindex $geo 2] != $tileWidth) || ([lindex $geo 3] != $errorDisp) } {
	    sizeWin $tileWidth $errorDisp
	    moveWin $tileLeft $top
	}
    } else {
	if {![string match "*Link*" \
	  [getText [minPos] [nextLineStart [minPos]]]]} {
	    alertnote "File \" $fname \" not found." 
	}
	return
    }
    if {$line >= 0} {
	set pos [rowColToPos $line 0]
	select $pos [nextLineStart $pos]
    }
    message $msg
}

proc brwsOpenWindow {fname} {
    global tileHeight tileWidth tileTop tileLeft tileHeight \
      errorHeight errorDisp tileMargin
    if {[file exists $fname]} {
	set top $tileTop
	set mar $tileMargin
	incr top [expr {$errorHeight + $mar}]
	edit -c -w -g $tileLeft $top $tileWidth $errorDisp $fname
	set geo [getGeometry]
	if {([lindex $geo 0] != $tileLeft) || ([lindex $geo 1] != $top) \
	  || ([lindex $geo 2] != $tileWidth) || ([lindex $geo 3] != $errorDisp) } {
	    sizeWin $tileWidth $errorDisp
	    moveWin $tileLeft $top
	}
	return 1
    } else {
	return 0
    }
}

set lastMatchingLines ""

proc matchingLines {{reg ""} {for 1} {ign 1} {word 0} {regexp 1}} {
    global lastMatchingLines
	
    if {![string length $reg] && \
      [catch {prompt "Regular expression:" $lastMatchingLines} reg]} return
    set lastMatchingLines $reg
    if {![string length $reg]} return
    if {!$regexp} {
	set reg [quote::Regfind $reg]
    }
    if {$word} {
	set reg "^.*\\b$reg\\b.*$"
    } else {
	set reg "^.*$reg.*$"
    }
    set pos [expr {$for ? [minPos] : [getPos]}]
    set fileName [stripNameCount [win::Current]]
    set matches 0
    set lines {}
    while {![catch {search -s -f 1 -r 1 -i $ign -- $reg $pos} mtch]} {
	regsub -all "\t" [eval getText $mtch] "  " text
	append lines "\r" [format "Line %d: " \
	  [lindex [posToRowCol [lindex $mtch 0]] 0]] \
	  $text \
	  "\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\
	  \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t$fileName"
	set pos [lindex $mtch 1]
	incr matches
    }
    if {$matches} {
	grepsToWindow {* Matching Lines *} \
	  [format "%d matching lines (<cr> to go to match)\r-----" $matches] \
	  $lines "\r"
    } else {
	beep
	message "No matches found."
    }
}



