/*
Symbols widget
Copyright  2005 Trevor Harmon <trevor@vocaro.com>

This file is licensed under the GNU General Public License.
http://www.gnu.org/copyleft/gpl.html
*/

var scrollbar, scrollArea;
var flipper;
var min_middle_height = 210;
var curr_middle_height = 210;

var LATEX = 0;
var HTML = 1;
var KEYBOARD = 2;

var mode_options = [
	{id:LATEX, name: 'LaTeX'},
	{id:HTML, name:'HTML'},
	{id:KEYBOARD, name:'Keyboard'}];

var COPY_TO_CLIPBOARD = 0;
var INSERT_INTO_TEXTMATE = 1;

var current_tab = 0;
var current_mode = LATEX;
var click_action = COPY_TO_CLIPBOARD;

function load()
{
	flipper = new Fader(document.getElementById("flip"), null, 500);
	
	// Initialize preferences
	if (window.widget)
	{
		current_mode = widget.preferenceForKey("mode");

		// If no mode has been saved, use the default
		if (current_mode === undefined)
		{
			current_mode = LATEX;
		}

		current_tab = widget.preferenceForKey("tab");

		// If no tab has been saved, use the default
		if (current_tab === undefined)
		{
			current_tab = 0;
		}
	}

	updateModeSelect();
	updateTabSelect();
	
	document.getElementById('mid').style.height = curr_middle_height + "px";
	document.getElementById('bottom').style.top = curr_middle_height + 76 + "px";
	document.getElementById('backtable').style.height = curr_middle_height + 76 + 25 + "px";
	
	scrollbar = new AppleVerticalScrollbar(document.getElementById("myScrollBar"));
	scrollArea = new AppleScrollArea(document.getElementById("parentDiv"), scrollbar);
	scrollArea.scrollsHorizontally = false;
	scrollArea.singlepressScrollPixels = 25;
	scrollArea.focus(); // for key control when first loading in Safari
	window.onfocus = function () { scrollArea.focus(); }
	window.onblur = function () { scrollArea.blur(); }

	setupParts();
	
 	document.getElementById('tab-popup-text').innerText = tab_options[current_tab];
	
	buildTable();
	scrollArea.refresh();
}

function showBackside(event) {
	if (window.widget) {
		widget.prepareForTransition("ToBack");
	}
	document.getElementById("fliprollie").style.display="none";
	document.getElementById("front").style.display="none";
	document.getElementById("back").style.display="block";
	
	if (window.widget) {
		setTimeout("widget.performTransition()", 0);
	}
}	

function showFront(event) {
	if (window.widget) {
		widget.prepareForTransition("ToFront");
	}
	document.getElementById("back").style.display="none";
	document.getElementById("front").style.display="block";
	if (window.widget) {
		setTimeout("widget.performTransition()", 0);
	}
}

function updateModeSelect()
{
    var control;
    
    control = document.getElementById('latexControl');
	control.style.color = current_mode == LATEX ? 'white' : 'gray';

    control = document.getElementById('htmlControl');
	control.style.color = current_mode == HTML ? 'white' : 'gray';

    control = document.getElementById('keyboardControl');
	control.style.color = current_mode == KEYBOARD ? 'white' : 'gray';
}

function updateTabSelect()
{
	var select = document.getElementById('tab-select');
	
	for (var i=0; i < tab_options.length; i++)
	{
		var option = document.createElement('option');
		option.innerText = tab_options[i];
		select.appendChild(option);
	}
}

function buildTable()
{
	var table = document.getElementById('content-table');
	
	while (table.hasChildNodes())
	{
		table.removeChild(table.firstChild);
	}

	var tbody = document.createElement('tbody');
	table.appendChild(tbody);
	
	var c = symbols[current_tab].length;
	for (var i  = 0; i < c; ++i)
	{
		var obj = symbols[current_tab][i];
		
		var tr = document.createElement('tr');
		tr.setAttribute('valign', 'top');
		tr.setAttribute('align', 'center');
		tr.setAttribute('onclick', 'handleClick (event, this);');
		
		// symbol
		var td = document.createElement('td');
		td.setAttribute('class', 'symbol-column');
		var symbol = document.createElement('div');
		symbol.setAttribute('class', 'symbol');
		symbol.appendChild (document.createTextNode(obj.symbol));
		td.appendChild(symbol);
		tr.appendChild (td);
		
		// spacer
		td = document.createElement('td');
		td.setAttribute('class', 'spacer12-column');
		tr.appendChild (td);
		
		// label
		var label = obj.label[current_mode];
		td = document.createElement('td');
		td.setAttribute('class', 'label-column');
		var div = document.createElement('div');
		div.setAttribute ('class', label == NONE ? 'label-div-disabled' : 'label-div');
		div.appendChild (document.createTextNode(label));
		td.appendChild (div);
		tr.appendChild (td);
		
		tbody.appendChild(tr);
	}
}

function show_complete_list ()
{
	if (window.widget)
	{
		switch (current_mode)
		{
			case LATEX:
				widget.openURL('http://www.ctan.org/tex-archive/info/symbols/comprehensive/');
				break;
				
			case HTML:
				widget.openURL('http://www.w3.org/TR/html4/sgml/entities.html');
				break;
				
			case KEYBOARD:
				widget.openURL('http://home.earthlink.net/~awinkelried/keyboard_shortcuts.html');
				break;
		}
	}
}

//
// event handlers
//

var trackingElement = null;

function mode_changed (index)
{
	current_mode = index;
	
	updateModeSelect();
	buildTable();
	scrollArea.refresh();

	// Save the mode preference
	if (window.widget)
	{
		widget.setPreferenceForKey(current_mode, "mode");
	}
}

function tab_popup_changed (event, select)
{
	current_tab = select.selectedIndex;
	document.getElementById('tab-popup-text').innerText = tab_options[current_tab];

	buildTable();
	scrollArea.refresh();

	event.stopPropagation();
	event.preventDefault();
	
	// Save the tab preference
	if (window.widget)
	{
		widget.setPreferenceForKey(current_tab, "tab");
	}
}

var resize_start_pos = null;
var resize_height = null;

function resize_mouse_down_handler (event, img)
{
	document.addEventListener("mousemove", resize_mouse_move_handler, true);
	document.addEventListener("mouseup", resize_mouse_up_handler, true);

	trackingElement = img;

	resize_last_y = event.y;
	resize_size = curr_middle_height;
	
	event.stopPropagation();
	event.preventDefault();
}

function resize_mouse_move_handler (event)
{
	var deltay = event.y - resize_last_y;
	resize_last_y = event.y;
	
	var need_to_resize_to_min = false;
	if (resize_size > min_middle_height)
		need_to_resize_to_min = true;
		
	resize_size += deltay;
	
	if (resize_size >= min_middle_height || need_to_resize_to_min)
	{
		var mid_size = resize_size;
		if (resize_size < min_middle_height)
			mid_size = min_middle_height;
		
		document.getElementById('mid').style.height = mid_size + 'px';
		document.getElementById('bottom').style.top = 76 + mid_size + 'px';
		document.getElementById('backtable').style.height = 76 + mid_size + 25 + 'px';
		document.getElementById('doneButton').style.top = 70 + mid_size + 'px';

		curr_middle_height = mid_size;
		scrollArea.refresh();
		
		if (window.widget)
		{
			window.resizeTo (298, mid_size + 76 + 45); // 76 is top, 45 bottom
		}
	}
	
	event.stopPropagation();
	event.preventDefault();
}

function resize_mouse_up_handler(event)
{
	document.removeEventListener("mousemove", resize_mouse_move_handler, true);
	document.removeEventListener("mouseup", resize_mouse_up_handler, true);
	
	trackingElement = null;
	
	event.stopPropagation();
	event.preventDefault();
}

function handleClick (event, element)
{
	if (current_mode != KEYBOARD)
	{
		// Pull the label text out of the item
		var item = element.lastChild.firstChild.firstChild.nodeValue;
	
		if (window.widget && item != NONE)
		{
			switch (click_action)
			{
				case COPY_TO_CLIPBOARD:
					// Copy the text to the clipboard
					widget.system("/bin/echo '" + item + "' | /usr/bin/pbcopy", null);
					break;
					
				case INSERT_INTO_TEXTMATE:
					widget.system("/usr/bin/osascript -e 'tell app \"TextMate\" to insert \"" + item.replace(/\\/, '\\\\') + "\"'", null);
					break;
			}
	
			event.stopPropagation();
			event.preventDefault();

			// Close Dashboard
			widget.openURL("");
		}
	}
}
