﻿/*
Symbols widget
Copyright © 2005 Trevor Harmon <trevor@vocaro.com>

This file is licensed under the GNU General Public License.
http://www.gnu.org/copyleft/gpl.html
*/

var tab_options = [
	'Greek Letters',
	'Accents',
	'Non-ASCII Letters',
	'Currency Symbols',
	'Quotation Marks',
	'Text Enhancements',
	'Mathematical Symbols',
];

var NONE = 'none';

var symbols = new Array;

// A good list of HTML codes is here:
// http://www.webreference.com/html/reference/character/symbols.html

symbols = [

	// Greek Letters
	[
		{symbol:'α', label:['\\alpha', '&alpha;', NONE]},
		{symbol:'β', label:['\\beta', '&beta;', NONE]},
		{symbol:'γ', label:['\\gamma', '&gamma;', NONE]},
		{symbol:'δ', label:['\\delta', '&delta;', NONE]},
		{symbol:'ε', label:['\\epsilon', '&epsilon;', NONE]},
		{symbol:'ζ', label:['\\zeta', '&zeta;', NONE]},
		{symbol:'η', label:['\\eta', '&eta;', NONE]},
		{symbol:'θ', label:['\\theta', '&theta;', NONE]},
		{symbol:'ι', label:['\\iota', '&iota;', NONE]},
		{symbol:'κ', label:['\\kappa', '&kappa;', NONE]},
		{symbol:'λ', label:['\\lambda', '&lambda;', NONE]},
		{symbol:'µ', label:['\\mu', '&mu;', '⎇M']},
		{symbol:'ν', label:['\\nu', '&nu;', NONE]},
		{symbol:'ξ', label:['\\xi', '&xi;', NONE]},
		{symbol:'ο', label:['o', '&omicron;', NONE]},
		{symbol:'π', label:['\\pi', '&pi;', '⎇P']},
		{symbol:'ρ', label:['\\rho', '&rho;', NONE]},
		{symbol:'ς', label:['\\varsigma', '&sigmaf;', NONE]},
		{symbol:'σ', label:['\\sigma', '&sigma;', NONE]},
		{symbol:'τ', label:['\\tau', '&tau;', NONE]},
		{symbol:'υ', label:['\\upsilon', '&upsilon;', NONE]},
		{symbol:'φ', label:['\\varphi', '&phi;', NONE]},
		{symbol:'χ', label:['\\chi', '&chi;', NONE]},
		{symbol:'ψ', label:['\\psi', '&psi;', NONE]},
		{symbol:'ω', label:['\\omega', '&omega;', NONE]},
		{symbol:'Α', label:['A', '&Alpha;', NONE]},
		{symbol:'Β', label:['B', '&Beta;', NONE]},
		{symbol:'Γ', label:['\\Gamma', '&Gamma;', NONE]},
		{symbol:'∆', label:['\\Delta', '&Delta;', '⎇J']},
		{symbol:'Ε', label:['E', '&Epsilon;', NONE]},
		{symbol:'Ζ', label:['Z', '&Zeta;', NONE]},
		{symbol:'Η', label:['H', '&Eta;', NONE]},
		{symbol:'Θ', label:['\\Theta', '&Theta;', NONE]},
		{symbol:'Ι', label:['I', '&Iota;', NONE]},
		{symbol:'Κ', label:['K', '&Kappa;', NONE]},
		{symbol:'Λ', label:['\\Lambda', '&Lambda;', NONE]},
		{symbol:'Μ', label:['M', '&Mu;', NONE]},
		{symbol:'Ν', label:['N', '&Nu;', NONE]},
		{symbol:'Ξ', label:['\\Xi', '&Xi;', NONE]},
		{symbol:'Ο', label:['O', '&Omicron;', NONE]},
		{symbol:'Π', label:['\\Pi', '&Pi;', '⎇⇧P']},
		{symbol:'Ρ', label:['P', '&Rho;', NONE]},
		{symbol:'Σ', label:['\\Sigma', '&Sigma;', '⎇W']},
		{symbol:'Τ', label:['T', '&Tau;', NONE]},
		{symbol:'Υ', label:['\\Upsilon', '&Upsilon;', NONE]},
		{symbol:'Φ', label:['\\Phi', '&Phi;', NONE]},
		{symbol:'Χ', label:['X', '&Chi;', NONE]},
		{symbol:'Ψ', label:['\\Psi', '&Psi;', NONE]},
		{symbol:'Ω', label:['\\Omega', '&Omega;', '⎇Z']}
	],

	// Accents
	[
		{symbol:'À', label:['\\`{A}', '&Agrave;', '⎇` ⇧A']},
		{symbol:'Á', label:['\\\'{A}', '&Aacute;', '⎇E ⇧A']},
		{symbol:'Â', label:['\\^{A}', '&Acirc;', '⎇I ⇧A']},
		{symbol:'Ã', label:['\\~{A}', '&Atilde;', '⎇N ⇧A']},
		{symbol:'Ä', label:['\\"{A}', '&Auml;', '⎇U ⇧A']},
		{symbol:'Å', label:['\\r{A}', '&Aring;', '⎇⇧A']},
		{symbol:'Ç', label:['\\c{C}', '&Ccedil;', '⎇⇧C']},
		{symbol:'Ę', label:['\\k{E}', NONE, NONE]},
	],

	// Non-ASCII Letters
	[
		{symbol:'œ', label:['\\oe', '&OElig;', '⎇Q']},
		{symbol:'Œ', label:['\\OE', '&oelig;', '⎇⇧Q']},
		{symbol:'æ', label:['\\ae', '&aelig;', '⎇\'']},
		{symbol:'Æ', label:['\\AE', '&AElig;', '⎇⇧\'']},
		{symbol:'ø', label:['\\o', '&oslash;', '⎇O']},
		{symbol:'Ø', label:['\\O', '&Oslash;', '⎇⇧O']},
		{symbol:'ß', label:['\\ss', '&szlig;', '⎇S']},
		{symbol:'þ', label:['\\th', '&thorn;', NONE]},
		{symbol:'Þ', label:['\\TH', '&THORN;', NONE]},
	],
	
	// Currency Symbols
	[
		{symbol:'¥', label:['\\textyen', '&yen;', '⎇Y']},
		{symbol:'€', label:['\\texteuro', '&euro;', '⎇@']},
		{symbol:'£', label:['\\textsterling', '&pound;', '⎇3']},
		{symbol:'ƒ', label:['\\textflorin', '&fnof;', '⎇F']},
		{symbol:'¢', label:['\\textcent', '&cent;', '⎇4']},
		{symbol:'¤', label:['\\textcurrency', '&curren;', NONE]},
	],
	
	// Quotation Marks
	[
		{symbol:'«', label:['\\guillemotleft', '&laquo;', '⎇\\']},
		{symbol:'»', label:['\\guillemotright', '&raquo;', '⎇⇧\\']},
		{symbol:'‹', label:['\\guilsinglleft', '&lsaquo;', '⎇⇧3']},
		{symbol:'›', label:['\\guilsinglright', '&rsaquo;', '⎇⇧4']},
		{symbol:'„', label:['\\quotedblbase', '&bdquo;', '⎇⇧W']},
		{symbol:'‚', label:['\\quotesinglbase', '&#130;', '⎇⇧0']},
		{symbol:'"', label:['\\textquotedbl', '&quot;', NONE]},
	],
	
	// Text enhancements
	[
		{symbol:'©', label:['\\textcopyright', '&copy;', '⎇G']},
		{symbol:'§', label:['\\textsection', '&sect;', '⎇6']},
		{symbol:'…', label:['\\textellipsis', '&hellip;', '⎇;']},
		{symbol:'™', label:['\\texttrademark', '&trade;', '⎇2']},
		{symbol:'®', label:['\\textregistered', '&reg;', '⎇R']},
		{symbol:'¶', label:['\\textparagraph', '&para;', '⎇7']},
		{symbol:'–', label:['\\textendash', '&ndash;', '⎇-']},
		{symbol:'—', label:['\\textemdash', '&mdash;', '⎇⇧-']},
	],
	
	// Mathematical Symbols
	[
		{symbol:'¼', label:['\\textonequarter', '&frac14;', NONE]},
		{symbol:'½', label:['\\textonehalf', '&frac12;', NONE]},
		{symbol:'¾', label:['\\textthreequarters', '&frac34;', NONE]},
		{symbol:'‰', label:['\\tcperthousand', '&#8240;', '⎇⇧R']},
		{symbol:'±', label:['\\pm', '&plusmn;', '⎇⇧=']},
		{symbol:'÷', label:['\\div', '&divide;', '⎇/']},
		{symbol:'×', label:['\\times', '&times;', NONE]},
		{symbol:'•', label:['\\bullet', '&bull;', '⎇8']},
		{symbol:'·', label:['\\cdot', '&middot;', '⎇⇧9']},
		{symbol:'°', label:['\\degree', '&deg;', '⎇⇧8']},
		{symbol:'≤', label:['\\leq', '&le;', '⎇,']},
		{symbol:'≥', label:['\\geq', '&ge;', '⎇.']},
		{symbol:'≈', label:['\\approx', '&asymp;', '⎇X']},
		{symbol:'≠', label:['\\not=', '&ne;', '⎇=']},
		{symbol:'∞', label:['\\infty', '&infin;', '⎇5']},
		{symbol:'∫', label:['\\int', '&int;', '⎇B']},
		{symbol:'∂', label:['\\partial', NONE, '⎇D']},
	],

];
