unit common;

{$ifdef fpc}{$asmmode intel}{$endif}

interface
uses strings;

type LatTable=Array[$0..$7F] of array[0..20] of char;
     PBin = ^Bin;
     PText = ^Text;
     Bin = file of byte;

     type TconvertedPass1=record

	 leegptr,
	 openptr               : Array [0..1] of Integer;
	 attr_rij              : Array [0..1,0..16] of Byte;
	 open_attr_rij         : Array [0..1] of Boolean;
	 depth                 : Integer;

         indenting:		Byte;
	 char_on_line,
	 nomore_valid_tabs,
	 indent_end,
	 ind_text1,
	 ind_text2  : Boolean;

	 Linebegin:Boolean;

	 envir,
	 line_term      : Char;

	 num_of_tabs,
	 latex_tabpos : Integer;
	 tabpos       : Array [1..40] of Word;
	 right_tab,
	 align_tab,
	 center_tab   : Boolean;

	 WP_sidemargin  : Integer;

	 ind_leftmargin : Word;

	 by,subby:Byte;
	 ActualPos:Longint;

	 rownum  : Word;

	 Font:Byte;
	 flag:Byte;
	 FirstSection:shortint;
	 recursion:byte;
	 ObjType:string[20];

         wpd,tabel:Pbin;
         strip,log:Ptext;
	 end;



{Optimalization flags}
const OptimizeSection:Boolean=True;
      FixSpaces:Boolean      =False;

      Open_com:array[0..18] of string[20]=
	(
        '{\LARGE ',
        '{\Large ',
        '{\large ',
        '{\small ',
        '{\footnotesize ',
        '$^{{\rm ',
        '$_{{\rm ',
        '',
        '{\it ',
        '',
        '',
        '\underline{\Underline{',
        '{\bf ',
        '',
        '\Underline{',
        '{\sc ',
        '\section{',
        '\subsection{',
        '\subsubsection{');

   Close_com:array[0..18] of string[20]=
        (
        '}',
        '}',
        '}',
        '}',
        '}',
        '}}$',
        '}}$',
        '',
        '\/}',
        '',
        '',
        '}}',
        '}',
        '',
        '}',
        '}',
        '}',
        '}',
        '}');


var lat    : LatTable;

    CodePage:Word;
    WPcharset:Word;
    Cyrilic:Boolean;
    Verbosing:Byte;
    TexChars:Boolean;
    ExtendedCheck:Boolean;
    wp60:Boolean;

    num_of_lines_stripfile:longint;


Procedure Jump_in_file(Var f:Bin; dis:Longint);
Procedure Rd_word(Var f:Bin; Var w:Word);
procedure WritexByte (w:byte;var txt:text);
Procedure Wr_word(Var f:Bin; w:Word);

Function LowCases(s:string):string;
Function UpCases(s:string):string;
Function CutStr(str:string):string;

function StrCpy(Dest, Source: PChar): PChar;
implementation

{ This procedure jumps in one binar file het aantal opened bytes. }
Procedure Jump_in_file(Var f:Bin; dis:Longint);
Var  cur_pos : Longint;
Begin
   cur_pos := Filepos(f);
   Seek(f,cur_pos+dis);
End;



{ This procedure read one word from the opened binar file. }
Procedure Rd_word(Var f:Bin; Var w:Word);
Var b : Byte;
Begin
   Read(f,b);
   w:=b;
   Read(f,b);
   w:=w+256*b
End;


{ This procedure write one word in the opened binar file. }
Procedure Wr_word(Var f:Bin; w:Word);
Var b : Byte;
Begin
   b:=w mod 256;
   Write(f,b);
   b:=w div 256;
   Write(f,b);
End;



procedure WritexByte (w:byte;var txt:text);
var c:array [1..2] of char;
begin
	asm
	mov	al,w
        mov	ah,al
	mov	cl,4
        shr	ah,cl
        and	al,0Fh
        add	al,90h
        daa
        adc	al,40h
        daa
	mov	byte ptr c + 1 ,al
        mov	al,ah
        add	al,90h
	daa
	adc	al,40h
	daa
	mov	byte ptr c,al
	end;
  Write(txt,c)
end;


Function LowCases(s:string):string;
var i:integer;
begin
for i:=1 to length(s) do
	begin
        if (s[i]>='A')and(s[i]<='Z') then
        	s[i]:=chr(ord(s[i])-ord('A')+ord('a'));
        end;
LowCases:=s;
end;


Function UpCases(s:string):string;
var i:integer;
begin
for i:=1 to length(s) do
	begin
       	s[i]:=UpCase(s[i]);
        end;
UpCases:=s;
end;

Function CutStr(str:string):string;
begin
  while((str<>'') and (str[length(str)]=' ')) do
         str:=copy(str,1,length(str)-1);
  while((str<>'') and (str[1]=' ')) do
         str:=copy(str,2,length(str)-1);

  CutStr:=str;
end;



function StrCpy(Dest, Source: PChar): PChar;
begin
 StrCpy:=StrCopy(Dest, Source);
end;

end.