// Date formatter for German dates (in German)
// With correct a-umlaut in HTML encoding
// Note: Using escape sequences in the <title> tag is not *really*
//       defined. You may want to use deL1 for your HTML stuff
// 8/1998 jk
#include "config.h"

#ifdef TM_IN_SYS_TIME
#include <sys/time.h>
#else
#include <time.h>
#endif

#ifdef HAVE_STRING_H
#include <string.h>
#else /* do not have sting.h */
#include <strings.h>
#endif /* HAVE_STRING_H */
#define __EXCLUDE_READER_CLASSES
#include "lib.h"

char *deHTML_date(time_t when)
{
    static const char *months[]=
    {
	"Januar", "Februar", "M&auml;rz", "April",
	"Mai", "Juni", "Juli", "August",
	"September", "Oktober", "November", "Dezember",
    };

    struct tm *tim;
    char date_buf[200];
    
    tim=localtime(&when);

    sprintf(date_buf, "%d. %s %d", tim->tm_mday,
	    months[tim->tm_mon], 1900+tim->tm_year);
    
    return strdup(date_buf);
}
