/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.tableview.views;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.actions.TexSelections;
import net.sourceforge.texlipse.tableview.views.ITexRowListViewer;
import net.sourceforge.texlipse.tableview.views.TexRow;

public class TexRowList {
    public static final int SUM_UP = 1;
    public static final int SUM_DOWN = 2;
    public static final int SUM_LEFT = 3;
    public static final int SUM_RIGHT = 4;
    private static final int ROW_COUNT = 10;
    private Vector rows = new Vector(10);
    private Set changeListeners = new HashSet();

    public TexRowList() {
        int i = 0;
        while (i < 10) {
            this.rows.add(i, new TexRow());
            ++i;
        }
    }

    public Vector getRows() {
        return this.rows;
    }

    public TexRow addRow() {
        TexRow row = new TexRow();
        this.rows.add(this.rows.size(), row);
        Iterator iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            ((ITexRowListViewer)iterator.next()).addRow(row);
        }
        return row;
    }

    public TexRow insertRow(int index, TexRow row) {
        this.rows.insertElementAt(row, index);
        Iterator iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            ((ITexRowListViewer)iterator.next()).insertRow(row);
        }
        return row;
    }

    public TexRow insertRow(int index) {
        return this.insertRow(index, new TexRow());
    }

    public int indexOf(TexRow row) {
        return this.rows.indexOf(row);
    }

    public void removeRow(TexRow row) {
        this.rows.remove(row);
        Iterator iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            ((ITexRowListViewer)iterator.next()).removeRow(row);
        }
    }

    public void rowChanged(TexRow row) {
        Iterator iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            ((ITexRowListViewer)iterator.next()).updateRow(row);
        }
    }

    public void removeChangeListener(ITexRowListViewer viewer) {
        this.changeListeners.remove(viewer);
    }

    public void addChangeListener(ITexRowListViewer viewer) {
        this.changeListeners.add(viewer);
    }

    private String readItemFromTexTableLine(String source, int index) {
        int end = source.indexOf("&", index);
        while (end > 0) {
            int check = source.lastIndexOf("\\", end);
            if (check + 1 != end) break;
            end = source.indexOf("&", end + 1);
        }
        if (end == -1) {
            return source.substring(index);
        }
        return source.substring(index, end + 1);
    }

    private String readTexTableLine(String source, int index) {
        int end = source.indexOf("\\\\", index);
        if (end == -1) {
            return source.substring(index);
        }
        return source.substring(index, end + 2);
    }

    public void importSelection(TexSelections selection, int importAt) {
        int index = 0;
        int row = importAt;
        String s = String.valueOf(selection.getCompleteLines()) + "\n";
        s = s.replaceAll("%.*\n", "\n");
        s = s.replaceAll("\n\r*", " ");
        while (index < s.length()) {
            if (row >= this.rows.size()) {
                this.addRow();
            }
            if (!((TexRow)this.rows.get(row)).empty()) {
                this.insertRow(row);
            }
            String line = this.readTexTableLine(s, index);
            index += line.length();
            line = line.trim();
            while (line.startsWith("\\")) {
                String tmps;
                int tmpi = line.indexOf(" ");
                if (tmpi == -1 || (tmps = line.substring(0, tmpi)).indexOf("line") == -1) break;
                line = line.substring(tmpi);
            }
            if (line.endsWith("\\\\")) {
                line = line.substring(0, line.length() - 2);
            }
            if (line.endsWith("&")) {
                line = String.valueOf(line) + " ";
            }
            int index2 = 0;
            int column = 0;
            while (index2 < line.length() && column < 32) {
                String item = this.readItemFromTexTableLine(line, index2);
                index2 += item.length();
                if ((item = item.trim()).endsWith("&")) {
                    item = item.substring(0, item.length() - 1);
                }
                if ("".equals(item)) {
                    item = "&";
                }
                ((TexRow)this.rows.get(row)).setCol(column, item);
                ++column;
            }
            this.rowChanged((TexRow)this.rows.get(row));
            ++row;
        }
    }

    public void clearAll() {
        int i = 0;
        while (i < this.rows.size()) {
            ((TexRow)this.rows.get(i)).clear();
            this.rowChanged((TexRow)this.rows.get(i));
            ++i;
        }
    }

    public String export() {
        String value = "";
        int i = 0;
        while (i < this.rows.size()) {
            TexRow row = (TexRow)this.rows.get(i);
            int lastCol = row.lastColumn();
            if (lastCol != -1) {
                boolean first = true;
                boolean amp = false;
                int j = 0;
                while (j <= lastCol) {
                    String s = row.getCol(j).trim();
                    if (s.compareTo("&") == 0) {
                        value = first ? String.valueOf(value) + s : String.valueOf(value) + " " + s;
                        first = false;
                        amp = true;
                    } else if (first) {
                        value = String.valueOf(value) + s;
                        first = false;
                    } else {
                        value = !amp ? String.valueOf(value) + " & " + s : String.valueOf(value) + " " + s;
                        amp = false;
                    }
                    ++j;
                }
                value = String.valueOf(value) + "\\\\\n";
            }
            ++i;
        }
        return value;
    }

    public String exportRaw() {
        String value = "";
        int i = 0;
        while (i < this.rows.size()) {
            TexRow row = (TexRow)this.rows.get(i);
            int lastCol = row.lastColumn();
            if (lastCol != -1) {
                boolean first = true;
                int j = 0;
                while (j <= lastCol) {
                    String s = row.getCol(j).trim();
                    if (s.compareTo("&") == 0) {
                        value = String.valueOf(value) + "\t" + s;
                    } else if (first) {
                        value = String.valueOf(value) + s;
                        first = false;
                    } else {
                        value = String.valueOf(value) + "\t" + s;
                    }
                    ++j;
                }
                value = String.valueOf(value) + "\n";
            }
            ++i;
        }
        return value;
    }

    public void flipRowsAndColumns() {
        if (this.rows.size() >= 32) {
            TexlipsePlugin.stat("Flipping rows and columns in LaTeX Table View for more than " + Integer.toString(32) + " rows is not supported.");
            return;
        }
        int column = 0;
        while (column < 32) {
            int row = 0;
            while (row < column && row < this.rows.size()) {
                boolean swap = false;
                TexRow texRow = (TexRow)this.rows.get(row);
                if (texRow.getCol(column).length() > 0) {
                    swap = true;
                }
                if (this.rows.size() > column && ((TexRow)this.rows.get(column)).getCol(row).length() > 0) {
                    swap = true;
                }
                if (swap) {
                    while (this.rows.size() <= column) {
                        this.addRow();
                    }
                    String s = texRow.getCol(column);
                    texRow.setCol(column, ((TexRow)this.rows.get(column)).getCol(row));
                    ((TexRow)this.rows.get(column)).setCol(row, s);
                }
                ++row;
            }
            ++column;
        }
        int i = 0;
        while (i < this.rows.size()) {
            this.rowChanged((TexRow)this.rows.get(i));
            ++i;
        }
    }

    public void mirrorColumns() {
        int j;
        TexRow row;
        int last = 0;
        int i = 0;
        while (i < this.rows.size()) {
            row = (TexRow)this.rows.get(i);
            j = last;
            while (j < 32) {
                if (row.getCol(j).length() > 0) {
                    last = j;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.rows.size()) {
            row = (TexRow)this.rows.get(i);
            j = 0;
            while (j < (last + 1) / 2) {
                String s = row.getCol(j);
                row.setCol(j, row.getCol(last - j));
                row.setCol(last - j, s);
                ++j;
            }
            this.rowChanged(row);
            ++i;
        }
    }

    public void mirrorRows() {
        TexRow row1;
        int last = 0;
        int i = 0;
        while (i < this.rows.size()) {
            row1 = (TexRow)this.rows.get(i);
            if (!row1.empty()) {
                last = i;
            }
            ++i;
        }
        i = 0;
        while (i < (last + 1) / 2) {
            row1 = (TexRow)this.rows.get(i);
            TexRow row2 = (TexRow)this.rows.get(last - i);
            int j = 0;
            while (j < 32) {
                String s = row1.getCol(j);
                row1.setCol(j, row2.getCol(j));
                row2.setCol(j, s);
                ++j;
            }
            this.rowChanged(row1);
            this.rowChanged(row2);
            ++i;
        }
    }

    public void move(TexRow row, int toIndex) {
        int fromIndex = this.indexOf(row);
        if (fromIndex < 0 || toIndex < 0 || toIndex >= this.rows.size()) {
            return;
        }
        if (toIndex > fromIndex) {
            --toIndex;
        }
        this.removeRow(row);
        this.insertRow(toIndex, row);
    }

    public double sum(int column, int row, int width, int height) {
        double value = 0.0;
        int i = row;
        while (i < this.rows.size() && i < row + height) {
            if (i >= 0) {
                TexRow texRow = (TexRow)this.rows.get(i);
                int j = column;
                while (j < 32 && j < column + width) {
                    if (j >= 0) {
                        try {
                            value += Double.parseDouble(texRow.getCol(j));
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    ++j;
                }
            }
            ++i;
        }
        return value;
    }

    public double sum(int column, int row, int direction) {
        switch (direction) {
            case 1: {
                return this.sum(column, 0, 1, row);
            }
            case 2: {
                return this.sum(column, row + 1, 1, this.rows.size() - row - 1);
            }
            case 3: {
                return this.sum(0, row, column, 1);
            }
            case 4: {
                return this.sum(column + 1, row, 32 - column - 1, 1);
            }
        }
        return 0.0;
    }

    public void copy(TexRow row, int index) {
        this.insertRow(index, new TexRow(row));
    }
}

