/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.spelling;

import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.properties.TexlipsePreferencePage;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class SpellCheckerPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private DirectoryFieldEditor customDictDir;
    private DirectoryFieldEditor dictDir;

    public SpellCheckerPreferencePage() {
        super(1);
        this.setPreferenceStore(TexlipsePlugin.getDefault().getPreferenceStore());
        this.setDescription(TexlipsePlugin.getResourceString("preferenceSpellPageDescription"));
    }

    protected void createFieldEditors() {
        TexlipsePreferencePage.addSpacer(3, this.getFieldEditorParent());
        final Group group = new Group(this.getFieldEditorParent(), 0);
        group.setText(TexlipsePlugin.getResourceString("preferenceSpellBuildIn"));
        group.setLayout((Layout)new GridLayout());
        GridData layData = new GridData(4, 0, true, true);
        layData.horizontalSpan = 3;
        group.setLayoutData((Object)layData);
        TexlipsePreferencePage.addSpacer(1, (Composite)group);
        BooleanFieldEditor buildInSpell = new BooleanFieldEditor("eclipseBuildInSpellChecker", TexlipsePlugin.getResourceString("preferenceSpellUseBuildIn"), (Composite)group){

            protected void valueChanged(boolean oldValue, boolean newValue) {
                super.valueChanged(oldValue, newValue);
                SpellCheckerPreferencePage.this.customDictDir.setEnabled(newValue, (Composite)group);
                SpellCheckerPreferencePage.this.dictDir.setEnabled(newValue, (Composite)group);
            }
        };
        BooleanFieldEditor ignoreComments = new BooleanFieldEditor("spellcheckerIgnoreComments", TexlipsePlugin.getResourceString("preferenceSpellIgnoreComments"), (Composite)group);
        BooleanFieldEditor ignoreMixedCase = new BooleanFieldEditor("spellcheckerIgnoreMixedCase", TexlipsePlugin.getResourceString("preferenceSpellIgnoreMixedCase"), (Composite)group);
        this.addField((FieldEditor)ignoreMixedCase);
        TexlipsePreferencePage.addSpacer(3, (Composite)group);
        this.dictDir = new DirectoryFieldEditor("spellcheckerDictDir", TexlipsePlugin.getResourceString("preferenceSpellDictDir"), (Composite)group);
        this.dictDir.setEnabled(TexlipsePlugin.getDefault().getPreferenceStore().getBoolean("eclipseBuildInSpellChecker"), (Composite)group);
        this.customDictDir = new DirectoryFieldEditor("spellcheckerCustomDictDir", TexlipsePlugin.getResourceString("preferenceSpellCustomDict"), (Composite)group);
        this.customDictDir.setEnabled(TexlipsePlugin.getDefault().getPreferenceStore().getBoolean("eclipseBuildInSpellChecker"), (Composite)group);
        this.addField((FieldEditor)buildInSpell);
        this.addField((FieldEditor)this.dictDir);
        this.addField((FieldEditor)this.customDictDir);
        this.addField((FieldEditor)ignoreComments);
        TexlipsePreferencePage.addSpacer(3, (Composite)group);
        Group aspellGroup = new Group(this.getFieldEditorParent(), 0);
        aspellGroup.setText(TexlipsePlugin.getResourceString("preferenceSpellAspell"));
        aspellGroup.setLayout((Layout)new GridLayout());
        GridData aspellLayData = new GridData(4, 0, true, true);
        aspellLayData.horizontalSpan = 3;
        aspellGroup.setLayoutData((Object)aspellLayData);
        TexlipsePreferencePage.addSpacer(3, (Composite)aspellGroup);
        this.addField((FieldEditor)new FileFieldEditor("spellCmd", TexlipsePlugin.getResourceString("preferenceSpellCommandLabel"), (Composite)aspellGroup));
        Composite c = new Composite((Composite)aspellGroup, 0);
        c.setLayout((Layout)new GridLayout(3, false));
        GridData layData2 = new GridData();
        layData2.horizontalSpan = 2;
        c.setLayoutData((Object)layData2);
        this.addField((FieldEditor)new StringFieldEditor("spellArgs", TexlipsePlugin.getResourceString("preferenceSpellArgumentsLabel"), c));
    }

    public void init(IWorkbench workbench) {
    }
}

