/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.outline;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.editor.TexEditor;
import net.sourceforge.texlipse.model.OutlineNode;
import net.sourceforge.texlipse.model.TexOutlineInput;
import net.sourceforge.texlipse.outline.TexContentProvider;
import net.sourceforge.texlipse.outline.TexLabelProvider;
import net.sourceforge.texlipse.outline.TexOutlineActionCopy;
import net.sourceforge.texlipse.outline.TexOutlineActionCut;
import net.sourceforge.texlipse.outline.TexOutlineActionDelete;
import net.sourceforge.texlipse.outline.TexOutlineActionPaste;
import net.sourceforge.texlipse.outline.TexOutlineActionUpdate;
import net.sourceforge.texlipse.outline.TexOutlineDNDAdapter;
import net.sourceforge.texlipse.outline.TexOutlineFilter;
import net.sourceforge.texlipse.outline.TexOutlineNodeComparer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class TexOutlinePage
extends ContentOutlinePage {
    private static final String ACTION_COPY = "copy";
    private static final String ACTION_CUT = "cut";
    private static final String ACTION_PASTE = "paste";
    private static final String ACTION_DELETE = "delete";
    private static final String ACTION_UPDATE = "update";
    private static final String ACTION_COLLAPSE = "collapse";
    private static final String ACTION_EXPAND = "expand";
    private static final String ACTION_HIDE_SEC = "hideSec";
    private static final String ACTION_HIDE_SUBSEC = "hideSubSec";
    private static final String ACTION_HIDE_SUBSUBSEC = "hideSubSubSec";
    private static final String ACTION_HIDE_PARAGRAPH = "hidePara";
    private static final String ACTION_HIDE_FLOAT = "hideFloat";
    private static final String ACTION_HIDE_LABEL = "hideLabel";
    private TexOutlineInput input;
    private TexEditor editor;
    private TexOutlineFilter filter;
    private Clipboard clipboard;
    private int expandLevel;
    private Map<String, IAction> outlineActions;

    public TexOutlinePage(TexEditor texEditor) {
        this.editor = texEditor;
        this.expandLevel = 1;
        this.outlineActions = new HashMap<String, IAction>();
        TexlipsePlugin.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getProperty();
                if ("outlinePart".equals(property) || "outlineChapter".equals(property) || "outlineSection".equals(property) || "outlineSubSection".equals(property) || "outlineSubSubSection".equals(property) || "outlineParagraph".equals(property) || "outlineEnvs".equals(property)) {
                    Control control;
                    TexOutlinePage.this.getOutlinePreferences();
                    TexOutlinePage.this.resetToolbarButtons();
                    TreeViewer viewer = TexOutlinePage.this.getTreeViewer();
                    if (viewer != null && (control = viewer.getControl()) != null && !control.isDisposed()) {
                        viewer.refresh();
                    }
                }
            }
        });
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.createActions();
        TreeViewer viewer = this.getTreeViewer();
        this.filter = new TexOutlineFilter();
        viewer.setContentProvider((IContentProvider)new TexContentProvider(this.filter));
        viewer.setLabelProvider((IBaseLabelProvider)new TexLabelProvider());
        viewer.setComparer((IElementComparer)new TexOutlineNodeComparer());
        this.getOutlinePreferences();
        viewer.addFilter((ViewerFilter)this.filter);
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        TexOutlineDNDAdapter dndAdapter = new TexOutlineDNDAdapter((Viewer)viewer, this);
        int ops = 3;
        Transfer[] transfers = new Transfer[]{TextTransfer.getInstance()};
        viewer.addDragSupport(ops, transfers, (DragSourceListener)dndAdapter);
        viewer.addDropSupport(ops, transfers, (DropTargetListener)dndAdapter);
        this.initCopyPaste(viewer);
        this.createToolbar();
        this.resetToolbarButtons();
        this.createContextMenu();
        if (this.input != null) {
            viewer.setInput(this.input.getRootNodes());
            this.outlineActions.get(ACTION_UPDATE).setEnabled(false);
            this.outlineActions.get(ACTION_COPY).setEnabled(true);
            this.outlineActions.get(ACTION_CUT).setEnabled(true);
            this.outlineActions.get(ACTION_PASTE).setEnabled(true);
            this.outlineActions.get(ACTION_DELETE).setEnabled(true);
        }
    }

    public void setFocus() {
        this.getTreeViewer().getTree().setFocus();
    }

    public void update(TexOutlineInput input) {
        Control control;
        this.input = input;
        TreeViewer viewer = this.getTreeViewer();
        if (viewer != null && (control = viewer.getControl()) != null && !control.isDisposed()) {
            control.setRedraw(false);
            viewer.getTree().deselectAll();
            Object[] expandedElements = viewer.getExpandedElements();
            viewer.setInput(input.getRootNodes());
            viewer.setExpandedElements(expandedElements);
            control.setRedraw(true);
            this.outlineActions.get(ACTION_UPDATE).setEnabled(false);
            this.outlineActions.get(ACTION_COPY).setEnabled(true);
            this.outlineActions.get(ACTION_CUT).setEnabled(true);
            this.outlineActions.get(ACTION_PASTE).setEnabled(true);
            this.outlineActions.get(ACTION_DELETE).setEnabled(true);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        super.selectionChanged(event);
        ISelection selection = event.getSelection();
        if (selection.isEmpty()) {
            this.editor.resetHighlightRange();
        } else {
            OutlineNode node = (OutlineNode)((IStructuredSelection)selection).getFirstElement();
            Position position = node.getPosition();
            if (position != null) {
                try {
                    this.editor.setHighlightRange(position.getOffset(), position.getLength(), true);
                    this.editor.getViewer().revealRange(position.getOffset(), position.getLength());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.editor.resetHighlightRange();
                }
            } else {
                this.editor.resetHighlightRange();
            }
        }
    }

    public String getSelectedText() {
        String text;
        IStructuredSelection selection = (IStructuredSelection)this.getTreeViewer().getSelection();
        if (selection == null) {
            return null;
        }
        OutlineNode node = (OutlineNode)selection.getFirstElement();
        Position pos = node.getPosition();
        try {
            text = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput()).get(pos.getOffset(), pos.getLength());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        return text;
    }

    public void removeSelectedText() {
        IStructuredSelection selection = (IStructuredSelection)this.getTreeViewer().getSelection();
        if (selection == null) {
            return;
        }
        OutlineNode node = (OutlineNode)selection.getFirstElement();
        Position pos = node.getPosition();
        try {
            this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput()).replace(pos.getOffset(), pos.getLength(), "");
        }
        catch (BadLocationException badLocationException) {
            return;
        }
        this.editor.updateModelNow();
    }

    public void dispose() {
        super.dispose();
        this.clipboard.dispose();
        this.clipboard = null;
    }

    public boolean paste(String text) {
        IStructuredSelection selection = (IStructuredSelection)this.getTreeViewer().getSelection();
        if (selection == null) {
            return false;
        }
        OutlineNode node = (OutlineNode)selection.getFirstElement();
        Position pos = node.getPosition();
        try {
            this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput()).replace(pos.getOffset() + pos.getLength(), 0, text);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
        this.editor.updateModelNow();
        return true;
    }

    public void modelGotDirty() {
        this.outlineActions.get(ACTION_UPDATE).setEnabled(true);
        this.outlineActions.get(ACTION_COPY).setEnabled(false);
        this.outlineActions.get(ACTION_CUT).setEnabled(false);
        this.outlineActions.get(ACTION_PASTE).setEnabled(false);
        this.outlineActions.get(ACTION_DELETE).setEnabled(false);
    }

    public boolean isModelDirty() {
        return this.editor.isModelDirty();
    }

    public TexEditor getEditor() {
        return this.editor;
    }

    public void setEditor(TexEditor editor) {
        this.editor = editor;
    }

    public Clipboard getClipboard() {
        return this.clipboard;
    }

    private IAction createHideAction(String desc, final int nodeType, ImageDescriptor img) {
        Action action = new Action(desc, 2){

            public void run() {
                boolean oldState = TexOutlinePage.this.filter.isTypeVisible(nodeType);
                TexOutlinePage.this.filter.toggleType(nodeType, !oldState);
                TreeViewer viewer = TexOutlinePage.this.getTreeViewer();
                if (!oldState) {
                    TexOutlinePage.this.revealNodes(nodeType);
                }
                viewer.refresh();
            }
        };
        action.setToolTipText(desc);
        action.setImageDescriptor(img);
        return action;
    }

    private void createActions() {
        TexOutlineActionCut cut = new TexOutlineActionCut(this);
        this.outlineActions.put(ACTION_CUT, (IAction)cut);
        TexOutlineActionCopy copy = new TexOutlineActionCopy(this);
        this.outlineActions.put(ACTION_COPY, (IAction)copy);
        TexOutlineActionPaste paste = new TexOutlineActionPaste(this);
        this.outlineActions.put(ACTION_PASTE, (IAction)paste);
        TexOutlineActionDelete delete = new TexOutlineActionDelete(this);
        this.outlineActions.put(ACTION_DELETE, (IAction)delete);
        TexOutlineActionUpdate update = new TexOutlineActionUpdate(this);
        this.outlineActions.put(ACTION_UPDATE, (IAction)update);
        Action collapse = new Action("Collapse one level", 1){

            public void run() {
                if (TexOutlinePage.this.expandLevel > 1) {
                    TexOutlinePage texOutlinePage = TexOutlinePage.this;
                    texOutlinePage.expandLevel = texOutlinePage.expandLevel - 1;
                    TexOutlinePage.this.getTreeViewer().collapseAll();
                    TexOutlinePage.this.getTreeViewer().expandToLevel(TexOutlinePage.this.expandLevel);
                }
            }
        };
        collapse.setToolTipText("Collapse one level");
        collapse.setImageDescriptor(TexlipsePlugin.getImageDescriptor(ACTION_COLLAPSE));
        this.outlineActions.put(ACTION_COLLAPSE, (IAction)collapse);
        Action expand = new Action("Expand one level", 1){

            public void run() {
                if (TexOutlinePage.this.expandLevel < TexOutlinePage.this.input.getTreeDepth()) {
                    TexOutlinePage texOutlinePage = TexOutlinePage.this;
                    texOutlinePage.expandLevel = texOutlinePage.expandLevel + 1;
                }
                TexOutlinePage.this.getTreeViewer().collapseAll();
                TexOutlinePage.this.getTreeViewer().expandToLevel(TexOutlinePage.this.expandLevel);
            }
        };
        expand.setToolTipText("Expand one level");
        expand.setImageDescriptor(TexlipsePlugin.getImageDescriptor(ACTION_EXPAND));
        this.outlineActions.put(ACTION_EXPAND, (IAction)expand);
        IAction action = this.createHideAction("Hide sections", 2, TexlipsePlugin.getImageDescriptor("hide_sec"));
        this.outlineActions.put(ACTION_HIDE_SEC, action);
        action = this.createHideAction("Hide subsections", 3, TexlipsePlugin.getImageDescriptor("hide_sub"));
        this.outlineActions.put(ACTION_HIDE_SUBSEC, action);
        action = this.createHideAction("Hide subsubsections", 4, TexlipsePlugin.getImageDescriptor("hide_subsub"));
        this.outlineActions.put(ACTION_HIDE_SUBSUBSEC, action);
        action = this.createHideAction("Hide paragraphs", 5, TexlipsePlugin.getImageDescriptor("hide_para"));
        this.outlineActions.put(ACTION_HIDE_PARAGRAPH, action);
        action = this.createHideAction("Hide floating environments", 13, TexlipsePlugin.getImageDescriptor("hide_env"));
        this.outlineActions.put(ACTION_HIDE_FLOAT, action);
        action = this.createHideAction("Hide labels", 20, TexlipsePlugin.getImageDescriptor("hide_label"));
        this.outlineActions.put(ACTION_HIDE_LABEL, action);
    }

    private void initCopyPaste(TreeViewer viewer) {
        this.clipboard = new Clipboard(this.getSite().getShell().getDisplay());
        IActionBars bars = this.getSite().getActionBars();
        bars.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)((Action)this.outlineActions.get(ACTION_CUT)));
        bars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)((Action)this.outlineActions.get(ACTION_COPY)));
        bars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)((Action)this.outlineActions.get(ACTION_PASTE)));
        bars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)((Action)this.outlineActions.get(ACTION_DELETE)));
    }

    private void getOutlinePreferences() {
        String[] environments;
        this.filter.reset();
        boolean preamble = TexlipsePlugin.getDefault().getPreferenceStore().getBoolean("outlinePreamble");
        boolean part = TexlipsePlugin.getDefault().getPreferenceStore().getBoolean("outlinePart");
        boolean chapter = TexlipsePlugin.getDefault().getPreferenceStore().getBoolean("outlineChapter");
        boolean section = TexlipsePlugin.getDefault().getPreferenceStore().getBoolean("outlineSection");
        boolean subsection = TexlipsePlugin.getDefault().getPreferenceStore().getBoolean("outlineSubSection");
        boolean subsubsection = TexlipsePlugin.getDefault().getPreferenceStore().getBoolean("outlineSubSubSection");
        boolean paragraph = TexlipsePlugin.getDefault().getPreferenceStore().getBoolean("outlineParagraph");
        if (preamble) {
            this.filter.toggleType(14, true);
        }
        if (part) {
            this.filter.toggleType(0, true);
        }
        if (chapter) {
            this.filter.toggleType(1, true);
        }
        if (section) {
            this.filter.toggleType(2, true);
        }
        if (subsection) {
            this.filter.toggleType(3, true);
        }
        if (subsubsection) {
            this.filter.toggleType(4, true);
        }
        if (paragraph) {
            this.filter.toggleType(5, true);
        }
        this.filter.toggleType(13, true);
        this.filter.toggleType(20, true);
        String[] stringArray = environments = TexlipsePlugin.getPreferenceArray("outlineEnvs");
        int n = environments.length;
        int n2 = 0;
        while (n2 < n) {
            String env = stringArray[n2];
            this.filter.toggleEnvironment(env, true);
            ++n2;
        }
    }

    private void fillContextMenu(IMenuManager mgr) {
        mgr.add(this.outlineActions.get(ACTION_COPY));
        mgr.add(this.outlineActions.get(ACTION_CUT));
        mgr.add(this.outlineActions.get(ACTION_PASTE));
        mgr.add((IContributionItem)new Separator());
        mgr.add(this.outlineActions.get(ACTION_DELETE));
    }

    private void resetToolbarButtons() {
        this.outlineActions.get(ACTION_HIDE_SEC).setChecked(!this.filter.isTypeVisible(2));
        this.outlineActions.get(ACTION_HIDE_SUBSEC).setChecked(!this.filter.isTypeVisible(3));
        this.outlineActions.get(ACTION_HIDE_SUBSUBSEC).setChecked(!this.filter.isTypeVisible(4));
        this.outlineActions.get(ACTION_HIDE_PARAGRAPH).setChecked(!this.filter.isTypeVisible(5));
        this.outlineActions.get(ACTION_HIDE_FLOAT).setChecked(!this.filter.isTypeVisible(13));
        this.outlineActions.get(ACTION_HIDE_LABEL).setChecked(!this.filter.isTypeVisible(20));
    }

    public void switchTreeViewerSelectionChangeListener(ISelectionChangedListener listener) {
        this.getTreeViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
        this.getTreeViewer().addSelectionChangedListener(listener);
    }

    public void reset() {
        this.expandLevel = 1;
    }

    private void createToolbar() {
        IToolBarManager toolbarManager = this.getSite().getActionBars().getToolBarManager();
        toolbarManager.add(this.outlineActions.get(ACTION_UPDATE));
        toolbarManager.add(this.outlineActions.get(ACTION_COLLAPSE));
        toolbarManager.add(this.outlineActions.get(ACTION_EXPAND));
        toolbarManager.add(this.outlineActions.get(ACTION_HIDE_SEC));
        toolbarManager.add(this.outlineActions.get(ACTION_HIDE_SUBSEC));
        toolbarManager.add(this.outlineActions.get(ACTION_HIDE_SUBSUBSEC));
        toolbarManager.add(this.outlineActions.get(ACTION_HIDE_PARAGRAPH));
        toolbarManager.add(this.outlineActions.get(ACTION_HIDE_FLOAT));
        toolbarManager.add(this.outlineActions.get(ACTION_HIDE_LABEL));
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                TexOutlinePage.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.getTreeViewer().getControl());
        this.getTreeViewer().getControl().setMenu(menu);
    }

    private void revealNodes(int nodeType) {
        List<OutlineNode> nodeList = this.input.getTypeList(nodeType);
        if (nodeList != null) {
            for (OutlineNode node : nodeList) {
                this.getTreeViewer().reveal((Object)node);
            }
        }
    }
}

