/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.model;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import net.sourceforge.texlipse.model.AbstractEntry;

public final class ReferenceEntry
extends AbstractEntry {
    public String info;
    public int endLine;
    public String author;
    public String journal;
    public String year;
    public File refFile;
    private int labelPrecedingLines = 2;
    private int labelFollowingLines = 2;

    public ReferenceEntry(String key) {
        this.key = key;
    }

    public ReferenceEntry(String key, String info) {
        this.key = key;
        this.info = info;
    }

    public AbstractEntry copy() {
        ReferenceEntry re = new ReferenceEntry(this.key, this.info);
        re.startLine = this.startLine;
        re.endLine = this.endLine;
        re.author = this.author;
        re.journal = this.journal;
        re.year = this.year;
        re.refFile = this.refFile;
        re.fileName = this.fileName;
        re.position = this.position;
        return re;
    }

    public String toString() {
        return this.key;
    }

    public void setLabelInfo(String input) {
        int lineno = this.startLine;
        StringBuilder extract = new StringBuilder();
        try {
            String str;
            BufferedReader in = new BufferedReader(new StringReader(input));
            int currentLine = 0;
            int startLine = lineno - this.labelPrecedingLines >= 0 ? lineno - this.labelPrecedingLines : 0;
            int endLine = lineno + this.labelFollowingLines;
            while ((str = in.readLine()) != null) {
                if (currentLine > endLine) break;
                if (currentLine >= startLine) {
                    extract.append(str);
                    extract.append(System.getProperty("line.separator"));
                }
                ++currentLine;
            }
            in.close();
        }
        catch (IOException iOException) {}
        this.info = extract.toString();
    }
}

