/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.builder;

import java.io.File;
import java.util.StringTokenizer;
import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.builder.AbstractProgramRunner;
import net.sourceforge.texlipse.properties.TexlipseProperties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class BibtexRunner
extends AbstractProgramRunner {
    protected String getWindowsProgramName() {
        return "bibtex.exe";
    }

    protected String getUnixProgramName() {
        return "bibtex";
    }

    public String getDescription() {
        return "Bibtex program";
    }

    protected String[] getQueryString() {
        return new String[]{"Please type input file name (no extension)--"};
    }

    public String getArguments(IResource resource) {
        String name;
        String baseName;
        String args = super.getArguments(resource);
        int bPos = args.indexOf(String.valueOf(baseName = (name = resource.getName()).substring(0, name.lastIndexOf(46))) + "." + this.getInputFormat());
        if (bPos >= 0) {
            args = String.valueOf(args.substring(0, bPos + baseName.length())) + args.substring(bPos + baseName.length() + 1 + this.getInputFormat().length());
        }
        return args;
    }

    private String getIncludeDirArguments(IResource project) {
        String[] bibs = (String[])TexlipseProperties.getSessionProperty(project, "bibFiles");
        if (bibs == null) {
            return " ";
        }
        String bibDirs = TexlipsePlugin.getDefault().getPreferenceStore().getString("bibDir");
        if (bibDirs == null) {
            bibDirs = "";
        }
        Boolean biblatexMode = (Boolean)TexlipseProperties.getSessionProperty(project, "biblatexMode");
        String aDir = TexlipseProperties.getProjectProperty(project, "bibFiles");
        if (aDir == null) {
            aDir = "";
        }
        String pDir = project.getLocation().toOSString();
        String[] dirs = (String.valueOf(bibDirs) + aDir + File.pathSeparatorChar + pDir).split(File.pathSeparator);
        if (dirs == null) {
            dirs = new String[]{};
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < bibs.length) {
            int j = 0;
            while (j < dirs.length) {
                String bibPath = biblatexMode == null ? String.valueOf(dirs[j]) + bibs[i] + ".bib" : String.valueOf(dirs[j]) + bibs[i];
                File b = new File(bibPath);
                if (b.exists()) {
                    sb.append(" -include-dir=");
                    sb.append(dirs[j]);
                }
                ++j;
            }
            ++i;
        }
        sb.append(' ');
        return sb.toString();
    }

    public String getInputFormat() {
        return "bib";
    }

    public String getOutputFormat() {
        return "aux";
    }

    protected boolean parseErrors(IResource origResource, String output) {
        IProject project = origResource.getProject();
        IContainer sourceDir = TexlipseProperties.getProjectSourceDir(project);
        if (sourceDir == null) {
            sourceDir = project;
        }
        IResource bibResource = origResource;
        boolean errorsFound = false;
        StringTokenizer st = new StringTokenizer(output, "\r\n");
        while (st.hasMoreTokens()) {
            String bibName;
            String line = st.nextToken();
            if (line.indexOf("I was expecting a ") == 0) {
                this.parseErrorLine(sourceDir, line);
                errorsFound = true;
                continue;
            }
            if (line.startsWith("You're missing a field name")) {
                this.parseErrorLine(sourceDir, line);
                errorsFound = true;
                continue;
            }
            if (line.startsWith("Warning--")) {
                String message = line.substring(9);
                Integer lineNumber = null;
                String nextLine = st.nextToken();
                if (nextLine.startsWith("--line ")) {
                    int index = nextLine.indexOf(" of file ");
                    try {
                        lineNumber = new Integer(nextLine.substring(7, index));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    String fileName = nextLine.substring(index + 9);
                    IResource resource = sourceDir.findMember(fileName);
                    BibtexRunner.createMarker(resource, lineNumber, message, 1);
                    continue;
                }
                if (nextLine.startsWith("Warning--")) {
                    BibtexRunner.createMarker(bibResource, lineNumber, message, 1);
                    BibtexRunner.createMarker(bibResource, lineNumber, nextLine.substring(9), 1);
                    continue;
                }
                BibtexRunner.createMarker(bibResource, lineNumber, message, 1);
                continue;
            }
            if (line.startsWith("Database file ")) {
                bibName = line.substring(line.indexOf(58) + 2);
                bibResource = sourceDir.findMember(bibName);
                if (bibResource != null) continue;
                bibResource = origResource;
                continue;
            }
            if (!line.startsWith("I couldn't open database file ")) continue;
            bibName = line.substring(line.indexOf("file") + 5);
            String srcFile = TexlipseProperties.getProjectProperty((IResource)project, "mainTexFile");
            IResource mainFileResource = sourceDir.findMember(srcFile);
            BibtexRunner.createMarker(mainFileResource, new Integer(0), "Could not open bibtex database file " + bibName);
            return true;
        }
        return errorsFound;
    }

    private void parseErrorLine(IContainer sourceDir, String line) {
        int index = line.indexOf("---line ");
        int index2 = line.indexOf(" of file ", index);
        String lineNumberString = line.substring(index + 8, index2);
        Integer lineNumber = null;
        try {
            int num = Integer.parseInt(lineNumberString);
            lineNumber = new Integer(num);
        }
        catch (NumberFormatException numberFormatException) {}
        String fileName = line.substring(index2 + 9);
        IResource resource = sourceDir.findMember(fileName);
        String error = line.substring(0, index);
        BibtexRunner.createMarker(resource, lineNumber, error);
    }
}

