#[derive(Debug, PartialEq, Eq, Clone, Copy, Hash, PartialOrd, Ord)]
#[allow(non_camel_case_types)]
#[repr(u16)]
pub enum SyntaxKind {
    ERROR = 0,

    LINE_BREAK,
    WHITESPACE,
    COMMENT,
    VERBATIM,
    L_CURLY,
    R_CURLY,
    L_BRACK,
    R_BRACK,
    L_PAREN,
    R_PAREN,
    COMMA,
    EQUALITY_SIGN,
    WORD,
    DOLLAR,
    COMMAND_NAME,

    PREAMBLE,
    TEXT,
    KEY,
    VALUE,
    KEY_VALUE_PAIR,
    KEY_VALUE_BODY,
    CURLY_GROUP,
    CURLY_GROUP_WORD,
    CURLY_GROUP_WORD_LIST,
    CURLY_GROUP_COMMAND,
    CURLY_GROUP_KEY_VALUE,
    BRACK_GROUP,
    BRACK_GROUP_WORD,
    BRACK_GROUP_KEY_VALUE,
    PAREN_GROUP,
    MIXED_GROUP,
    GENERIC_COMMAND,
    ENVIRONMENT,
    BEGIN,
    END,
    EQUATION,
    PART,
    CHAPTER,
    SECTION,
    SUBSECTION,
    SUBSUBSECTION,
    PARAGRAPH,
    SUBPARAGRAPH,
    ENUM_ITEM,
    FORMULA,
    CAPTION,
    CITATION,
    PACKAGE_INCLUDE,
    CLASS_INCLUDE,
    LATEX_INCLUDE,
    BIBLATEX_INCLUDE,
    BIBTEX_INCLUDE,
    GRAPHICS_INCLUDE,
    SVG_INCLUDE,
    INKSCAPE_INCLUDE,
    VERBATIM_INCLUDE,
    IMPORT,
    LABEL_DEFINITION,
    LABEL_REFERENCE,
    LABEL_REFERENCE_RANGE,
    LABEL_NUMBER,
    COMMAND_DEFINITION,
    MATH_OPERATOR,
    GLOSSARY_ENTRY_DEFINITION,
    GLOSSARY_ENTRY_REFERENCE,
    ACRONYM_DEFINITION,
    ACRONYM_DECLARATION,
    ACRONYM_REFERENCE,
    THEOREM_DEFINITION,
    COLOR_REFERENCE,
    COLOR_DEFINITION,
    COLOR_SET_DEFINITION,
    TIKZ_LIBRARY_IMPORT,
    ENVIRONMENT_DEFINITION,
    GRAPHICS_PATH,
    BLOCK_COMMENT,
    ROOT,
}

impl From<SyntaxKind> for rowan::SyntaxKind {
    fn from(kind: SyntaxKind) -> Self {
        Self(kind as u16)
    }
}
