#!/usr/bin/perl

# Copyright 2012-2020, Alexander Shibakov
# This file is part of SPLinT
#
# SPLinT is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# SPLinT is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with SPLinT.  If not, see <http://www.gnu.org/licenses/>.

# a simple script to remove comments and #line directives left by CTANGLE
# this allows one to build Makefiles and linker scripts from inside CWEB
# by making a few simple changes to the macros (to facilitate typeseting)
# and using CWEB's @= ... @> facility.

use Getopt::Long;
use Pod::Usage;

my $man = 0;
my $help = 0;

#Getopt::Long::Configure ("bundling"); # to allow -abc to set a, b, and c

GetOptions ("help|?" => \$help, 
             man => \$man,
    ) or pod2usage(2);

pod2usage(-exitval => 0, -verbose => 1) if $help;
pod2usage(-exitval => 0, -verbose => 2) if $man;

open FILE, "$ARGV[0]" or die "Cannot open input file $ARGV[0]\n";
open FILEOUT, ">$ARGV[1]" or die "Cannot open output file $ARGV[1]\n";

while (<FILE>) {

    $inline = $_;

    s/^(\#line.*)\n$//g; 

    if ( $ARGV[2] != 3 ) {

        s/\/\*([^\/]|\/[^\*])*\*\///g;

    }

    printf FILEOUT "%s", "$_"; 

#    if ( m/^.*\S.*\n$/ ) {

#	printf FILEOUT "%s", "$_"; 

#    }

}

__END__

=head1 UNLINE

unline.pl - Remove B<C> comments from a file

=head1 SYNOPSIS

unline.pl [options] input_file output_file


 Options:
   --help|-h|-?      brief help message
   --man|-m          full documentation

=head1 OPTIONS

=over 8

=item B<--help>

Print a brief help message and exit.

=item B<--man>

Print the manual page and exit.

=back

=head1 DESCRIPTION

B<unline.pl> will read the given <input_file>, remove the B<C> comments
and output the resulting file in <output_file>

=cut
