# Copyright 2012-2020, Alexander Shibakov
# This file is part of SPLinT
#
# SPLinT is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# SPLinT is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with SPLinT.  If not, see <http://www.gnu.org/licenses/>.

SPLINT_ROOT := $(dir $(CURDIR)/$(word $(words $(MAKEFILE_LIST)),$(MAKEFILE_LIST)))
# taken from a stackoverflow answer by Xavier Holt

TEXINPUTS := .:${SPLINT_ROOT}cweb/:${SPLINT_ROOT}tex/:${SPLINT_ROOT}:${TEXINPUTS}

SPLINT_DRIVER_DIR = ${SPLINT_ROOT}cweb

SPLINT_TEXSTYLES  = flex.sty yyfaststack.sty yyparse.sty yyunion.sty yyinput.sty yystype.sty yy.sty
SPLINT_TEXSTYLES += yyinit.sty yybootstrap.sty dcols.sty limbo.sty yycommon.sty yymisc.sty yytexlex.sty
SPLINT_TEXSTYLES += yydebug.sty gindex.sty noweb.sty
SPLINT_BOOTSTRAP_STYLES = grabstates.sty
SPLINT_PTABLES = byytab.tex dyytab.tex fyytab.tex gyytab.tex fiptab.tex reptab.tex small_tab.tex
SPLINT_PTABLES += raptab.tex ddptab.tex
SPLINT_LTABLES = ltab.tex small_dfa.tex filtab.tex

SPLINT_XTEXSTYLES = $(patsubst %, ${SPLINT_ROOT}tex/%, ${SPLINT_TEXSTYLES})
SPLINT_XBOOTSTRAP_STYLES = $(patsubst %, ${SPLINT_ROOT}tex/%, ${SPLINT_BOOTSTRAP_STYLES})
SPLINT_XPTABLES = $(patsubst %, ${SPLINT_ROOT}cweb/%, ${SPLINT_PTABLES})
SPLINT_XLTABLES = $(patsubst %, ${SPLINT_ROOT}cweb/%, ${SPLINT_LTABLES})

SPLINT_DOC_PREREQS = %.tex ${SPLINT_PTABLES} ${SPLINT_LTABLES} ${SPLINT_XTEXSTYLES} 
SPLINT_DOC_PREREQS += ${SPLINT_ROOT}tex/btokenset.sty ${SPLINT_ROOT}tex/ftokenset.sty
SPLINT_DOC_PREREQS += ${SPLINT_ROOT}tex/stokenset.sty ${SPLINT_ROOT}tex/fretokenset.sty
SPLINT_DOC_PREREQS += bo.tok fo.tok
SPLINT_DOC_PREREQS_XREF = ${SPLINT_DOC_PREREQS} %.scn %.idx 

PDFTEX = export TEXINPUTS=${TEXINPUTS} && pdftex
TEX = export TEXINPUTS=${TEXINPUTS} && tex
DVIPS = dvips
PDFVIEW = evince
CWEAVE = cweave -bhp
CTANGLE = ctangle -bhp
BISON = ${BISON_ROOT}bison -v
FLEX = ${FLEX_ROOT}flex

MODEBOOTSTRAP = \\let\\ifbootstrapmode\\iftrue

BRACK = ${SPLINT_ROOT}scripts/brack.pl
UNLINE = ${SPLINT_ROOT}scripts/unline.pl
BINDX = ${SPLINT_ROOT}scripts/bindx.pl
MISCCW = ${SPLINT_ROOT}scripts/misccw.pl

%.c:		%.w
%.c:		%.y
%.pdf:		%.tex
%.ps:		%.dvi
%.o:		%.c
%.c:		%.l

%.x:		%.w
		${BRACK} $< $@

%.c:		%.y
		${BISON} $^ -o $@

%.c:		%.l
		${FLEX} -o $@ $^

%.l:		%.ll
		${UNLINE} $^ $@

%.y:		%.yy
		cp -f $^ $@

%.ps:		%.dvi
		${DVIPS} $^ -o $@

%.gdy:		%.gdx
		${BINDX} $^ $@

all:		docs

${SPLINT_ROOT}cweb/%:
		cd ${SPLINT_ROOT}cweb && ${MAKE} $(notdir $@)

clean_temp:	
	-rm -f  *.o *.tab.* *.dvi *.pdf *.ps *~ *.log *.rli *.rls *.lpg \
        *.output *.lst *.exl *.ftn *.*pk *.gdx

clean_core:   clean_temp
	-rm -f *.c *.h *.tex *.idx *.scn *.toc *.tok *.sns *.gdy *.xxr *.x \
	*.hx *.hy *.yy *.ll *.y *.l

# to ensure that interrupted and erroneous builds are cleaned up

.DELETE_ON_ERROR:  
