@q Copyright 2012-2020, Alexander Shibakov@>
@q This file is part of SPLinT@>

@q SPLinT is free software: you can redistribute it and/or modify@>
@q it under the terms of the GNU General Public License as published by@>
@q the Free Software Foundation, either version 3 of the License, or@>
@q (at your option) any later version.@>

@q SPLinT is distributed in the hope that it will be useful,@>
@q but WITHOUT ANY WARRANTY; without even the implied warranty of@>
@q MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the@>
@q GNU General Public License for more details.@>

@q You should have received a copy of the GNU General Public License@>
@q along with SPLinT.  If not, see <http://www.gnu.org/licenses/>.@>

@** The name parser for \ld\ term names. 
We take a lazy approach to the typeseting of term names for the \ld\
grammar by creating a dedicated parser for name processing. This way
any pattern we notice can be quickly incorporated into our typesetting scheme.
% We include the macros here since this file is intended to be
% included by the documentation `aggregator' so putting bare \TeX\
% at the beginning of the file runs the risk of producing an error
% of having \TeX\ material inside a \Cee\ section.
\genericprettytokens namespace: ldsmall, tokens: {}, correction: lstokenset.sty, host: ldsmall;
@(ld_small_parser.yy@>=
@G Switch to generic mode.
%{@> @<Name parser \Cee\ preamble@> @=%}
 @> @<Bison options@> @= 
%union {@> @<Union of parser types@> @=}
%{@> @<Name parser \Cee\ postamble@> @=%}
 @> @<Token and types ...@> @= 
%%
 @> @<Parser productions@> @= 
%%
@g

@ To put the new name parser to work, we need to initialize it. The
initialization is done by the macros below. After the initialization
has been completed, the switch command is replaced by the one that
activates the new name parser.
@<Modified name parser for \ld\ grammar@>=
@G(t)
\genericparser 
    name: ldsmall, 
    ptables: ld_small_tab.tex,
    ltables: ld_small_dfa.tex,
    tokens: {},
    asetup: {}, 
    dsetup: {}, 
    rsetup: \let\returnexplicitspace\ignoreexplicitspace, % ignore spaces in names
    optimization: {};%
\let\otosmallparser\tosmallparser % /* save the old name parser */
\let\tosmallparser\toldsmallparser
\expandafter\let\csname to\stripbrackets\cwebclinknamespace parser\endcsname\tosmallparser % 
/* make the name parser handle the typesetting of \Cee\ variables */
@g

@ @<Bison options@>=
@G
%token-table
%debug
%start full_name
@g

@ @<Token and types declarations@>=
@G
%token PERCENT_IDENTIFIER
%token IDENTIFIER
%token OPTIONAL
%token K_SUFFIX
%token INTEGER
%token EXTENDED
%token WILDCARD
%token META_IDENTIFIER
@g

@*1 The name parser productions. These macros do a bit more than we
need to typeset the term names. Their core is designed to treat
suffixes and prefixes of a certain form in a special way. In addition,
some productions were left in place from the original name parser in
order to be able to refer to, say, \flex\ options in text. The inline
action in one of the rules for \prodstyle{identifier\_string} was
added to adjust the number and the position of the terms so that the
appropriate action can be reused later for
\prodstyle{qualified\_identifier\_string}.
%\tracebadnamestrue 
%\tracenamestrue
%\traceparserstatestrue
%\tracestackstrue
%\tracerulestrue
%\traceactionstrue
%\tracelookaheadtrue
%\traceparseresultstrue
%\tracebadcharstrue
%\yyflexdebugtrue
@<Parser productions@>=
@G
full_name:
  identifier_string suffixes.opt                {@> @<Compose the full name@> @=}
| qualifier '_' identifier_string suffixes.opt  {@> @<Compose a qualified name@> @=}
| META_IDENTIFIER  {@> @<Turn a \prodstylens{META\_IDENTIFIER}{\ldsmallnamespace} into a full name@> @=}
| '\''                                          {@> @<Make \prodstyle{'} into a name@> @=}
;

identifier_string:
   PERCENT_IDENTIFIER                           {@> @<Attach option name@> @=}  
|  IDENTIFIER                                   {@> @<Start with an identifier@> @=}
|  '\'' WILDCARD '\''                           {@> @<Start with a quoted string@> @=}
|  '\'' '_' '\''                                {@> @<Start with a \prodstyle{'\_'} string@> @=}
|  '\'' '.' '\''                                {@> @<Start with a \prodstyle{'.'} string@> @=}
@t}\vb{\flatten}{@>
|  incomplete_identifier_string {} IDENTIFIER   {@> @<Attach an identifier@> @=}
;
@t}\vb{\resetf}{@>
incomplete_identifier_string:
   '_'                                          {@> TeX_( "/yy0{/nx/idstr{}{}}" );@=}
|  identifier_string '_'                        {@> TeX_( "/yy0{/the/yy(1)}" ); @=}
|  qualified_identifier_string '_'              {@> TeX_( "/yy0{/the/yy(1)}" ); @=}
;

qualified_identifier_string:
   identifier_string '_' qualifier              {@> @<Attach qualifier to a name@> @=}
|  qualified_identifier_string '_' qualifier    {@> @<Attach qualifier to a name@> @=}
;

suffixes.opt:
                                  {@> TeX_( "/yy0{}" ); @=}
|  '.'                            {@> TeX_( "/yy0{/nx/dotsp/nx/sfxnone}" ); @=}
|  '.' suffixes                   {@> @<Attach suffixes@> @=}
|  '.' qualified_suffixes         {@> @<Attach qualified suffixes@> @=}
|  INTEGER                        {@> @<Attach an integer@> @=}
|  '_' INTEGER                    {@> @<Attach a subscripted integer@> @=}
|  '_' qualifier                  {@> @<Attach a subscripted qualifier@> @=}
;

suffixes:
   IDENTIFIER                     {@> @<Start with a named suffix@> @=}
|  INTEGER                        {@> @<Start with a numeric suffix@> @=}
|  suffixes '.'                   {@> @<Add a dot separator@> @=}
|  suffixes IDENTIFIER            {@> @<Attach a named suffix@> @=}
|  suffixes INTEGER               {@> @<Attach integer suffix@> @=}
|  qualifier '.'                  {@> TeX_( "/yy0{/nx/sfxn/the/yy(1)/nx/dotsp}" ); @=}
|  suffixes qualifier '.'         {@> TeX_( "/yy0{/the/yy(1)/nx/sfxn/the/yy(2)/nx/dotsp}" ); @=}
;

qualified_suffixes:
  suffixes qualifier              {@> @<Attach a qualifier@> @=}
| qualifier                       {@> @<Start suffixes with a qualifier@> @=}
;

qualifier:
  OPTIONAL                        {@> TeX_( "/yy0{/the/yy(1)}" ); @=}
| K_SUFFIX                        {@> TeX_( "/yy0{/the/yy(1)}" ); @=}
| EXTENDED                        {@> TeX_( "/yy0{/the/yy(1)}" ); @=}
;
@g

@ @<Compose the full name@>=
  @[TeX_( "/yy0{/the/yy(1)/the/yy(2)}/namechars/yyval" );@]@;

@ @<Compose a qualified name@>=
  @[TeX_( "/getfirst{/yy(1)}/to/toksa/getsecond{/yy(1)}/to/toksb" );@]@;
  @[TeX_( "/yy0{/the/yy(3)/the/yy(4)/nx/dotsp/nx/qual{/the/toksa/nx/_}{/the/toksb/uscoreletter}}/namechars/yyval" );@]@;

@ @<Turn a \prodstylens{META\_IDENTIFIER}{\ldsmallnamespace} into a full name@>=
  @[TeX_( "/getfirst{/yy(1)}/to/toksa" );@]@;
  @[TeX_( "/getsecond{/yy(1)}/to/toksb" );@]@;
  @[TeX_( "/yy0{/nx/idstr{/the/toksa}{/the/toksb}}/namechars/yyval" );@]@;

@ @<Make \prodstyle{'} into a name@>=
  @[TeX_( "/yy0{/nx/chstr{'}{'}}/namechars/yyval" );@]@;

@ @<Attach option name@>=
  @[TeX_( "/getfirst{/yy(1)}/to/toksa" );@]@;
  @[TeX_( "/getsecond{/yy(1)}/to/toksb" );@]@;
  @[TeX_( "/yy0{/nx/optstr{/the/toksa}{/the/toksb}}" );@]@;

@ @<Start with an identifier@>=
  @[TeX_( "/getfirst{/yy(1)}/to/toksa" );@]@;
  @[TeX_( "/getsecond{/yy(1)}/to/toksb" );@]@;
  @[TeX_( "/yy0{/nx/idstr{/the/toksa}{/the/toksb}}" );@]@;

@ @<Start with a tag@>=
  @[TeX_( "/getfirst{/yy(2)}/to/toksa" );@]@;
  @[TeX_( "/getsecond{/yy(2)}/to/toksb" );@]@;
  @[TeX_( "/yy0{/nx/idstr{</the/toksa>}{</the/toksb>}}" );@]@;

@ @<Start with a quoted string@>=
  @[TeX_( "/getfirst{/yy(2)}/to/toksa" );@]@;
  @[TeX_( "/getsecond{/yy(2)}/to/toksb" );@]@;
  @[TeX_( "/yy0{/nx/visflag{/nx/termvstring}{}/nx/chstr{/the/toksa}{/the/toksb}}" );@]@;

@ @<Start with a \prodstyle{'\_'} string@>=
  @[TeX_( "/yy0{/nx/visflag{/nx/termvstring}{}/nx/chstr{/nx/_}{_}}" );@]@;

@ @<Start with a \prodstyle{'.'} string@>=
  @[TeX_( "/yy0{/nx/visflag{/nx/termvstring}{}/nx/chstr{.}{.}}" );@]@;

@ @<Turn a qualifier into an identifier@>=
  @<Start with an identifier@>@;

@ @<Attach an identifier@>=
  @[TeX_( "/getsecond{/yy(1)}/to/toksa" );@]@;
  @[TeX_( "/appendr/toksa{/noexpand/_}" );@]@;  
  @[TeX_( "/getfirst{/yy(3)}/to/toksb" );@]@;
  @[TeX_( "/concat/toksa/toksb" );@]@;
  @[TeX_( "/getthird{/yy(1)}/to/toksb" );@]@;
  @[TeX_( "/appendr/toksb{/uscoreletter}" );@]@;  
  @[TeX_( "/getsecond{/yy(3)}/to/toksc" );@]@;
  @[TeX_( "/concat/toksb/toksc" );@]@;
  @[TeX_( "/yy0{/nx/idstr{/the/toksa}{/the/toksb}}" );@]@;

@ @<Attach qualifier to a name@>=


@ @<Attach an integer@>=
  @[TeX_( "/yy0{/nx/dotsp/nx/sfxi/the/yy(1)}" );@]@;
                               
@ @<Attach a subscripted integer@>=
  @[TeX_( "/getfirst{/yy(2)}/to/toksa/getsecond{/yy(2)}/to/toksb" );@]@;
  @[TeX_( "/yy0{/nx/dotsp/nx/sfxi{/nx/_/the/toksa}{/uscoreletter/the/toksb}}" );@]@;
                               
@ @<Attach a subscripted qualifier@>=
  @[TeX_( "/getfirst{/yy(2)}/to/toksa/getsecond{/yy(2)}/to/toksb" );@]@;
  @[TeX_( "/yy0{/nx/dotsp/nx/qual{/nx/_/the/toksa}{/uscoreletter/the/toksb}}" );@]@;
                               
@ @<Attach suffixes@>=
  @[TeX_( "/yy0{/nx/dotsp/the/yy(2)}" );@]@;

@ @<Attach qualified suffixes@>=
  @<Attach suffixes@>@;

@ @<Start with a named suffix@>=
  @[TeX_( "/yy0{/nx/sfxn/the/yy(1)}" );@]@;

@ @<Start with a numeric suffix@>=
  @[TeX_( "/yy0{/nx/sfxi/the/yy(1)}" );@]@;

@ @<Add a dot separator@>=
  @[TeX_( "/yy0{/the/yy(1)/nx/dotsp}" );@]@;

@ @<Attach integer suffix@>=
  @[TeX_( "/yy0{/the/yy(1)/nx/sfxi/the/yy(2)}" );@]@;

@ @<Attach a named suffix@>=
  @[TeX_( "/yy0{/the/yy(1)/nx/sfxn/the/yy(2)}" );@]@;

@ @<Attach a qualifier@>=
  @[TeX_( "/yy0{/the/yy(1)/nx/qual/the/yy(2)}" );@]@;

@ @<Start suffixes with a qualifier@>=
  @[TeX_( "/yy0{/nx/qual/the/yy(1)}" );@]@;

@ \Cee\ preamble. In this case, there are no `real' actions that our
grammar performs, only \TeX\ output, so this section is empty.

@<Name parser \Cee\ preamble@>=

@ \Cee\ postamble. It is tricky to insert function definitions that use \bison's internal types,
as they have to be inserted in a place that is aware of the internal definitions but before said 
definitions are used.

@<Name parser \Cee\ postamble@>=
#define YYPRINT(file, type, value)   @[yyprint (file, type, value)@]
  static void yyprint (FILE *file, int type, YYSTYPE value){}

@ Union of types.

@<Union of parser types@>=

@*1 The name scanner.
%\checktabletrue
@(ld_small_lexer.ll@>=
@G
 @> @<Lexer definitions@> @= 
%{@> @<Lexer \Cee\ preamble@> @=%}
 @> @<Lexer options@> @= 
%%
 @> @<Regular expressions@> @= 
%%
@O
void define_all_states( void ) {
    @<Collect all state definitions@>@;
}
@o
@g
@t}\ifbootstrapmode\yyskipparsetrue\fi{@>

@ @<Lexer definitions@>=
  @<Lexer states@>@;
@G(fs1)
aletter   [a-zA-Z]
letter    (_|{aletter})
wc        ([^\\\'\"]{-}[_a-zA-Z0-9]|\\.)
id        ({aletter}|{aletter}({aletter}|[0-9])*{aletter})
id_strict {letter}(({letter}|[-0-9])*{letter})?
meta_id   "*"{id_strict}"*"?
int       [0-9]+
@g

@ @<Collect all state definitions@>=
#define _register_name( name ) @[Define_State( #name, name )@]
/* nothing for now */
#undef _register_name

@ Strings and characters in directives/rules.
@<Lexer states@>=
@G
%x SC_ESCAPED_STRING SC_ESCAPED_CHARACTER
@g

@ @<Lexer \Cee\ preamble@>=

#include <stdint.h>
#include <stdbool.h>

@t}\yyskipparsefalse{@>
@ @<Lexer options@>=
@G
%option bison-bridge
%option noyywrap nounput noinput reentrant 
%option noyy_top_state
%option debug
%option stack
%option outfile="ld_small_lexer.c"
@g

@ @<Regular expressions@>=
  @<Scan white space@>@;
  @<Scan identifiers@>@;

@ White space skipping. 
\traceparserstatestrue
\tracestackstrue
\tracerulestrue
\traceactionstrue
\tracelookaheadtrue
\traceparseresultstrue
\tracebadcharstrue
\yyflexdebugtrue
%
%\prodstyle{abc123}
%
\traceparserstatesfalse
\tracestacksfalse
\tracerulesfalse
\traceactionsfalse
\tracelookaheadfalse
\traceparseresultsfalse
\tracebadcharsfalse
\yyflexdebugfalse
%
@<Scan white space@>=
@G(fs2)
[ \f\n\t\v]                        {@> @[TeX_( "/yylexnext" );@]@=}
@g

@ This collection of regular expressions might seem redundant, and in
its present state, it certainly is. However, if later on the
typesetting style for some of the keywords would need to be adjusted,
such changes would be easy to implement, since the template is already
here.
@<Scan identifiers@>=
@G(fs2)
"%"({aletter}|[0-9]|[-_]|"%"|[<>])+ {@> @[TeX_( "/yylexreturnval{PERCENT_IDENTIFIER}" );@]@=}

"opt"                              {@> @[TeX_( "/yylexreturnval{OPTIONAL}" );@]@=}
"K"                                {@> @[TeX_( "/yylexreturnval{K_SUFFIX}" );@]@=}
"ext"                              {@> @[TeX_( "/yylexreturnval{EXTENDED}" );@]@=}

[\'._]                             {@> @[TeX_( "/yylexreturnchar" );@]@=}
{wc}                               {@> @[TeX_( "/yylexreturnval{WILDCARD}" );@]@=}

{id}                               {@> @[@<Prepare to process an identifier@>@]@=}
{meta_id}                          {@> @[@<Prepare to process a meta-identifier@>@]@=}
{int}                              {@> @[TeX_( "/yylexreturnval{INTEGER}" );@]@=}

"\""                               {@> @[TeX_( "/yylexnext" );@]@=}
.                                  {@> @[@<React to a bad character@>@]@=}
@g

@ @<Prepare to process an identifier@>=
 @[TeX_( "/yylexreturnval{IDENTIFIER}" );@]@;

@ @<Prepare to process a meta-identifier@>=
 @[TeX_( "/yylexreturnval{META_IDENTIFIER}" );@]@;

@ \let\hostparsernamespace\ldnamespace\yyskipparsefalse A simple routine to detect
trivial scanning problems.
@<React to a bad character@>=
 @[TeX_( "/iftracebadchars" );@]@;
 @[TeX_( "    /yycomplain{invalid character(s): /the/yytext}" );@]@;
 @[TeX_( "/fi" );@]@;
 @[TeX_( "/yylexreturn{$undefined}" );@]@;
