% Copyright 2012-2020, Alexander Shibakov
% Copyright 2002-2014 Free Software Foundation, Inc.
% This file is part of SPLinT
%
% SPLinT is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% SPLinT is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with SPLinT.  If not, see <http://www.gnu.org/licenses/>.

@** Checklists. This (experimental) section serves to aid in the
testing and extension of \splint\ by formalizing a number of procedures
in the form of a checklist. After having witnessed first hand the effectiveness
of checklists in aviation, the author feels that a similar approach
will be beneficial in programming, as well. Most of these tests can and
should be automated but the applicable situations are rather rare so
the automation has not been implemented yet.

{%
\def\aterm#1{\item{\sqebullet\ }{\ttl #1}\ignorespaces}%
\def\aaterm#1{\itemitem{\sqebullet\ }{\ttl #1}\ignorespaces}%
\def\aaaterm#1{\itemitemitem{\sqebullet\ }{\ttl #1}\ignorespaces}%
\setbox0=\hbox{\sqebullet\ \enspace}
\parindent=0pt
\advance\parindent by \wd0
\bigskip
\noindent{\ttl General checklist.}
\smallskip
\aterm{} Have the checklists in this section been followed?

\aterm{} Have {\it all\/} the examples been built and tested?

\aaterm{} \.{make}: this would build the \.{ld} parser, as well as other
parts, like \.{ssfo.pdf}, etc.

\aaterm{} \.{symbols}

\aaterm{} \.{xxpression} (both \.{make} and \.{make test})

\aaterm{} \.{expression} (both \.{make} and \.{make test})

\aaterm{} once in a while it is useful to run a tool like \.{diffpdf} to check
that the generated output does not change unexpectedly

\aaterm{} \.{parsec} (not part of \splint)

\aterm{} Have the changes been documented?

\aaterm{} If any limitations have been removed, has this been reflected
in the documentation, examples, such as \.{symbols.sty}?

\aaterm{} If any new conditionals have been added, does \.{yydebug.sty} provide
a way to check their status, if appropriate?

\aaterm{} If any new script option has been added, has the script documentation been
updated?

\aterm{} If a new process has been introduced, has it been reflected in any of the checklists in 
this section?

\bigskip
\noindent{\ttl Rewriting checklist.}
\smallskip
\aterm{} Is the output of the new system identical?

\aaterm{} once in a while it is useful to run a tool like \.{diffpdf} to check
that the generated output does not change unexpectedly

\aaterm{} has \.{diff} been used to check that \.{.gdx} and \.{.gdy} files produced
are (nearly) identical? 

\aaterm{} has \.{diff} been used to check that \.{.sns} files produced by \.{symbols}
and \.{xxpression} examples are (nearly) identical? 

}
