/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.common.query;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.mariadb.jdbc.internal.common.QueryException;
import org.mariadb.jdbc.internal.common.query.Query;
import org.mariadb.jdbc.internal.common.query.QueryType;

public class MySQLQuery
implements Query {
    private final String query;
    private final byte[] queryToSend;

    public MySQLQuery(String query) {
        this.query = query;
        try {
            this.queryToSend = query.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unsupported encoding: " + e.getMessage(), e);
        }
    }

    public MySQLQuery(byte[] query) {
        this.queryToSend = query;
        try {
            this.query = new String(query, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unsupported encoding: " + e.getMessage(), e);
        }
    }

    public int length() {
        return this.queryToSend.length;
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        os.write(this.queryToSend, 0, this.queryToSend.length);
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public QueryType getQueryType() {
        return QueryType.classifyQuery(this.query);
    }

    public boolean equals(Object otherObj) {
        return otherObj instanceof MySQLQuery && ((MySQLQuery)otherObj).query.equals(this.query);
    }

    public void writeTo(OutputStream ostream, int offset, int packLength) throws IOException {
        ostream.write(this.queryToSend, offset, packLength);
    }

    @Override
    public void validate() throws QueryException {
    }

    public String toString() {
        return this.query;
    }

    @Override
    public int getPacketLength() {
        return this.length();
    }
}

