/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.rendering;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDTilingPattern;
import org.apache.pdfbox.rendering.PageDrawer;
import org.apache.pdfbox.util.Matrix;

class TilingPaint
implements Paint {
    private final PDTilingPattern pattern;
    private final TexturePaint paint;
    private final PageDrawer drawer;

    TilingPaint(PageDrawer drawer, PDTilingPattern pattern, AffineTransform xform) throws IOException {
        this.drawer = drawer;
        this.pattern = pattern;
        this.paint = new TexturePaint(this.getImage(null, null, xform), this.getAnchorRect());
    }

    TilingPaint(PageDrawer drawer, PDTilingPattern pattern, PDColorSpace colorSpace, PDColor color, AffineTransform xform) throws IOException {
        this.drawer = drawer;
        this.pattern = pattern;
        this.paint = new TexturePaint(this.getImage(colorSpace, color, xform), this.getAnchorRect());
    }

    @Override
    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
        AffineTransform xformPattern = (AffineTransform)xform.clone();
        Matrix patternMatrix = Matrix.concatenate(this.drawer.getInitialMatrix(), this.pattern.getMatrix());
        AffineTransform patternNoScale = patternMatrix.createAffineTransform();
        patternNoScale.scale(1.0f / patternMatrix.getScalingFactorX(), 1.0f / patternMatrix.getScalingFactorY());
        xformPattern.concatenate(patternNoScale);
        return this.paint.createContext(cm, deviceBounds, userBounds, xformPattern, hints);
    }

    private BufferedImage getImage(PDColorSpace colorSpace, PDColor color, AffineTransform xform) throws IOException {
        ColorSpace outputCS = ColorSpace.getInstance(1000);
        ComponentColorModel cm = new ComponentColorModel(outputCS, true, false, 3, 0);
        Rectangle2D anchor = this.getAnchorRect();
        float width = (float)Math.abs(anchor.getWidth());
        float height = (float)Math.abs(anchor.getHeight());
        Matrix xformMatrix = new Matrix(xform);
        int rasterWidth = Math.max(1, TilingPaint.ceiling(width *= xformMatrix.getScalingFactorX()));
        int rasterHeight = Math.max(1, TilingPaint.ceiling(height *= xformMatrix.getScalingFactorY()));
        WritableRaster raster = ((ColorModel)cm).createCompatibleWritableRaster(rasterWidth, rasterHeight);
        BufferedImage image = new BufferedImage(cm, raster, false, null);
        Graphics2D graphics = image.createGraphics();
        if (this.pattern.getYStep() < 0.0f) {
            graphics.translate(0, rasterHeight);
            graphics.scale(1.0, -1.0);
        }
        if (this.pattern.getXStep() < 0.0f) {
            graphics.translate(rasterWidth, 0);
            graphics.scale(-1.0, 1.0);
        }
        graphics.scale(xformMatrix.getScalingFactorX(), xformMatrix.getScalingFactorY());
        Matrix patternMatrix = Matrix.concatenate(this.drawer.getInitialMatrix(), this.pattern.getMatrix());
        patternMatrix = Matrix.getScaleInstance(Math.abs(patternMatrix.getScalingFactorX()), Math.abs(patternMatrix.getScalingFactorY()));
        patternMatrix.concatenate(Matrix.getTranslateInstance(-this.pattern.getBBox().getLowerLeftX(), -this.pattern.getBBox().getLowerLeftY()));
        this.drawer.drawTilingPattern(graphics, this.pattern, colorSpace, color, patternMatrix);
        graphics.dispose();
        return image;
    }

    private static int ceiling(double num) {
        BigDecimal decimal = new BigDecimal(num);
        decimal = decimal.setScale(5, RoundingMode.CEILING);
        return decimal.intValue();
    }

    @Override
    public int getTransparency() {
        return 3;
    }

    private Rectangle2D getAnchorRect() {
        float yStep;
        float xStep = this.pattern.getXStep();
        if (xStep == 0.0f) {
            xStep = this.pattern.getBBox().getWidth();
        }
        if ((yStep = this.pattern.getYStep()) == 0.0f) {
            yStep = this.pattern.getBBox().getHeight();
        }
        Matrix patternMatrix = Matrix.concatenate(this.drawer.getInitialMatrix(), this.pattern.getMatrix());
        float xScale = patternMatrix.getScalingFactorX();
        float yScale = patternMatrix.getScalingFactorY();
        PDRectangle anchor = this.pattern.getBBox();
        return new Rectangle2D.Float(anchor.getLowerLeftX() * xScale, anchor.getLowerLeftY() * yScale, xStep * xScale, yStep * yScale);
    }
}

