/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.fdf;

import java.io.IOException;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.fdf.FDFAnnotation;
import org.w3c.dom.Element;

public class FDFAnnotationFreeText
extends FDFAnnotation {
    public static final String SUBTYPE = "FreeText";

    public FDFAnnotationFreeText() {
        this.annot.setName(COSName.SUBTYPE, SUBTYPE);
    }

    public FDFAnnotationFreeText(COSDictionary a) {
        super(a);
    }

    public FDFAnnotationFreeText(Element element) throws IOException {
        super(element);
        this.annot.setName(COSName.SUBTYPE, SUBTYPE);
        this.setJustification(element.getAttribute("justification"));
        String rotation = element.getAttribute("rotation");
        if (rotation != null && !rotation.isEmpty()) {
            this.setRotation(Integer.parseInt(rotation));
        }
    }

    public void setJustification(String justification) {
        int quadding = 0;
        if ("centered".equals(justification)) {
            quadding = 1;
        } else if ("right".equals(justification)) {
            quadding = 2;
        }
        this.annot.setInt(COSName.Q, quadding);
    }

    public String getJustification() {
        return "" + this.annot.getInt(COSName.Q, 0);
    }

    public void setRotation(int rotation) {
        this.annot.setInt(COSName.ROTATE, rotation);
    }

    public String getRotation() {
        return this.annot.getString(COSName.ROTATE);
    }
}

