/* itoa.c */

#define abs( a )               ( ( ( a ) > 0 ) ? ( a ) : ( -( a ) ) )
#define sign( a )              ( ( ( a ) > 0 ) ? ( 1 ) : ( -1 ) )

#include <string.h>
#include "itoa.h"

char *chins(char *s, char c, int i)
{
  memmove(s+i+1,s+i,strlen(s)-i+1);
  *(s+i) = c;
  return s;
}

#ifdef __unix__

char *strrev(char *s)
{
  char c;
  char *p = s;
  char *q = s + strlen(s) - 1;

  while (q > p) {
    c = *p;
    *p++ = *q;
    *q-- = c;
  }
  return s;
}

char *ltoa(long value, char *string, int radix)
{
  const char digset[33]="0123456789abcdefghijklmnopqrstuw";
  int n = 0;
#if 0
  long i = labs(value);
#else
  long i = abs( value );
#endif

  string[n] = 0;
  if((radix<2) || (radix>32)) return string;
  do {
    string[n++] = digset[i % radix];
    i/= radix;
  } while(i);
  if(value < 0) string[n++] = '-';
  string[n] = 0;
  strrev(string);
  return string;
}

#endif /* __unix__ */

char *itona(char *s, int i, int n, char c)
{
  if(!c)
    c='0';
  itoa(i, s, 10);              /* assume radix 10 */
  while(strlen(s)<n)
    chins(s, c, 0);
  return s;
}
