/****************************************************************************
  PROJECT: FlowerSoft C++ library
  FILE   : error.cc
--*/

#include <stdlib.h>            // exit
#include <iostream.h>

#if 0
#include "string.h"

const char* quoteChar( const char* message, const char quote )
{
    return quoteString( message, String( quote ) );
}

const char* quoteString( const char* message, const char *quote )
{
    static String s;
//    s = String( message ) + String( ' `' ) + String( quote ) + '\'';
    s = String( message );
    s += ": `";
    s += String( quote );
    s += '\'';
    return (const char*)s;
}
#endif

void error( const char* s, const char* file, const int line )
{
    if ( s )
        {
        cerr << endl;
        if ( file )
            cerr << file << ": " << line << ": ";
        cerr << s;
#ifndef __MSDOS__
        cerr << endl;
#endif        
        }
    exit( 1 );
}

void warning( const char* s, const char* file, const int line )
{
    cerr << endl;
    if ( file )
        cerr << file << ": " << line << ": warning: ";
    cerr << s;
    cerr << endl;
}
