/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.binding.OsModel;
import com.izforge.izpack.util.OsVersion;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class OsConstraintHelper {
    private static final Logger logger = Logger.getLogger(OsConstraintHelper.class.getName());

    @Deprecated
    public static boolean matchCurrentSystem(OsModel osModel) {
        boolean match = true;
        String osName = System.getProperty("os.name").toLowerCase();
        if (osModel.getArch() != null && osModel.getArch().length() != 0) {
            match = System.getProperty("os.arch").toLowerCase().equals(osModel.getArch());
        }
        if (match && osModel.getVersion() != null && osModel.getVersion().length() != 0) {
            match = System.getProperty("os.version").toLowerCase().equals(osModel.getVersion());
        }
        if (match && osModel.getName() != null && osModel.getName().length() != 0) {
            match = osName.equals(osModel.getName());
        }
        if (match && osModel.getFamily() != null) {
            if ("windows".equals(osModel.getFamily())) {
                match = OsVersion.IS_WINDOWS;
            } else if ("mac".equals(osModel.getFamily()) || "osx".equals(osModel.getFamily())) {
                match = OsVersion.IS_OSX;
            } else if ("unix".equals(osModel.getFamily())) {
                match = OsVersion.IS_UNIX;
            }
        }
        if (match && osModel.getJre() != null && osModel.getJre().length() > 0) {
            match = System.getProperty("java.version").toLowerCase().startsWith(osModel.getJre());
        }
        return match && (osModel.getFamily() != null || osModel.getName() != null || osModel.getVersion() != null || osModel.getArch() != null || osModel.getJre() != null);
    }

    public static List<OsModel> getOsList(IXMLElement element) {
        ArrayList<OsModel> osList = new ArrayList<OsModel>();
        for (IXMLElement osElement : element.getChildrenNamed("os")) {
            osList.add(new OsModel(osElement.getAttribute("arch", null), osElement.getAttribute("family", null), osElement.getAttribute("jre", null), osElement.getAttribute("name", null), osElement.getAttribute("version", null)));
        }
        String osattr = element.getAttribute("os");
        if (osattr != null && osattr.length() > 0) {
            osList.add(new OsModel(null, osattr, null, null, null));
        }
        return osList;
    }

    @Deprecated
    public static boolean oneMatchesCurrentSystem(List<OsModel> constraint_list) {
        if (constraint_list == null || constraint_list.isEmpty()) {
            return true;
        }
        for (OsModel osModel : constraint_list) {
            logger.fine("Checking if os constraints " + osModel + " match current OS");
            if (!OsConstraintHelper.matchCurrentSystem(osModel)) continue;
            logger.fine("OS constraints matched current OS");
            return true;
        }
        logger.fine("OS constraints do not match current OS");
        return false;
    }

    @Deprecated
    public static boolean oneMatchesCurrentSystem(IXMLElement el) {
        return OsConstraintHelper.oneMatchesCurrentSystem(OsConstraintHelper.getOsList(el));
    }
}

