/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.data;

import com.izforge.izpack.api.data.binding.OsModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ExecutableFile
implements Serializable {
    static final long serialVersionUID = 4175489415984990405L;
    public static final int POSTINSTALL = 0;
    public static final int NEVER = 1;
    public static final int UNINSTALL = 2;
    public static final int BIN = 0;
    public static final int JAR = 1;
    public static final int ABORT = 0;
    public static final int WARN = 1;
    public static final int ASK = 2;
    public static final int IGNORE = 3;
    public String path;
    public int executionStage;
    public String mainClass;
    public int type;
    public int onFailure;
    public List<String> argList = null;
    public List<OsModel> osList = null;
    public boolean keepFile;
    private String condition = null;

    public ExecutableFile() {
        this.path = null;
        this.executionStage = 1;
        this.mainClass = null;
        this.type = 0;
        this.onFailure = 2;
        this.osList = new ArrayList<OsModel>();
        this.argList = new ArrayList<String>();
        this.keepFile = false;
    }

    public ExecutableFile(String path, int executionStage, int onFailure, List<OsModel> osList, boolean keepFile) {
        this.path = path;
        this.executionStage = executionStage;
        this.onFailure = onFailure;
        this.osList = osList;
        this.keepFile = keepFile;
    }

    public ExecutableFile(String path, int type, String mainClass, int executionStage, int onFailure, List<String> argList, List<OsModel> osList, boolean keepFile) {
        this.path = path;
        this.mainClass = mainClass;
        this.type = type;
        this.executionStage = executionStage;
        this.onFailure = onFailure;
        this.argList = argList;
        this.osList = osList;
        this.keepFile = keepFile;
    }

    public String toString() {
        StringBuffer retval = new StringBuffer();
        retval.append("path = ").append(this.path);
        retval.append("\n");
        retval.append("mainClass = ").append(this.mainClass);
        retval.append("\n");
        retval.append("type = ").append(this.type);
        retval.append("\n");
        retval.append("executionStage = ").append(this.executionStage);
        retval.append("\n");
        retval.append("onFailure = ").append(this.onFailure);
        retval.append("\n");
        retval.append("argList: ").append(this.argList);
        retval.append("\n");
        if (this.argList != null) {
            for (String anArgList : this.argList) {
                retval.append("\targ: ").append(anArgList);
                retval.append("\n");
            }
        }
        retval.append("\n");
        retval.append("osList = ").append(this.osList);
        retval.append("\n");
        if (this.osList != null) {
            for (OsModel anOsList : this.osList) {
                retval.append("\tos: ").append(anOsList);
                retval.append("\n");
            }
        }
        retval.append("keepFile = ").append(this.keepFile);
        retval.append("\n");
        return retval.toString();
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public boolean hasCondition() {
        return this.condition != null;
    }
}

