/* l2xlib.h    Header for support routines for l2x LaTeX to X translator */

#ifndef STRTYPES_H
#include "strtypes.h"
#endif

#ifndef TRUE
# define TRUE 1
#endif
#ifndef FALSE
# define FALSE 0
#endif

/* extern char *STRING;     A pointer-to-char */
/* extern STRING *PTRADR;   A pointer-to-pointer-to-char */

extern FILE *filerr;
extern FILE *yyin;
extern FILE *filerr;
extern FILE *yyout;

extern int MIN_GRAMM_SPECIAL;
extern int MIN_CODE_SPECIAL;

extern int LDEBUG;
extern int YDEBUG;

extern int num_errors;
extern int lineno;
extern char linebuf[];
extern int linlen;

extern int leave_comments;
extern int collapse_ws;
extern int pretty_print;

extern int darray[];

extern int no_print;
extern int print_to_buffer;

extern PSTRWC clause_str_stack[]; 
extern int base_level; 
extern int current_level;
extern int new_level;

extern int LIST_STACK_SIZE;
extern int list_level; 
extern int num_items[]; 
extern PSTRWC list_str_stack[];
extern PSTRWC list_item_start[]; 
extern PSTRWC list_descitemp_start[]; 
extern PSTRWC list_descitemp_end[];
extern void set_list_stack();

extern char *strsave();
extern void myprint();
extern void verbatim_print();
extern void set_clause_stack(); 
extern void close_doc_divs(); 
extern void close_down();
extern void yyerror();
extern void warning();
extern void catl();
extern void do_newline();
extern void initialise_sysbuf();
extern void print_sysbuf();
extern void copy_sysbuf();
extern void initialise_string();

                /* extra stuff for l2x */

/* extern struct st_entry; */
extern struct st_entry *symbol_table[];
extern int num_table_entries;

extern char env_name[];
extern int DONT_CARE;
extern STRING dont_care_str;

/* extern struct PSTRWC; */

extern int pos_bdoc;
extern int pos_edoc;
extern int pos_bvbm;
extern int pos_evbm;
extern int pos_bv;
extern int pos_ev;
extern int pos_oc;
extern int pos_ob;
extern int pos_oe;
extern int pos_lbrace;
extern int pos_rbrace;
extern int pos_para;
extern int pos_bdol;
extern int pos_edol;
extern int pos_bss;

/* extern enum sect_level_enum; */
extern int lookup_entry();
extern void print_to_err();
extern void print_debug_1s();
extern void print_debug_2s();
extern void print_debug_undef();
extern int command_type();
extern int get_user_type();
extern int get_special_token();
extern PSTRWC get_t();
extern PSTRWC get_et();
extern PSTRWC get_tag_t();
extern PSTRWC get_tag_et();
extern PSTRWC get_opttag_t();
extern PSTRWC get_opttag_et();
extern int get_level();
extern PSTRWC get_item_t();
extern PSTRWC get_item_et();
extern PSTRWC get_itemopt_t();
extern PSTRWC get_itemopt_et();
extern void warning_3s();
extern PSTRWC get_com_print();
extern PSTRWC get_param_print();
extern PSTRWC get_opt_print();

/*  ------------------ 6/96 additions --------------------- */
extern void tag_print();
extern int get_pc_enum();
extern PSENTRY get_mode_sym(); /* gets sym entry for command & current mode */
extern int bverb;                 /* TRUE if starting begin{verbatim} */

extern int in_noop;              /* TRUE if procesing a no op */
extern int start_noop;           /* TRUE if starting a no op */


extern void set_print();
extern void reset_print();



extern void tdebug_str_int();
extern void print_end_item();
extern void get_env_name();
extern PSTRWC get_start_pc();
extern PSTRWC get_end_pc();


  /* pointers to fixed, predefined print control structs */
extern PSTRWC p_default_print;     /* default printing i.e., DEFAULT_PRINT */
extern PSTRWC p_no_print;          /* no printing i.e., NO_PRINT */
extern PSTRWC p_print_to_sysbuf;   /* print to system buffer i.e., TO_SYSBUF */
extern PSTRWC p_print_underflow;   /* underflow i.e., PRINT_UNDERFLOW */
extern PSTRWC p_unknown_print;     /* unknown print i.e., UNKNOWN_PRINT */
extern PSTRWC p_print_from_sysbuf; /* print from system buffer i.e., SYSBUF */
extern PSTRWC p_print_null;        /* print null string i.e.,  */
extern PSTRWC p_reset_print;       /* reset printing i.e., RESET */
extern PSTRWC p_noop_print;        /* no-op i.e., NO_OP */
