/*
 * Decompiled with CFR 0.152.
 */
package LogFilter;

import LogFilter.Controller;
import LogFilter.Entry;
import LogFilter.Model;
import LogFilter.UserSettings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;

class View
extends JFrame {
    View me = this;
    TheListBox list;
    JScrollPane scrollpane;
    Controller controller;
    UserSettings usersettings;
    AbstractAction openAction;
    AbstractAction configAction;
    AbstractAction quitAction;
    AbstractAction helpAction;
    static final String title = "LogFilter v0.90  - ";
    static /* synthetic */ Class class$LogFilter$View;

    View() {
        super(title);
        try {
            this.usersettings = new UserSettings(this);
            this.controller = new Controller(new Model(), this.usersettings, this);
            URL uRL = (class$LogFilter$View == null ? (class$LogFilter$View = View.class$("LogFilter.View")) : class$LogFilter$View).getResource("Images/About.jpg");
            super.setIconImage(Toolkit.getDefaultToolkit().getImage(uRL));
            JPanel jPanel = this.setupPanel();
            this.list = new TheListBox();
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)jPanel, "South");
            this.getContentPane().add((Component)this.list, "Center");
            this.setupMenu();
            super.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    View.this.controller.quit();
                }
            });
            super.pack();
            super.setBounds(this.usersettings.x, this.usersettings.y, this.usersettings.width, this.usersettings.height);
            super.setVisible(true);
            if (!this.usersettings.logfilename.equals("")) {
                this.reload();
            } else {
                this.openAction.actionPerformed(null);
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            iOException.printStackTrace();
            this.controller.quit();
        }
    }

    public void messageDialog(Object object, String string, int n) {
        JOptionPane.showMessageDialog(this, object, string, n);
    }

    public void reload() {
        this.list.reload();
        this.setTitle(title + this.usersettings.logfilename);
    }

    void refresh() {
        this.list.refresh();
    }

    private void setupMenu() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        this.openAction = new OpenAction("Open");
        jMenu.add(this.openAction);
        this.configAction = new ConfigAction("Preferences");
        jMenu.add(this.configAction);
        this.quitAction = new QuitAction("Quit");
        jMenu.add(this.quitAction);
        JMenu jMenu2 = new JMenu("Help");
        this.helpAction = new HelpAction("About");
        jMenu2.add(this.helpAction);
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        super.setJMenuBar(jMenuBar);
    }

    private JPanel setupPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Essential");
        titledBorder.setTitleJustification(2);
        jPanel2.setBorder(titledBorder);
        jPanel2.setAlignmentY(0.0f);
        JCheckBox jCheckBox = new JCheckBox("Reference errors", this.usersettings.reference_error);
        jCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                View.this.usersettings.reference_error = itemEvent.getStateChange() == 1;
                View.this.list.refresh();
            }
        });
        jCheckBox.setToolTipText("Warnings about misspelled LaTeX and BiBTeX references.");
        jPanel2.add(jCheckBox);
        jCheckBox = new JCheckBox("Missing files", this.usersettings.nofile_error);
        jCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                View.this.usersettings.nofile_error = itemEvent.getStateChange() == 1;
                View.this.list.refresh();
            }
        });
        jCheckBox.setToolTipText("Warnings about missing files encountered by a \\include{}. Missing configfiles for various packages are not included.");
        jPanel2.add(jCheckBox);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        TitledBorder titledBorder2 = BorderFactory.createTitledBorder("Warnings");
        titledBorder2.setTitleJustification(2);
        jPanel3.setBorder(titledBorder2);
        jPanel3.setAlignmentY(0.0f);
        jCheckBox = new JCheckBox("Float warnings", this.usersettings.float_warning);
        jCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                View.this.usersettings.float_warning = itemEvent.getStateChange() == 1;
                View.this.list.refresh();
            }
        });
        jCheckBox.setToolTipText("Warnings about tables, figures etc may be beeing placed differently than specified");
        jPanel3.add(jCheckBox);
        jCheckBox = new JCheckBox("vbox warnings", this.usersettings.vbox);
        jCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                View.this.usersettings.vbox = itemEvent.getStateChange() == 1;
                View.this.list.refresh();
            }
        });
        jCheckBox.setToolTipText("Warnings Common are underfull \\vbox for bad page breaks (or bad interaction of \\textheight and \\baselineskip), and overfull \\vbox on every page due to too-small \\headheight.");
        jPanel3.add(jCheckBox);
        jCheckBox = new JCheckBox("Other warnings", this.usersettings.latex_warning);
        jCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                View.this.usersettings.latex_warning = itemEvent.getStateChange() == 1;
                View.this.list.refresh();
            }
        });
        jCheckBox.setToolTipText("Unspecified warnings such as unused globals, maginpar etc. In future, some of these may be filter-able individually");
        jPanel3.add(jCheckBox);
        jPanel.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        TitledBorder titledBorder3 = BorderFactory.createTitledBorder("Font");
        titledBorder3.setTitleJustification(2);
        jPanel4.setBorder(titledBorder3);
        jPanel4.setAlignmentY(0.0f);
        jCheckBox = new JCheckBox("Font errors", this.usersettings.fonterror);
        jCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                View.this.usersettings.fonterror = itemEvent.getStateChange() == 1;
                View.this.list.refresh();
            }
        });
        jCheckBox.setToolTipText("Warnings about problems with fonts, i.e.: missing (characters), can't be replaced");
        jPanel4.add(jCheckBox);
        jCheckBox = new JCheckBox("Font warnings", this.usersettings.fontwarning);
        jCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                View.this.usersettings.fontwarning = itemEvent.getStateChange() == 1;
                View.this.list.refresh();
            }
        });
        jCheckBox.setToolTipText("Warnings about fonts such as missing fonts being replaced by other fonts");
        jPanel4.add(jCheckBox);
        jPanel.add(jPanel4);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        TitledBorder titledBorder4 = BorderFactory.createTitledBorder("Page Layout");
        titledBorder4.setTitleJustification(2);
        jPanel5.setBorder(titledBorder4);
        jPanel5.setAlignmentY(0.0f);
        jCheckBox = new JCheckBox("Overfull \\hbox", this.usersettings.overfull_hbox);
        jCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                View.this.usersettings.overfull_hbox = itemEvent.getStateChange() == 1;
                View.this.list.refresh();
            }
        });
        jCheckBox.setToolTipText("Common overfull warnings occour on every page due to too-small \\headheight or when lines crosses the right margin, high numbers (pt's) are yields horrible results.");
        jPanel5.add(jCheckBox);
        jCheckBox = new JCheckBox("Underfull \\hbox", this.usersettings.underfull_hbox);
        jCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                View.this.usersettings.underfull_hbox = itemEvent.getStateChange() == 1;
                View.this.list.refresh();
            }
        });
        jCheckBox.setToolTipText("Common are underfull warnings occour for bad page breaks (or bad interaction of \\textheight and \\baselineskip). Typically you will get an underfull box warning if you end a paragraph with \\\\. The warning underfull can roughly be described as the paragraph containins too few characters to produre the nicest layout.");
        jPanel5.add(jCheckBox);
        jPanel.add(jPanel5);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 1));
        TitledBorder titledBorder5 = BorderFactory.createTitledBorder("FixMe");
        titledBorder5.setTitleJustification(2);
        jPanel6.setBorder(titledBorder5);
        jPanel6.setAlignmentY(0.0f);
        jCheckBox = new JCheckBox("Notes", this.usersettings.fixme_note);
        jCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                View.this.usersettings.fixme_note = itemEvent.getStateChange() == 1;
                View.this.list.refresh();
            }
        });
        jCheckBox.setToolTipText("Show notes made using the FixMe package. (Using green colors)");
        jPanel6.add(jCheckBox);
        jCheckBox = new JCheckBox("Warnings", this.usersettings.fixme_warning);
        jCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                View.this.usersettings.fixme_warning = itemEvent.getStateChange() == 1;
                View.this.list.refresh();
            }
        });
        jCheckBox.setToolTipText("Show warnings addressed using the FixMe package. (Using yellow colors)");
        jPanel6.add(jCheckBox);
        jCheckBox = new JCheckBox("Errors", this.usersettings.fixme_error);
        jCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                View.this.usersettings.fixme_error = itemEvent.getStateChange() == 1;
                View.this.list.refresh();
            }
        });
        jCheckBox.setToolTipText("Show errors addressed using the FixMe package. (Using red colors)");
        jPanel6.add(jCheckBox);
        jPanel.add(jPanel6);
        return jPanel;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class TheListBox
    extends JPanel {
        private JList list;
        private DefaultListModel listmodel;
        MouseListener mouseListener = new MouseAdapter(this){
            private final /* synthetic */ TheListBox this$1;
            {
                this.this$1 = theListBox;
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                int n;
                if (mouseEvent.getClickCount() == 2 && (n = TheListBox.access$100(this.this$1).locationToIndex(mouseEvent.getPoint())) > -1) {
                    TheListBox.access$200((TheListBox)this.this$1).controller.launch(n);
                }
            }
        };
        KeyListener keyListener = new KeyAdapter(this){
            private final /* synthetic */ TheListBox this$1;
            {
                this.this$1 = theListBox;
            }

            public void keyTyped(KeyEvent keyEvent) {
                int n;
                if ('\n' == keyEvent.getKeyChar() && (n = TheListBox.access$100(this.this$1).getSelectedIndex()) > -1) {
                    TheListBox.access$200((TheListBox)this.this$1).controller.launch(n);
                }
            }
        };

        TheListBox() {
            super(true);
            this.listmodel = new DefaultListModel();
            this.list = new JList(this.listmodel);
            this.list.setSelectionMode(0);
            this.list.setCellRenderer(new MyCellRenderer());
            this.list.addMouseListener(this.mouseListener);
            this.list.addKeyListener(this.keyListener);
            View.this.scrollpane = new JScrollPane(this.list);
            super.setLayout(new BorderLayout());
            super.add((Component)View.this.scrollpane, "Center");
        }

        void reload() {
            View.this.controller.setLogfilename(View.this.usersettings.logfilename);
            this.refresh();
        }

        void refresh() {
            LinkedList linkedList = View.this.controller.getModel();
            this.listmodel = new DefaultListModel();
            int n = 0;
            while (n < linkedList.size()) {
                this.listmodel.addElement((Entry)linkedList.get(n));
                ++n;
            }
            this.list.setModel(this.listmodel);
        }

        static /* synthetic */ JList access$100(TheListBox theListBox) {
            return theListBox.list;
        }

        static /* synthetic */ View access$200(TheListBox theListBox) {
            return theListBox.View.this;
        }

        class MyCellRenderer
        extends JLabel
        implements ListCellRenderer {
            Font normal = new Font("Helvetica", 0, 14);
            Color bgcol = new Color(193, 198, 226);
            Color normalcol = new Color(0, 0, 0);
            Color sepcol = new Color(90, 70, 214);
            Color errcol = new Color(220, 30, 20);
            Color fixme_note_col = new Color(35, 110, 35);
            Color fixme_warn_col = new Color(162, 162, 0);
            Color fixme_err_col = new Color(220, 35, 35);

            MyCellRenderer() {
            }

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Entry entry = (Entry)object;
                switch (entry.type) {
                    case 100: {
                        this.setForeground(this.sepcol);
                        this.setText(entry.msg);
                        break;
                    }
                    case 101: {
                        this.setForeground(this.errcol);
                        this.setText(entry.msg);
                        break;
                    }
                    case 30: {
                        this.setForeground(this.fixme_note_col);
                        this.setText("    " + entry.msg);
                        break;
                    }
                    case 31: {
                        this.setForeground(this.fixme_warn_col);
                        this.setText("    " + entry.msg);
                        break;
                    }
                    case 32: {
                        this.setForeground(this.fixme_err_col);
                        this.setText("    " + entry.msg);
                        break;
                    }
                    default: {
                        this.setForeground(this.normalcol);
                        this.setText("    " + entry.msg);
                    }
                }
                if (bl) {
                    if (entry.type != 101) {
                        this.setBackground(this.bgcol);
                        this.setForeground(jList.getSelectionForeground());
                    }
                } else {
                    this.setBackground(jList.getBackground());
                }
                this.setEnabled(jList.isEnabled());
                this.setFont(this.normal);
                this.setOpaque(true);
                return this;
            }
        }
    }

    class HelpAction
    extends AbstractAction {
        HelpAction(String string) {
            super(string + "...");
            URL uRL = (class$LogFilter$View == null ? (class$LogFilter$View = View.class$("LogFilter.View")) : class$LogFilter$View).getResource("Images/" + string + ".jpg");
            this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().getImage(uRL)));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            URL uRL = (class$LogFilter$View == null ? (class$LogFilter$View = View.class$("LogFilter.View")) : class$LogFilter$View).getResource("Images/wizard.gif");
            JOptionPane.showMessageDialog(View.this.me, "LogFilter v0.90 \n(c) 2002 Kasper B. Graversen\n\nThis program is freeware - but please give feedback to the author", "Information", 1, new ImageIcon(Toolkit.getDefaultToolkit().getImage(uRL)));
        }
    }

    class QuitAction
    extends AbstractAction {
        QuitAction(String string) {
            super(string);
            URL uRL = (class$LogFilter$View == null ? (class$LogFilter$View = View.class$("LogFilter.View")) : class$LogFilter$View).getResource("Images/" + string + ".jpg");
            this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().getImage(uRL)));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            View.this.controller.quit();
        }
    }

    class ConfigAction
    extends AbstractAction {
        JDialog dialog;
        JTextField exefield;
        JTextField argsfield;
        JSlider overfullpt;

        ConfigAction(String string) {
            super(string + "...");
            URL uRL = (class$LogFilter$View == null ? (class$LogFilter$View = View.class$("LogFilter.View")) : class$LogFilter$View).getResource("Images/" + string + ".gif");
            this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().getImage(uRL)));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.dialog = new JDialog((Frame)View.this.me, "Configuration");
            JPanel jPanel = this.createSlider();
            JPanel jPanel2 = this.createEditorIntegration();
            JPanel jPanel3 = this.createButtons();
            Container container = this.dialog.getContentPane();
            container.setLayout(new BoxLayout(container, 1));
            container.add(jPanel);
            container.add(jPanel2);
            container.add(jPanel3);
            this.dialog.pack();
            this.dialog.show();
        }

        private JPanel createSlider() {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            this.overfullpt = new JSlider(0, 0, 30, View.this.usersettings.min_pt_overfull);
            this.overfullpt.setToolTipText("1 pt = 0.33 mm.  You can (depending on the layout) ignore small values, since these warnings yield no visual errors in the produced document.");
            this.overfullpt.setMajorTickSpacing(5);
            this.overfullpt.setMinorTickSpacing(1);
            this.overfullpt.setPaintTicks(true);
            this.overfullpt.setPaintLabels(true);
            this.overfullpt.setSnapToTicks(true);
            jPanel.add((Component)this.overfullpt, "Center");
            TitledBorder titledBorder = BorderFactory.createTitledBorder("Minimum pt's in Overfull warnings");
            titledBorder.setTitleJustification(2);
            jPanel.setBorder(titledBorder);
            return jPanel;
        }

        private JPanel createEditorIntegration() {
            JPanel jPanel = new JPanel();
            JPanel jPanel2 = new JPanel();
            JPanel jPanel3 = new JPanel();
            JLabel jLabel = new JLabel("<html><br><br><br><br>The editor executable file<html>", 0);
            jLabel.setAlignmentX(0.5f);
            this.exefield = new JTextField(View.this.usersettings.editorexe, 52);
            this.exefield.setFont(new Font("Courier", 0, 11));
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.add(jLabel);
            jPanel.add(this.exefield);
            JLabel jLabel2 = new JLabel("<html>Editor arguments:<p>%f is the filename<p>%l is the linenumber</html>", 0);
            jLabel2.setAlignmentX(0.5f);
            this.argsfield = new JTextField(View.this.usersettings.editorargs, 9);
            this.argsfield.setFont(new Font("Courier", 0, 11));
            String[] stringArray = new String[]{"Any editor", "Emacs", "Jedit", "LaTeX Wide", "PFE", "UltraEdit", "vi(m)", "WinEdt"};
            String[] stringArray2 = new String[]{"", "+%l %f", "%f +line:%l", "%f /L%l", "%/g %l %f", "\"%f/%l/1\"", "+%l %f", "-F \"[Open(|%f|);SelPar(%l,8)]\""};
            JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
            jComboBox.addActionListener(new ActionListener(this, stringArray2){
                private final /* synthetic */ String[] val$supportedEditorsArgs;
                private final /* synthetic */ ConfigAction this$1;
                {
                    this.this$1 = configAction;
                    this.val$supportedEditorsArgs = stringArray;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                    this.this$1.argsfield.setText(this.val$supportedEditorsArgs[jComboBox.getSelectedIndex()]);
                }
            });
            jPanel2.setLayout(new BoxLayout(jPanel2, 1));
            jPanel2.add(jLabel2);
            jPanel2.add(jComboBox);
            jPanel2.add(this.argsfield);
            jPanel3.setLayout(new BoxLayout(jPanel3, 0));
            TitledBorder titledBorder = BorderFactory.createTitledBorder("Editor integration");
            titledBorder.setTitleJustification(2);
            jPanel3.setBorder(titledBorder);
            jPanel3.add(jPanel);
            jPanel3.add(jPanel2);
            return jPanel3;
        }

        private JPanel createButtons() {
            JPanel jPanel = new JPanel();
            URL uRL = (class$LogFilter$View == null ? (class$LogFilter$View = View.class$("LogFilter.View")) : class$LogFilter$View).getResource("Images/Ok.gif");
            JButton jButton = new JButton("Ok", new ImageIcon(Toolkit.getDefaultToolkit().getImage(uRL)));
            jButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ ConfigAction this$1;
                {
                    this.this$1 = configAction;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ConfigAction.access$000((ConfigAction)this.this$1).usersettings.editorexe = this.this$1.exefield.getText();
                    ConfigAction.access$000((ConfigAction)this.this$1).usersettings.editorargs = this.this$1.argsfield.getText();
                    ConfigAction.access$000((ConfigAction)this.this$1).usersettings.min_pt_overfull = this.this$1.overfullpt.getValue();
                    ConfigAction.access$000(this.this$1).reload();
                    ((ConfigAction)ConfigAction.access$000((ConfigAction)this.this$1).configAction).dialog.setVisible(false);
                }
            });
            uRL = (class$LogFilter$View == null ? (class$LogFilter$View = View.class$("LogFilter.View")) : class$LogFilter$View).getResource("Images/Cancel.jpg");
            JButton jButton2 = new JButton("Cancel", new ImageIcon(Toolkit.getDefaultToolkit().getImage(uRL)));
            jButton2.addActionListener(new ActionListener(this){
                private final /* synthetic */ ConfigAction this$1;
                {
                    this.this$1 = configAction;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ((ConfigAction)ConfigAction.access$000((ConfigAction)this.this$1).configAction).dialog.setVisible(false);
                }
            });
            jPanel.add(jButton);
            jPanel.add(jButton2);
            return jPanel;
        }

        static /* synthetic */ View access$000(ConfigAction configAction) {
            return configAction.View.this;
        }
    }

    class OpenAction
    extends AbstractAction {
        OpenAction(String string) {
            super(string + "...");
            URL uRL = (class$LogFilter$View == null ? (class$LogFilter$View = View.class$("LogFilter.View")) : class$LogFilter$View).getResource("Images/" + string + ".gif");
            this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().getImage(uRL)));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                JFileChooser jFileChooser = new JFileChooser(new File(View.this.usersettings.logfilename).getParentFile());
                jFileChooser.setMultiSelectionEnabled(false);
                jFileChooser.setFileFilter(new LogFilter());
                jFileChooser.setDialogTitle("Choose a Tex/LaTeX .log to analyze.");
                int n = jFileChooser.showOpenDialog(View.this.me);
                if (n == 0) {
                    try {
                        View.this.usersettings.logfilename = jFileChooser.getSelectedFile().getCanonicalPath();
                        View.this.me.reload();
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(View.this.me, "Error during load\n" + iOException.getMessage(), "Error during load", 0);
                    }
                }
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(View.this.me, "Unexpected exception" + exception.getMessage(), "Exception", 0);
            }
        }

        class LogFilter
        extends FileFilter {
            LogFilter() {
            }

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = file.getName();
                int n = string.lastIndexOf(46);
                return n == string.length() - 4 && string.substring(n + 1).toLowerCase().equals("log");
            }

            public String getDescription() {
                return "(PDF) TeX/LaTeX *.log files";
            }
        }
    }
}

