/* Length.h
 *
 * The official LaTeX length parameters are implemented here. They control
 * variables such as the paragraph indentation and the space to skip between
 * lines.
 *
 * Copyright 1992 Jonathan Monsarrat. Permission given to freely distribute,
 * edit and use as long as this copyright statement remains intact.
 *
 */

const MAXLENGTHPARAMS = 100;
class Length;
// The class for the official LaTeX Length variables,
// plus any user-defined ones.
class LengthParam {
   float _value;
   char *_tokentext;
   Length *_parent;
 public:
   LengthParam(LengthParam *, Length *);
   LengthParam(float, char *, Length *);
   ~LengthParam();
   void set(float);
   float get();
   static int compare(const void *, const void *);
   void revert(Length *);
   void postscript_set();
   int match(char *);
};

// The official LaTeX Length variables are stored here
class Length : public Param {
 public:
   enum LengthTypes {
      Parameter,
      Parse_Length
   };
   Length();
   Length(Length *);
   ~Length();
   Param *copy();
   void revert(Param *);
   void addtolength(int, int, float, char *);
   void newlength(int, int, float, char *);
   void setlength(int, int, float, char *);
   float length_argument();
   LengthParam **fetch(char *);
 private:
   LengthParam *values[MAXLENGTHPARAMS];
   int set(int, float, char*);
   float get(int, char*);
   void postscript_set(int);
   void makeparam(float, char *);
   void set_lp(LengthParam *, float);
   int numvalues;
};
