/* Justify.C
 *
 * When the user wants flushright, flushleft, centered, or the normal
 * full justification, this class is used.
 *
 * Copyright 1992 Jonathan Monsarrat. Permission given to freely distribute,
 * edit and use as long as this copyright statement remains intact.
 *
 */

#include "Global.h"
#include "Justify.h"
#include "Document.h"
#include <fstream.h>

Justify::Justify()
{
   justifytype = Normal;
   postscript_set(-justifytype);
}

Justify::Justify(Justify *base)
{
   justifytype = base->justifytype;
}

Param *Justify::copy()
{
   return new Justify(this);
}

/* What kind of justification will the following text in this environment
 * have? Set the justifytype variable as appropriate.
 */
int Justify::set(int subtype, float, char *)
{
   if(justifytype != subtype) {
      justifytype = subtype;      // Set the internal placeholder for reference
        // Print the postscript command for this.
      postscript_set(subtype);
   }
   return TRUE;
}

float Justify::get(int, char *)
{
   return (float)justifytype;
}

void Justify::postscript_set(int subtype)
{
   if(subtype>0 && Stack::get(Environment::PDocument,Document::StartPage, ""))
      Global::files->outfile << endl << "NEWPARA ";
   else
      subtype = -subtype;
   switch(subtype) {
   case Center:
      Global::files->outfile << "/justify " << (int)'c' << " def";
      break;
   case FlushLeft:
      Global::files->outfile << "/justify " << (int)'l' << " def";
      break;
   case FlushRight:
      Global::files->outfile << "/justify " << (int)'r' << " def";
      break;
   case Normal:
      Global::files->outfile << "/justify " << (int)'f' << " def";
      break;
   }
   Global::files->outfile << endl;
}

void Justify::revert(Param *from)
{
   int subtype = (int)from->get(0,"");
   if(subtype != justifytype)
      postscript_set(justifytype);
}
