program nic2tex;
{$m 65520,0,600000}
uses
  crt,dos, ch_files, ch_chess, ch_parse, ch_tex, jalfiles;

VAR
  isfile : BOOLEAN;

procedure OpenOFiles(target : sourcetype; fc : longint; VAR f1 : text);

var
  mname : string;

begin

    if target.name='' then
      assign(f1,'')
    else
    if pos(copy(target.name,1,3),' prn PRN')>0 then
      assign(f1,'PRN')
    else
    begin
      mname := jalfiles.Generate_FileName(target.name,fc);
      isfile := TRUE;
      assign(f1,target.path+mname);
      if file_exist(target.path+mname) then
        erase(f1);
    end;
    io_test;
    rewrite(f1);
    io_test;
end; (* OpenOFiles *)


var
  not_printed_games : longint;
  i : integer;
  numb_of_games, game_numb, file_count, print_games : longint;
  f1 : text;
  source, target : sourcetype;
  game : gametype;
  short : boolean;


{mainprogram}
begin
  isfile := FALSE;
  io_test;
  writeln;
  writeln('Carsten Hansen, CH0506@HDC.HHA.DK, any comment welcome');
  writeln('adapted by Jrgen A.Lamers, jaloma@wuivendriet.fido.de');
  writeln;
  writeln('SYNTAX: NIC2TEX source-file target-file');
  writeln;
  writeln('The following games will be omitted: ');
  writeln;
  writeln('- deleted, and overwritten games');
  writeln('- game fragments (games starting with a position)');
  writeln;
  writeln;
  source.name:='';
  target.name:='';
  not_printed_games:=0;
  file_count := 0;
  print_games := 0;
  if paramcount=0 then
  begin
    write('NicBase-file to be converted to PGN:    ');
    readln(source.name);
    write('Name of new TeX file:                   ');
    readln(target.name);
  end
  else
  begin
    source.name:=paramstr(1);
    target.name:=paramstr(2);
    short := (paramstr(3)='-s') OR (paramstr(3)='-S');
  end;
  remove_ext(source.name);
  find_path(source.name,source.path);
  find_path(target.name,target.path);

  if file_exist(source.path+source.name+'.I30') and
     file_exist(source.path+source.name+'.G30') then
  begin
    OpenOFiles(target,file_count,f1);
    open_file_for_read(source.index  ,source.path+source.name+'.I30');
    open_file_for_read(source.game   ,source.path+source.name+'.G30');
    if not io_error then
    begin
      game.game_format:='NIC';
      game.beg:=get_index_val(source.index);
      numb_of_games:=(filesize(source.index.f)-4) div 4;
      writeln(numb_of_games:6,' Games to examine');
      game_numb:=1;
      while (game_numb<=numb_of_games) and (not io_error) and
            (not keypressed) do
      begin
        game.beg_next:=get_index_val(source.index);
        game.len:=game.beg_next-game.beg;
        if game.len<0 then
        begin
          write('game.len<0');
          halt;
        end;
        i:=0;
        while (i<game.len) and (not io_error) do
        begin
          game.bytes[i]:=get_next_byte(source.game);
          inc(i);
        end;
        game.bytes[game.len]:=-1;
        parse_nic_gamehead(game);
        if not (game.deleted or game.overwritten or
                game.position or game.quiz)
        then
        begin
          parse_nic_moves(game);
          if not game.illegal_move then begin
            INC(print_games);
            if short then
              short_print_tex(f1,game)
            else
              print_tex(f1,game)
          end
          else
            inc(not_printed_games);
        end
        else
          inc(not_printed_games);
        game.beg:=game.beg_next;
        if target.name<>'' then
        begin
          gotoxy(1,wherey);
          write(game_numb:6,' Games Examined ',not_printed_games:6,
                ' Games not printed');
        end
        else
        begin
          writeln;
          writeln(game_numb:6,' Games Examined ',not_printed_games:6,
                ' Games not printed');
        end;
        inc(game_numb);
        if (print_games>=10) then begin
          close(f1);
          inc(file_count);
          OpenOFiles(target,file_count,f1);
          print_games :=0;
        end;
      end;
    end;
    writeln;
    close_read_file(source.index);
    close_read_file(source.game);
    if isfile and (print_games=0) then begin
     erase(f1);
     dec(file_count);
     end
    else
      close(f1);
    writeln;
    writeln('Create ',file_count+1,' files from the source-file!');
  end
  else
  begin
    writeln(source.path+source.name,'.* Does not exist');
  end;
end.
