/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bib2gls;

import com.dickimawbooks.bib2gls.Bib2Gls;
import com.dickimawbooks.bib2gls.Bib2GlsAt;
import com.dickimawbooks.bib2gls.Bib2GlsEntry;
import com.dickimawbooks.bib2gls.Bib2GlsMultiEntry;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.bib.BibData;
import com.dickimawbooks.texparserlib.bib.BibParser;
import com.dickimawbooks.texparserlib.bib.BibUserString;
import com.dickimawbooks.texparserlib.bib.BibValueList;
import com.dickimawbooks.texparserlib.latex.CsvList;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Vector;

public class Bib2GlsProgenitor
extends Bib2GlsEntry
implements Bib2GlsMultiEntry {
    private Vector<Bib2GlsEntry> progeny = new Vector();

    public Bib2GlsProgenitor(Bib2Gls bib2Gls) {
        this(bib2Gls, "progenitor");
    }

    public Bib2GlsProgenitor(Bib2Gls bib2Gls, String string) {
        super(bib2Gls, string);
    }

    @Override
    public void checkRequiredFields() {
        if (this.getField("progeny") == null || this.progeny.size() == 0) {
            this.missingFieldWarning("adoptparents");
        }
    }

    @Override
    public String getFallbackValue(String string) {
        if (string.equals("name")) {
            return this.getOriginalId();
        }
        return super.getFallbackValue(string);
    }

    @Override
    public BibValueList getFallbackContents(String string) {
        if (string.equals("name")) {
            if (!this.bib2gls.useInterpreter()) {
                this.bib2gls.warningMessage("warning.interpreter.needed.fallback", string, this.getId());
                return null;
            }
            String string2 = this.getOriginalId();
            BibValueList bibValueList = new BibValueList();
            bibValueList.add((Object)new BibUserString((TeXObject)this.bib2gls.getInterpreterListener().createGroup(string2)));
            return bibValueList;
        }
        return super.getFallbackContents(string);
    }

    @Override
    protected void initMissingFields() {
        if (this.getResource().getLabelPrefix() != null && this.getFieldValue("name") == null) {
            this.putField("name", this.getOriginalId());
        }
    }

    @Override
    protected Vector<String> processSpecialFields(boolean bl, String[] stringArray, String string, Vector<String> vector) throws IOException {
        vector = super.processSpecialFields(bl, stringArray, string, vector);
        for (String string2 : Bib2Gls.SPAWN_SPECIAL_FIELDS) {
            vector = this.processField(string2, bl, stringArray, string, vector);
        }
        return vector;
    }

    @Override
    public void populate(BibParser bibParser) throws IOException {
        String string;
        BibValueList bibValueList = this.getField("adoptparents");
        if (bibValueList == null && (string = this.resource.getOriginalField("adoptparents")) != null) {
            bibValueList = this.getField(string);
        }
        if (bibValueList == null) {
            return;
        }
        string = bibParser.getParser();
        TeXObjectList teXObjectList = bibValueList.expand((TeXParser)string);
        String string2 = teXObjectList.toString((TeXParser)string);
        if (this.resource.isInterpretLabelFieldsEnabled() && string2.matches("(?s).*[\\\\\\{\\}].*")) {
            string2 = this.bib2gls.interpret(string2, bibValueList, true);
            teXObjectList = string.getListener().createString(string2);
        }
        CsvList csvList = CsvList.getList((TeXParser)string, (TeXObject)teXObjectList);
        teXObjectList = new TeXObjectList();
        String string3 = this.getOriginalId();
        String string4 = this.processLabel(string3);
        String string5 = this.resource.getAdoptedParentField();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < csvList.size(); ++i) {
            Object object2;
            String string6 = csvList.getValue(i).toString((TeXParser)string).trim();
            String string7 = null;
            string7 = this.getEntryType().startsWith("spawn") ? this.getEntryType().substring(5) : "index";
            String string8 = string6 + "." + this.getOriginalId();
            this.bib2gls.debugMessage("message.spawning", string8, this.getOriginalId());
            Bib2GlsEntry bib2GlsEntry = Bib2GlsAt.createBib2GlsEntry(this.bib2gls, "spawned" + string7);
            if (bib2GlsEntry == null) {
                throw new NullPointerException();
            }
            this.progeny.add(bib2GlsEntry);
            bib2GlsEntry.setId(this.getPrefix(), string8);
            bib2GlsEntry.setBase(this.getBase());
            bib2GlsEntry.setOriginalEntryType(this.getOriginalEntryType());
            for (Object object2 : this.getKeySet()) {
                if (((String)object2).equals("alias") || ((String)object2).equals("parent") || (bibValueList = this.getField((String)object2)) == null) continue;
                bib2GlsEntry.putField((String)object2, (BibValueList)bibValueList.clone());
            }
            bib2GlsEntry.putField("progenitor", string4);
            bib2GlsEntry.putField(string5, string6);
            bibValueList = new BibValueList();
            bibValueList.add((Object)new BibUserString((TeXObject)bibParser.createString(string4)));
            bib2GlsEntry.putField("progenitor", bibValueList);
            bibValueList = new BibValueList();
            bibValueList.add((Object)new BibUserString((TeXObject)bibParser.createString(string6)));
            bib2GlsEntry.putField(string5, bibValueList);
            this.addDependency(bib2GlsEntry.getId());
            if (teXObjectList.size() > 0) {
                teXObjectList.add((TeXObject)bibParser.getOther(44));
                stringBuilder.append(',');
            }
            String string9 = bib2GlsEntry.getId();
            teXObjectList.addAll((Collection)bibParser.createString(string9));
            stringBuilder.append(string9);
            bibParser.addBibData((BibData)bib2GlsEntry);
            if (this.bib2gls.getDebugLevel() <= 0) continue;
            object2 = bib2GlsEntry.getKeySet().iterator();
            while (object2.hasNext()) {
                String string10 = (String)object2.next();
                bibValueList = bib2GlsEntry.getField(string10);
                this.bib2gls.debug(String.format("%s={%s}", string10, bibValueList == null ? "" : bibValueList.expand((TeXParser)string).toString((TeXParser)string)));
            }
        }
        bibValueList = new BibValueList();
        bibValueList.add((Object)new BibUserString((TeXObject)teXObjectList));
        this.putField("progeny", bibValueList);
        this.putField("progeny", stringBuilder.toString());
    }

    @Override
    public void writeExtraFields(PrintWriter printWriter) throws IOException {
        String string = this.getFieldValue("progeny");
        if (string == null) {
            this.bib2gls.debugMessage("message.entry.lost.field", this.getId(), "progeny");
        } else {
            printWriter.println(String.format("\\GlsXtrSetField{%s}{progeny}{%s}", this.getId(), string));
        }
    }
}

