/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bib2gls;

import com.dickimawbooks.bib2gls.Bib2Gls;
import com.dickimawbooks.bib2gls.Bib2GlsEntry;
import com.dickimawbooks.bib2gls.GlsResource;
import com.dickimawbooks.texparserlib.bib.BibValueList;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Vector;

public class Bib2GlsDualEntry
extends Bib2GlsEntry {
    private boolean isprimary = true;

    public Bib2GlsDualEntry(Bib2Gls bib2Gls) {
        this(bib2Gls, "dualentry");
    }

    public Bib2GlsDualEntry(Bib2Gls bib2Gls, String string) {
        super(bib2Gls, string);
    }

    public boolean isPrimary() {
        return this.isprimary;
    }

    public boolean hasTertiary() {
        return false;
    }

    @Override
    public String getFallbackValue(String string) {
        String string2 = super.getFallbackValue(string);
        if (string2 != null) {
            return string2;
        }
        if (string.equals("descriptionplural")) {
            string2 = this.getFieldValue("description");
            if (string2 == null) {
                return string2;
            }
            String string3 = this.getResource().getDualPluralSuffix();
            return string3 == null ? string2 : string2 + string3;
        }
        if (string.equals("symbolplural")) {
            string2 = this.getFieldValue("symbol");
            if (string2 == null) {
                string2 = this.getFallbackValue("symbol");
            }
            if (string2 == null) {
                return string2;
            }
            String string4 = this.getResource().getDualPluralSuffix();
            return string4 == null ? string2 : string2 + string4;
        }
        if (string.equals("longplural")) {
            string2 = this.getFieldValue("long");
            if (string2 == null) {
                return string2;
            }
            String string5 = this.getResource().getDualPluralSuffix();
            return string5 == null ? string2 : string2 + string5;
        }
        if (string.equals("shortplural")) {
            string2 = this.getFieldValue("short");
            if (string2 == null) {
                string2 = this.getFallbackValue("short");
            }
            if (string2 == null) {
                return string2;
            }
            String string6 = this.getResource().getDualShortPluralSuffix();
            return string6 == null ? string2 : string2 + string6;
        }
        return null;
    }

    public HashMap<String, String> getMappings() {
        return this.getResource().getDualEntryMap();
    }

    public String getFirstMap() {
        return this.getResource().getFirstDualEntryMap();
    }

    public boolean backLink() {
        return this.getResource().backLinkFirstDualEntryMap();
    }

    protected Bib2GlsDualEntry createDualEntry() {
        return new Bib2GlsDualEntry(this.bib2gls, this.getEntryType());
    }

    @Override
    protected Vector<String> processSpecialFields(boolean bl, String[] stringArray, String string, Vector<String> vector) throws IOException {
        vector = super.processSpecialFields(bl, stringArray, string, vector);
        for (String string2 : Bib2Gls.DUAL_SPECIAL_FIELDS) {
            vector = this.processField(string2, bl, stringArray, string, vector);
        }
        return vector;
    }

    public Bib2GlsEntry createDual() {
        String string;
        Object object;
        String string2;
        Object object2;
        GlsResource glsResource = this.getResource();
        String string3 = glsResource.getDualPrefix();
        String string4 = this.getOriginalId();
        Bib2GlsDualEntry bib2GlsDualEntry = this.createDualEntry();
        bib2GlsDualEntry.setId(string3, string4);
        bib2GlsDualEntry.setBase(this.getBase());
        bib2GlsDualEntry.isprimary = false;
        HashMap<String, String> hashMap = this.getMappings();
        String string5 = null;
        String string6 = null;
        String string7 = null;
        if (this.backLink()) {
            string5 = this.getFirstMap();
            string6 = hashMap.get(string5);
        }
        Object object3 = this.getKeySet().iterator();
        while (object3.hasNext()) {
            object2 = this.getKey((String)object3.next());
            string2 = hashMap.get(object2);
            object = this.getField((String)object2);
            string = this.getFieldValue((String)object2);
            if (object == null || string == null || ((String)object2).equals("alias")) continue;
            object = (BibValueList)object.clone();
            if (string2 == null) {
                if (((String)object2).equals("parent")) {
                    string = glsResource.flipLabel(string);
                }
                bib2GlsDualEntry.putField((String)object2, (BibValueList)object);
                bib2GlsDualEntry.putField((String)object2, string);
                continue;
            }
            if (string2.equals("alias")) continue;
            bib2GlsDualEntry.putField(string2, (BibValueList)object);
            bib2GlsDualEntry.putField(string2, string);
        }
        object3 = glsResource.getDualSortField();
        if (!((String)object3).equals("sort")) {
            object2 = this.getField("sort");
            string2 = hashMap.get("sort");
            if (object2 != null && string2 != null) {
                object2 = (BibValueList)object2.clone();
                object = this.getFieldValue("sort");
                bib2GlsDualEntry.putField(string2, (BibValueList)object2);
                bib2GlsDualEntry.putField(string2, (String)object);
            }
        }
        object2 = hashMap.keySet().iterator();
        while (object2.hasNext()) {
            string2 = (String)object2.next();
            object = this.getFieldValue(string2);
            if (object == null) {
                object = this.getFallbackValue(string2);
                string = this.getFallbackContents(string2);
                if (object != null) {
                    this.putField(string2, (String)object);
                    if (string != null) {
                        this.putField(string2, (BibValueList)string.clone());
                    }
                }
            }
            string = hashMap.get(string2);
            if (string5 != null && string7 == null && string.equals(string5)) {
                string7 = string2;
            }
            if (bib2GlsDualEntry.getFieldValue(string) != null) continue;
            object = this.getFallbackValue(string2);
            if (object == null) {
                this.bib2gls.verbose(this.bib2gls.getMessage("message.no.fallback", this.getEntryType(), string2));
                continue;
            }
            BibValueList bibValueList = this.getFallbackContents(string2);
            if (bibValueList != null) {
                bib2GlsDualEntry.putField(string, (BibValueList)bibValueList.clone());
            }
            bib2GlsDualEntry.putField(string, (String)object);
        }
        if (string7 != null) {
            object2 = this.getFieldValue(string7);
            this.putField(string7, String.format("\\bibglshyperlink{%s}{%s}", object2, bib2GlsDualEntry.getId()));
        }
        if (string6 != null) {
            object2 = bib2GlsDualEntry.getFieldValue(string6);
            bib2GlsDualEntry.putField(string6, String.format("\\bibglshyperlink{%s}{%s}", object2, this.getId()));
        }
        if ((object2 = glsResource.getDualField()) != null) {
            bib2GlsDualEntry.putField((String)object2, this.getId());
            this.putField((String)object2, bib2GlsDualEntry.getId());
        }
        return bib2GlsDualEntry;
    }

    @Override
    public void writeInternalFields(PrintWriter printWriter) throws IOException {
        for (String string : Bib2Gls.DUAL_SPECIAL_FIELDS) {
            String string2 = this.getFieldValue(string);
            if (string2 == null) continue;
            printWriter.format("\\GlsXtrSetField{%s}{%s}{%s}%n", this.getId(), string, string2);
        }
    }
}

