/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bib2gls;

import com.dickimawbooks.bib2gls.Bib2Gls;
import com.dickimawbooks.bib2gls.Bib2GlsContributor;
import com.dickimawbooks.bib2gls.Bib2GlsEntry;
import com.dickimawbooks.bib2gls.Bib2GlsMultiEntry;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.bib.BibData;
import com.dickimawbooks.texparserlib.bib.BibEntry;
import com.dickimawbooks.texparserlib.bib.BibParser;
import com.dickimawbooks.texparserlib.bib.BibUserString;
import com.dickimawbooks.texparserlib.bib.BibValueList;
import com.dickimawbooks.texparserlib.bib.Contributor;
import com.dickimawbooks.texparserlib.bib.EtAl;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;

public class Bib2GlsBibTeXEntry
extends Bib2GlsEntry
implements Bib2GlsMultiEntry {
    private Vector<Bib2GlsEntry> contributorList = new Vector();

    public Bib2GlsBibTeXEntry(Bib2Gls bib2Gls) {
        this(bib2Gls, "bibtexentry");
    }

    public Bib2GlsBibTeXEntry(Bib2Gls bib2Gls, String string) {
        super(bib2Gls, string);
    }

    @Override
    public void checkRequiredFields() {
    }

    @Override
    public String getSortFallbackField() {
        String string = this.resource.getCustomEntryDefaultSortField(this.getOriginalEntryType());
        if (string != null) {
            return string;
        }
        return this.resource.getBibTeXEntryDefaultSortField();
    }

    @Override
    public String getFallbackValue(String string) {
        if (string.equals("sort")) {
            return this.getSortFallbackValue();
        }
        if (string.equals("name")) {
            return this.getOriginalId();
        }
        return super.getFallbackValue(string);
    }

    @Override
    public BibValueList getFallbackContents(String string) {
        if (string.equals("sort")) {
            return this.getSortFallbackContents();
        }
        if (string.equals("name") && this.bib2gls.useInterpreter()) {
            String string2 = this.getOriginalId();
            BibValueList bibValueList = new BibValueList();
            bibValueList.add((Object)new BibUserString((TeXObject)this.bib2gls.getInterpreterListener().createGroup(string2)));
            return bibValueList;
        }
        return super.getFallbackContents(string);
    }

    @Override
    public void parseFields() throws IOException {
        BibValueList bibValueList;
        if (!this.fieldsParsed() && (bibValueList = this.removeField("type")) != null) {
            this.putField("bibtype", bibValueList);
        }
        super.parseFields();
    }

    @Override
    public void populate(BibParser bibParser) throws IOException {
        Vector vector = this.getAuthors(bibParser.getParser());
        if (vector != null) {
            this.addContributors(bibParser, vector);
        }
        if ((vector = this.getEditors(bibParser.getParser())) != null) {
            this.addContributors(bibParser, vector);
        }
    }

    protected void addContributors(BibParser bibParser, Vector<Contributor> vector) throws IOException {
        for (Contributor contributor : vector) {
            if (contributor instanceof EtAl) continue;
            TeXObjectList teXObjectList = new TeXObjectList();
            teXObjectList.add((TeXObject)new TeXCsRef("bibglscontributor"));
            Group group = bibParser.createGroup();
            teXObjectList.add((TeXObject)group);
            TeXObject teXObject = contributor.getForenamesObject();
            if (teXObject != null) {
                group.add((TeXObject)teXObject.clone());
            }
            TeXObject teXObject2 = contributor.getVonPartObject();
            group = bibParser.createGroup();
            teXObjectList.add((TeXObject)group);
            if (teXObject2 != null) {
                group.add((TeXObject)teXObject2.clone());
            }
            TeXObject teXObject3 = contributor.getSurnameObject();
            group = bibParser.createGroup();
            teXObjectList.add((TeXObject)group);
            if (teXObject3 != null) {
                group.add((TeXObject)teXObject3.clone());
            }
            TeXObject teXObject4 = contributor.getSuffixObject();
            group = bibParser.createGroup();
            teXObjectList.add((TeXObject)group);
            if (teXObject4 != null) {
                group.add((TeXObject)teXObject4.clone());
            }
            BibValueList bibValueList = new BibValueList();
            bibValueList.add((Object)new BibUserString((TeXObject)teXObjectList));
            String string = this.bib2gls.convertToLabel(bibParser.getParser(), bibValueList, this.resource, false);
            BibEntry bibEntry = bibParser.getBibEntry(string);
            if (bibEntry == null) {
                bibEntry = new Bib2GlsContributor(this.bib2gls);
                bibEntry.setId(string);
                bibEntry.putField("name", bibValueList);
                bibParser.addBibData((BibData)bibEntry);
            }
            if (bibEntry instanceof Bib2GlsEntry) {
                this.contributorList.add((Bib2GlsEntry)bibEntry);
            }
            if (!(bibEntry instanceof Bib2GlsContributor)) continue;
            ((Bib2GlsContributor)bibEntry).addTitle(this);
        }
    }

    public Vector<Bib2GlsEntry> getContributors() {
        return this.contributorList;
    }

    @Override
    public void writeInternalFields(PrintWriter printWriter) throws IOException {
        super.writeInternalFields(printWriter);
        for (Bib2GlsEntry bib2GlsEntry : this.contributorList) {
            if (!bib2GlsEntry.isSelected()) continue;
            printWriter.println(String.format("\\glsxtrfieldlistadd{%s}{%s}{%s}", this.getId(), bib2GlsEntry.getEntryType(), bib2GlsEntry.getId()));
        }
    }

    @Override
    public void writeCsDefinition(PrintWriter printWriter) throws IOException {
        super.writeCsDefinition(printWriter);
        this.resource.writeBibGlsContributorDef(printWriter);
    }

    @Override
    public void initCrossRefs() throws IOException {
        for (Bib2GlsEntry bib2GlsEntry : this.contributorList) {
            this.addDependency(bib2GlsEntry.getId());
            bib2GlsEntry.addCrossRefdBy(this);
        }
        super.initCrossRefs();
    }
}

