/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.glossaries;

import com.dickimawbooks.texparserlib.CaseChange;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.latex.AtFirstOfTwo;
import com.dickimawbooks.texparserlib.latex.AtNumberOfNumber;
import com.dickimawbooks.texparserlib.latex.AtSecondOfTwo;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import com.dickimawbooks.texparserlib.latex.glossaries.AbstractGlsCommand;
import com.dickimawbooks.texparserlib.latex.glossaries.GlossariesSty;
import com.dickimawbooks.texparserlib.latex.glossaries.Glossary;
import com.dickimawbooks.texparserlib.latex.glossaries.GlossaryEntry;
import com.dickimawbooks.texparserlib.latex.glossaries.GlsLabel;
import java.io.IOException;

public class Gls
extends AbstractGlsCommand {
    protected CaseChange caseChange;
    protected boolean isPlural;
    private KeyValList defaultOptions;

    public Gls(GlossariesSty glossariesSty) {
        this("gls", CaseChange.NO_CHANGE, false, glossariesSty);
    }

    public Gls(String string, CaseChange caseChange, GlossariesSty glossariesSty) {
        this(string, caseChange, false, glossariesSty);
    }

    public Gls(String string, CaseChange caseChange, boolean bl, GlossariesSty glossariesSty) {
        super(string, glossariesSty);
        this.caseChange = caseChange;
        this.isPlural = bl;
    }

    @Override
    public Object clone() {
        Gls gls = new Gls(this.getName(), this.getCaseChange(), this.isPlural(), this.getSty());
        gls.setEntryLabelPrefix(this.getEntryLabelPrefix());
        gls.setDefaultOptions(this.defaultOptions);
        return gls;
    }

    public void setDefaultOptions(KeyValList keyValList) {
        this.defaultOptions = keyValList;
    }

    public KeyValList getDefaultOptions() {
        return this.defaultOptions;
    }

    @Override
    public boolean canExpand() {
        return false;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return null;
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        KeyValList keyValList;
        boolean bl = false;
        KeyValList keyValList2 = null;
        if (this.defaultOptions != null) {
            keyValList2 = (KeyValList)this.defaultOptions.clone();
        }
        if ((keyValList = this.popOptKeyValList(teXObjectList, true)) != null) {
            if (keyValList2 == null) {
                keyValList2 = keyValList;
            } else {
                keyValList2.putAll(keyValList);
            }
        }
        if (keyValList2 == null) {
            keyValList2 = new KeyValList();
        }
        GlsLabel glsLabel = this.popEntryLabel(teXParser, teXObjectList);
        TeXObject teXObject = this.popOptArg(TeXObjectList.POP_SHORT, teXParser, teXObjectList);
        GlossaryEntry glossaryEntry = glsLabel.getEntry();
        LaTeXParserListener laTeXParserListener = (LaTeXParserListener)teXParser.getListener();
        TeXObjectList teXObjectList2 = laTeXParserListener.createStack();
        if (glossaryEntry == null) {
            this.sty.undefWarnOrError(teXObjectList, "glossaries.entry.not.defined", glsLabel.getLabel());
        } else {
            boolean bl2 = glossaryEntry.isUnset();
            Glossary glossary = glossaryEntry.getGlossary(teXObjectList);
            String string = glossary.getType();
            laTeXParserListener.putControlSequence(true, glsLabel.duplicate("glslabel"));
            laTeXParserListener.putControlSequence(true, new GenericCommand("glscustomtext"));
            if (teXObject == null) {
                laTeXParserListener.putControlSequence(true, new GenericCommand("glsinsert"));
            } else {
                laTeXParserListener.putControlSequence(true, new GenericCommand("glsinsert", null, teXObject));
            }
            if (this.isPlural) {
                laTeXParserListener.putControlSequence(true, new AtFirstOfTwo("glsifplural"));
            } else {
                laTeXParserListener.putControlSequence(true, new AtSecondOfTwo("glsifplural"));
            }
            switch (this.caseChange) {
                case SENTENCE: {
                    laTeXParserListener.putControlSequence(true, new AtNumberOfNumber("glscapscase", 2, 3));
                    break;
                }
                case TO_UPPER: {
                    laTeXParserListener.putControlSequence(true, new AtNumberOfNumber("glscapscase", 3, 3));
                    break;
                }
                default: {
                    laTeXParserListener.putControlSequence(true, new AtNumberOfNumber("glscapscase", 1, 3));
                }
            }
            ControlSequence controlSequence = teXParser.getControlSequence("gls@" + string + "@entryfmt");
            if (controlSequence == null) {
                controlSequence = laTeXParserListener.getControlSequence("glsentryfmt");
            }
            teXObjectList2.add(laTeXParserListener.getControlSequence("@gls@link"));
            if (keyValList2 != null) {
                teXObjectList2.add(keyValList2);
            }
            teXObjectList2.add(glsLabel);
            teXObjectList2.add(controlSequence);
            TeXParserUtils.process(teXObjectList2, teXParser, teXObjectList);
            if (!bl2) {
                glossaryEntry.unset(bl);
            }
        }
        teXObjectList2.add(laTeXParserListener.getControlSequence("glspostlinkhook"));
        TeXParserUtils.process(teXObjectList2, teXParser, teXObjectList);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }

    public CaseChange getCaseChange() {
        return this.caseChange;
    }

    public boolean isPlural() {
        return this.isPlural;
    }
}

