/*
 * Decompiled with CFR 0.152.
 */
package de.nm.file;

import de.nm.file.XFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.Checksum;

public class XCheckSum {
    private static final int BUFFERSIZE64KB = 65535;
    private CHECKSUM checksum = CHECKSUM.sha256;
    private final byte[] buffer = new byte[65535];
    private Checksum cs;
    private MessageDigest md;
    private int read = 0;

    public XCheckSum(CHECKSUM checksum) throws NoSuchAlgorithmException {
        this.checksum = checksum;
        this.init();
    }

    public XCheckSum(String checksum) throws NoSuchAlgorithmException {
        if ("crc32".equalsIgnoreCase(checksum) || "crc-32".equalsIgnoreCase(checksum)) {
            this.checksum = CHECKSUM.crc32;
        }
        if ("adler32".equalsIgnoreCase(checksum) || "adler-32".equalsIgnoreCase(checksum)) {
            this.checksum = CHECKSUM.adler32;
        }
        if ("md5".equalsIgnoreCase(checksum)) {
            this.checksum = CHECKSUM.md5;
        }
        if ("sha256".equalsIgnoreCase(checksum) || "sha-256".equalsIgnoreCase(checksum)) {
            this.checksum = CHECKSUM.sha256;
        }
        this.init();
    }

    public String getChecksum(File file) throws IOException, NoSuchAlgorithmException {
        return this.getChecksum(XFile.getInputStream(file));
    }

    public String getChecksum(InputStream in) throws IOException, NoSuchAlgorithmException {
        if (this.checksum == CHECKSUM.crc32 || this.checksum == CHECKSUM.adler32) {
            if (this.cs == null) {
                throw new NoSuchAlgorithmException();
            }
            this.cs.reset();
            this.read = 0;
            while ((this.read = in.read(this.buffer)) > 0) {
                this.cs.update(this.buffer, 0, this.read);
            }
            in.close();
            return Long.toHexString(this.cs.getValue());
        }
        if (this.checksum == CHECKSUM.md5 || this.checksum == CHECKSUM.sha256) {
            if (this.md == null) {
                throw new NoSuchAlgorithmException();
            }
            this.read = 0;
            this.md.reset();
            while ((this.read = in.read(this.buffer)) > 0) {
                this.md.update(this.buffer, 0, this.read);
            }
            in.close();
            return new BigInteger(1, this.md.digest()).toString(16);
        }
        throw new NoSuchAlgorithmException();
    }

    private void init() throws NoSuchAlgorithmException {
        if (this.checksum == CHECKSUM.crc32 || this.checksum == CHECKSUM.adler32) {
            this.cs = this.checksum == CHECKSUM.crc32 ? new CRC32() : new Adler32();
        } else if (this.checksum == CHECKSUM.md5 || this.checksum == CHECKSUM.sha256) {
            String cs = "MD5";
            switch (this.checksum) {
                case md5: {
                    cs = "MD5";
                    break;
                }
                case sha256: {
                    cs = "SHA-256";
                }
            }
            this.md = MessageDigest.getInstance(cs);
        } else {
            throw new NoSuchAlgorithmException();
        }
    }

    public static enum CHECKSUM {
        crc32,
        adler32,
        md5,
        sha256;

    }
}

