/*
 * Decompiled with CFR 0.152.
 */
package de.nm.ant.ipdf;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import de.nm.ant.ipdf.AbstractPagesPdfTask;
import java.io.File;
import java.io.IOException;

public class PdfWatermarkTask
extends AbstractPagesPdfTask {
    private int angle = 45;
    private int fontsize = 96;
    private File image = null;
    private boolean over = true;
    private String text = "Entwurf";

    public void execute() {
        try {
            File input = this.getInputFile("pdf", this.usesrcfile);
            File output = this.getOutputFile("pdf");
            this.logVerboseHeader(input, this.pages);
            PdfReader reader = this.createPdfReaderFromFile(input);
            this.maxPage = reader.getNumberOfPages();
            PdfStamper stamper = new PdfStamper(reader, this.createOutputStream(output), this.version);
            stamper.setRotateContents(false);
            Font font = new Font(Font.FontFamily.HELVETICA, (float)this.fontsize, 1, BaseColor.LIGHT_GRAY);
            Image img = null;
            if (this.image != null) {
                img = Image.getInstance((String)this.image.getAbsolutePath());
            }
            int i = 1;
            while (i <= this.maxPage) {
                if (this.isPageinRange(i)) {
                    PdfContentByte canvas = this.over ? stamper.getOverContent(i) : stamper.getUnderContent(i);
                    Rectangle pageSize = reader.getPageSize(i);
                    float pw = pageSize.getWidth();
                    float ph = pageSize.getHeight();
                    if (img == null) {
                        ColumnText.showTextAligned((PdfContentByte)canvas, (int)1, (Phrase)new Phrase(this.text, font), (float)(pw / 2.0f), (float)(ph / 2.0f), (float)this.angle);
                    } else {
                        img.setRotation((float)this.angle);
                        img.scaleToFit(pw, ph);
                        float w = img.getScaledWidth();
                        float h = img.getScaledHeight();
                        img.setAbsolutePosition(pw / 2.0f - w / 2.0f, ph / 2.0f - h / 2.0f);
                        canvas.addImage(img);
                    }
                }
                ++i;
            }
            stamper.close();
        }
        catch (IOException e) {
            this.throwBuildException(e);
        }
        catch (DocumentException e) {
            this.throwBuildException((Exception)((Object)e));
        }
    }

    public void setAngle(int angle) {
        this.angle = angle;
    }

    public void setFontsize(int fontsize) {
        this.fontsize = fontsize;
    }

    public void setImage(File image) {
        this.image = image;
    }

    public void setOver(boolean over) {
        this.over = over;
    }

    public void setText(String text) {
        this.text = text;
    }
}

