[langid]
2057

[schemes]
0=/l30001/l
1=/l30002/l
2=/l30003/l
3=/l30004/l


//***************************************** QWERTY **************************************
// Weight for spelling errors
// Categories:
//    one_letter_insert  - insertion of single letters
//    one_letter_delete  - removal of single letter
//    two_letters_change - change ordering of adjacent letters
//    one_letter_replace - letters substitution
//    split_word         - split word
// Weights:
//    1-9 - weight
// Threshold means default maximal sum of errors
[weights\0]
threshold=10
max_threshold=12
one_letter_insert=4
one_letter_delete=5
one_letter_replace=7
two_letters_change=2
split_word=8

// Substitutions
// Syntax:
//   <in_string>=<weight><out_string>,...
// Special strings:
//    . - given as in_string means any position in the word except for initial and final,
//        given as out_string means empty string
//    @ - means end of the word
//    # - means beginning of the word
[replacements\0]
a=6q,6w,5s,6z
b=5v,6g,6h,5n
c=5x,5d,5f,5v
d=5s,6e,6r,5f,6c,6x
e=5w,6s,6d,5r
f=5d,6r,6t,5g,6v,6c
g=5f,6t,6y,5h,6b,6v
h=5g,6y,6u,5j,6n,6b
i=5u,6j,6k,5o
j=5h,6u,6i,5k,6m,6n
k=5j,6i,6o,5l,6m
l=5k,6o,6p
m=5n,6j,6k
n=5b,6h,6j,5m
o=5i,5p,6l,6k
p=5o,6l
q=5w,6a
r=5e,5t,6f,6d
s=5a,6w,6e,5d,6x,6z
t=5r,5y,6g,6f
u=5y,5i,6j,6h
v=5c,6f,6g,5b
w=5q,5e,6s,6a
x=5z,6s,6d,5c
y=5t,5u,6h,6g
z=6a,6s,5x
A=6Q,6W,5S,6Z
B=5V,6G,6H,5N
C=5X,5D,5F,5V
D=5S,6E,6R,5F,6C,6X
E=5W,6S,6D,5R
F=5D,6R,6T,5G,6V,6C
G=5F,6T,6Y,5H,6B,6V
H=5G,6Y,6U,5J,6N,6B
I=5U,6J,6K,5O
J=5H,6U,6I,5K,6M,6N
K=5J,6I,6O,5L,6M
L=5K,6O,6P
M=5N,6J,6K
N=5B,6H,6J,5M
O=5I,5P,6L,6K
P=5O,6L
Q=5W,6A
R=5E,5T,6F,6D
S=5A,6W,6E,5D,6X,6Z
T=5R,5Y,6G,6F
U=5Y,5I,6J,6H
V=5C,6F,6G,5B
W=5Q,5E,6S,6A
X=5Z,6S,6D,5C
Y=5T,5U,6H,6G
Z=6A,6S,5X
a=5A
b=5B
c=5C
d=5D
e=5E
f=5F
g=5G
h=5H
i=5I
j=5J
k=5K
l=5L
m=5M
n=5N
o=5O
p=5P
q=5Q
r=5R
s=5S
t=5T
u=5U
v=5V
w=5W
x=5X
y=5Y
z=5Z
A=5a
B=5b
C=5c
D=5d
E=5e
F=5f
G=5g
H=5h
I=5i
J=5j
K=5k
L=5l
M=5m
N=5n
O=5o
P=5p
Q=5q
R=5r
S=5s
T=5t
U=5u
V=5v
W=5w
X=5x
Y=5y
Z=5z

// ********** Phonetic substitutions **********
// a, e, i, o, u
a=3e,3i,3o,5u
e=3a,3i,4o,5u
i=3a,3e,5o,5u
o=3a,4e,5i,3u
u=5a,5e,5i,3o

// ay, a, ai, ei, ey, ea
ay=5a,5ai,5ei,5ey,5ea
a=5ay,5ai,5ei,5ey,5ea
ai=5ay,5a,5ei,5ey,5ea
ei=5ay,5a,5ai,5ey,5ea
ey=5ay,5a,5ai,5ei,5ea
ea=5ay,5a,5ai,5ei,5ey

// e, ee, ea, ie, i, ei
e=5ee,5ea,5ie,5i,5ei
ee=5e,5ea,5ie,5i,5ei
ea=5e,5ee,5ie,5i,5ei
ie=5e,5ee,5ea,5i,5ei
i=5e,5ee,5ea,5ie,5ei
ei=5e,5ee,5ea,5ie,5i

// o, oa, oe, ow, ou, eau
o=5oa,5oe,5ow,5ou,5eau
oa=5o,5oe,5ow,5ou,5eau
oe=5o,5oa,5ow,5ou,5eau
ow=5o,5oa,5oe,5ou,5eau
ou=5o,5oa,5oe,5ow,5eau
eau=5o,5oa,5oe,5ow,5ou

// u, o, oo, ou
u=5o,5oo,5ou
o=5u,5oo,5ou
oo=5u,5o,5ou
ou=5u,5o,5oo

// y, i, ie, ye, ei| uy
y=5i,5ie,5ye,5ei
i=5y,5ie,5ye,5ei
ie=5y,5i,5ye,5ei
ye=5y,5i,5ie,5ei
ei=5y,5i,5ie,5ye

// a| ai

// e, ea| a, ai
e=5ea
ea=5e

// i, y
i=5y
y=5i

// u, o, ou| oo, oe
u=5o,5ou
o=5u,5ou
ou=5u,5o

// air, are, ear, aer, ere, eir, ay
air=5are,5ear,5aer,5ere,5eir,5ay
are=5air,5ear,5aer,5ere,5eir,5ay
ear=5air,5are,5aer,5ere,5eir,5ay
aer=5air,5are,5ear,5ere,5eir,5ay
ere=5air,5are,5ear,5aer,5eir,5ay
eir=5air,5are,5ear,5aer,5ere,5ay
ay=5air,5are,5ear,5aer,5ere,5eir

// oo, u, o, ou, oe
5oo=5u,5o,5ou,5oe
5u=5oo,5o,5ou,5oe
5o=5oo,5u,5ou,5oe
5ou=5oo,5u,5o,5oe
5oe=5oo,5u,5o,5ou

// y, i, ea, ee
y=5i,5ea,5ee
i=5y,5ea,5ee
ea=5y,5i,5ee
ee=5y,5i,5ea

// er, ir, ur, yr, ear, our, or
er=5ir,5ur,5yr,5ear,5our,5or
ir=5er,5ur,5yr,5ear,5our,5or
ur=5er,5ir,5yr,5ear,5our,5or
yr=5er,5ir,5ur,5ear,5our,5or
ear=5er,5ir,5ur,5yr,5our,5or
our=5er,5ir,5ur,5yr,5ear,5or
or=5er,5ir,5ur,5yr,5ear,5our

// aw, au, or, ore| oo, oa, ough, a, ou
aw=5au,5or,5ore
au=5aw,5or,5ore
or=5aw,5au,5ore
ore=5aw,5au,5or

// o, ou, a, au
o=5ou,5a,5au
ou=5o,5a,5au
a=5o,5ou,5au
au=5o,5ou,5a

// ar, al, a| au, er, ear
ar=5al,5a,6au,6er,6ear
al=5ar,5a,6au,6er,6ear
a=5ar,5al,6au,6er,6ear
au=6ar,6al,6a,6er,6ear
er=6ar,6al,6a,6au,6ear
ear=6ar,6al,6a,6au,6er

// ow, ou
ow=5ou
ou=5ow

// ear, eer, ea, eir, ere, ier
ear=5eer,5ea,5eir,5ere,5ier
eer=5ear,5ea,5eir,5ere,5ier
ea=5ear,5eer,5eir,5ere,5ier
eir=5ear,5eer,5ea,5ere,5ier
ere=5ear,5eer,5ea,5eir,5ier
ier=5ear,5eer,5ea,5eir,5ere

// oy, oi
oy=5oi
oi=5oy

// oor, ure, ur, ou
oor=5ure,5ur,5ou
ure=5oor,5ur,5ou
ur=5oor,5ure,5ou
ou=5oor,5ure,5ur

// b, bb
b=4bb
bb=4b

// d, dd, ed
d=4dd,4ed
dd=4d,4ed
ed=4d,4dd

// p, pp| gh
p=4pp
pp=4p

// t, tt, th
t=4tt,4th
tt=4t,4th
th=4t,4tt

// c, cc, ck, k, ch, qu
c=4cc,4ck,4k,4ch,4que
cc=4c,4ck,4k,4ch,4que
ck=4c,4cc,4k,4ch,4que
k=4c,4cc,4ck,4ch,4que
ch=4c,4cc,4ck,4k,4que
que=4c,4cc,4ck,4k,4ch

// l, ll
l=4ll
ll=4l

// m, mm
m=4mm
mm=4m

// f, ff, ph, gh
f=4ff,4ph,4gh
ff=4f,4ph,4gh
ph=4f,4ff,4gh
gh=4f,4ff,4ph

// h, wh
h=4wh
wh=4h

// n, nn, kn, en
n=4nn,4kn,4en
nn=4n,4kn,4en
kn=4n,4nn,4en
en=4n,4nn,4kn

// r, rr, wr
r=4rr,4wr
rr=4r,4wr
wr=4r,4rr

// s, ss, c, sc
s=4ss,4c,4sc
ss=4s,4c,4sc
c=4s,4ss,4sc
sc=4s,4ss,4c

// w, u
w=4u
u=4w

// v| f, ph

// z, s, zz| ss tz
z=4s,4zz,4ss,4tz,4x
s=4z,4zz,4ss,4tz,4x
zz=4z,4s,4ss,4tz,4x
ss=4z,4s,4zz,4tz,4x
tz=4z,4s,4zz,4ss,4x
x=4z,4s,4zz,4ss,4tz

// g, gg, gu, gh
g=4gg,4gu,4gh
gg=4g,4gu,4gh
gu=4g,4gg,4gh
gh=4g,4gg,4gu

// ch, tch, t
ch=4tch,4t
tch=4ch,4t
t=4ch,4tch

// ch

// j, g, dg
j=4g,4dg
g=4j,4dg
dg=4j,4g

// ng, n
ng=4n
n=4ng

// th

// th

// y

// s, z, ge
s=4z,4ge
z=4s,4ge
ge=4s,4z

// sh, s, ss, ci, sci, ce, si, ti, ch, t
sh=4s,4ss,4ci,4sci,4ce,4si,4ti,4ch,4t
s=4sh,4ss,4ci,4sci,4ce,4si,4ti,4ch,4t
ss=4sh,4s,4ci,4sci,4ce,4si,4ti,4ch,4t
ci=4sh,4s,4ss,4sci,4ce,4si,4ti,4ch,4t
sci=4sh,4s,4ss,4ci,4ce,4si,4ti,4ch,4t
ce=4sh,4s,4ss,4ci,4sci,4si,4ti,4ch,4t
si=4sh,4s,4ss,4ci,4sci,4ce,4ti,4ch,4t
ti=4sh,4s,4ss,4ci,4sci,4ce,4si,4ch,4t
ch=4sh,4s,4ss,4ci,4sci,4ce,4si,4ti,4t
t=4sh,4s,4ss,4ci,4sci,4ce,4si,4ti,4ch

// Between phonemes
// b, bb <-> p, pp
b=5p,5pp
bb=5p,5pp
p=5b,5bb
pp=5b,5bb

// d, dd <-> t, tt, th
d=5t,5tt,5th
dd=5t,5tt,5th
t=5d,5dd
tt=5d,5dd
th=5d,5dd

// c, cc, ck, k, ch, qu
// g, gg, gu, gh
// k <-> g
c=5g,5gg,5gu,5gh
cc=5g,5gg,5gu,5gh
ck=5g,5gg,5gu,5gh
k=5g,5gg,5gu,5gh
ch=5g,5gg,5gu,5gh
qu=5g,5gg,5gu,5gh
g=5c,5cc,5ck,5k,5ch,5qu
gg=5c,5cc,5ck,5k,5ch,5qu
gu=5c,5cc,5ck,5k,5ch,5qu
gh=5c,5cc,5ck,5k,5ch,5qu

// v|, f, ph
// f, ff, ph, gh
// f <-> v
v=5f,5ff,5ph,5gh
f=5v
ff=5v
ph=5v
gh=5v


// ********** Advanced phonetic substitutions **********
// mute h
.=3h
h=4.

// mute e
.=3e
@=2e
e=3.
e@=2.

// additional vowels
a=4.

.=3a
.=3o

// [k][s] - x
x=5ks,5kz
ks=5x,5kz
kz=5x,5ks

// [g][z] - x
x=5gz,5gs
gz=5x,5gs
gs=5x,5gz


// ********** Double lettes **********
b=2bb
bb=2b
c=2cc
cc=2c
d=2dd
dd=2d
f=2ff
ff=2f
g=2gg
gg=2g
l=2ll
ll=2l
m=2mm
mm=2m
n=2nn
nn=2n
p=2pp
pp=2p
r=2rr
rr=2r
s=2ss
ss=2s
t=2tt
tt=2t
zz=2z
z=2zz


e=2ee
ee=2e
o=2oo
oo=2o


// ********** Nagative prefixes **********
// un, in, im, il, ir
#un=5in,5im,5il,5ir
#in=5un,5im,5il,5ir
#im=5un,5in,5il,5ir
#il=5un,5in,5im,5ir
#ir=5un,5in,5im,5il

// mis, mal
#mis=5mal
#mal=5mis

// a, an
#a=5an
#an=5a

// de, dis
#de=5dis
#dis=5de

// ********** Special prefixes **********
// macro, mega
#macro=5mega
#mega=5macro

// com, con, col
#com=5con,5col
#con=5com,5col
#col=5com,5con

// en, em, in
#en=5em,5in
#em=5en,5in
#in=5en,5em

// poly, multi
#poly=5multi
#multi=5poly


// ********** Nationalities suffixes **********
// an, e, er, i, ian, ese, ean
an@=5e,5er,5i,5ian,5ese,5ean
e@=5an,5er,5i,5ian,5ese,5ean
er@=5an,5e,5i,5ian,5ese,5ean
i@=5an,5e,5er,5ian,5ese,5ean
ian@=5an,5e,5er,5i,5ese,5ean
ese@=5an,5e,5er,5i,5ian,5ean
ean@=5an,5e,5er,5i,5ian,5ese


// ********** Verb suffixes **********
// ize, ise, ate, ify, en
ize@=5ate,5ify,5en
ise@=5ate,5ify,5en
ate@=5ize,5ise,5ify,5en
ify@=5ize,5ise,5ate,5en
en@=5ize,5ise,5ate,5ify

// t, ed
t@=4ed
ed@=4t


// ********** Noun suffixes **********
er@=5or,5ist,5ian
or@=5er,5ist,5ian
ist@=5er,5or,5ian
ian@=5er,5or,5ist

// tion, ation
tion@=5ation
ation@=5tion

// ness, ism, dom, ship
ness@=5dom,5ship
dom@=5ness,5ship
ship@=5ness,5dom

ion@=5ment
ment@=5ion
ion@=5ness
ness@=5ion
ism@=5ity
ity@=5ism

our@=5or
or@=5our

// ist, alist, yist
ist@=5alist
alist@=5ist

// ty, ness
ty@=5ness
ness@=5ty

// wise, ways, way
wise@=5ways,5way,5ward,5wards
ways@=5wise,5way,5ward,5wards
way@=5wise,5ways,5ward,5wards
ward@=5wise,5ways,5way,5wards
wards@=5wise,5ways,5way,5ward


// ********** Adjective suffixes **********
// al, ar, ic, ical, ed, ive
al@=5ar,5ic,5ical,5ed,5ive
ar@=5al,5ic,5ical,5ed,5ive
ic@=5al,5ar,5ical,5ed,5ive
ical@=5al,5ar,5ic,5ed,5ive
ed@=5al,5ar,5ic,5ical,5ive
ive@=5al,5ar,5ic,5ical,5ed


// ********** Adjective / adverb suffixes **********
// al@, ly@, ally@
al@=6ly,6ally
ly@=6al,6ally
ally@=6al,6ly

// ********** Other **********
nt@=5n't
s@=5's


//***************************************** Dvorak - two hands **************************************
[weights\1]
threshold=10
max_threshold=12
one_letter_insert=4
one_letter_delete=5
one_letter_replace=7
two_letters_change=2
split_word=8

[replacements\1]
a=5o
b=5x,5m,6d,6h
c=5g,5r,6h,6t
d=5i,5h,6f,6g,6x,6k
e=5o,5u,6p,6q,6j
f=5y,5g,6d,6i
g=5f,5c,6d,6h
h=5d,5t,6g,6c,6b,6m
i=5u,5d,6y,6f,6k,6x
j=5q,5k,6e,6u
k=5j,5x,6u,6i
l=5r,6n,6s
m=5b,5w,6h,6t
n=5t,5s,6r,6l,6w,6v
o=6a,5e,6q
p=5y,6e,6u
q=5j,6o,6e
r=5c,5l,6t,6n
s=5n,6l,6v,6z
t=5h,5n,6c,6r,6m,6w
u=5e,5i,6p,6y,6j,6k
v=5w,5z,6n,6s
w=5m,5v,6t,6n
x=5k,5b,6i,6d
y=5p,5f,6u,6i
z=5v,6s
a=5A
b=5B
c=5C
d=5D
e=5E
f=5F
g=5G
h=5H
i=5I
j=5J
k=5K
l=5L
m=5M
n=5N
o=5O
p=5P
q=5Q
r=5R
s=5S
t=5T
u=5U
v=5V
w=5W
x=5X
y=5Y
z=5Z
A=5O
B=5X,5M,6D,6H
C=5G,5R,6H,6T
D=5I,5H,6F,6G,6X,6K
E=5O,5U,6P,6Q,6J
F=5Y,5G,6D,6I
G=5F,5C,6D,6H
H=5D,5T,6G,6C,6B,6M
I=5U,5D,6Y,6F,6K,6X
J=5G,5K,6E,6U
K=5J,5X,6U,6I
L=5R,6N,6S
M=5B,5W,6H,6T
N=5T,5S,6R,6L,6W,6V
O=6A,5E,6Q
P=5Y,6E,6U
Q=5J,6O,6E
R=5C,5L,6T,6N
S=5N,6L,6V,6Z
T=5H,5N,6C,6R,6M,6W
U=5E,5I,6P,6Y,6J,6K
V=5W,5Z,6N,6S
W=5M,5V,6T,6N
X=5K,5B,6I,6D
Y=5P,5F,6U,6I
Z=5V,6S
A=5a
B=5b
C=5c
D=5d
E=5e
F=5f
G=5g
H=5h
I=5i
J=5j
K=5k
L=5l
M=5m
N=5n
O=5o
P=5p
Q=5q
R=5r
S=5s
T=5t
U=5u
V=5v
W=5w
X=5x
Y=5y
Z=5z

// ********** Phonetic substitutions **********
// a, e, i, o, u
a=3e,3i,3o,5u
e=3a,3i,4o,5u
i=3a,3e,5o,5u
o=3a,4e,5i,3u
u=5a,5e,5i,3o

// ay, a, ai, ei, ey, ea
ay=5a,5ai,5ei,5ey,5ea
a=5ay,5ai,5ei,5ey,5ea
ai=5ay,5a,5ei,5ey,5ea
ei=5ay,5a,5ai,5ey,5ea
ey=5ay,5a,5ai,5ei,5ea
ea=5ay,5a,5ai,5ei,5ey

// e, ee, ea, ie, i, ei
e=5ee,5ea,5ie,5i,5ei
ee=5e,5ea,5ie,5i,5ei
ea=5e,5ee,5ie,5i,5ei
ie=5e,5ee,5ea,5i,5ei
i=5e,5ee,5ea,5ie,5ei
ei=5e,5ee,5ea,5ie,5i

// o, oa, oe, ow, ou, eau
o=5oa,5oe,5ow,5ou,5eau
oa=5o,5oe,5ow,5ou,5eau
oe=5o,5oa,5ow,5ou,5eau
ow=5o,5oa,5oe,5ou,5eau
ou=5o,5oa,5oe,5ow,5eau
eau=5o,5oa,5oe,5ow,5ou

// u, o, oo, ou
u=5o,5oo,5ou
o=5u,5oo,5ou
oo=5u,5o,5ou
ou=5u,5o,5oo

// y, i, ie, ye, ei| uy
y=5i,5ie,5ye,5ei
i=5y,5ie,5ye,5ei
ie=5y,5i,5ye,5ei
ye=5y,5i,5ie,5ei
ei=5y,5i,5ie,5ye

// a| ai

// e, ea| a, ai
e=5ea
ea=5e

// i, y
i=5y
y=5i

// u, o, ou| oo, oe
u=5o,5ou
o=5u,5ou
ou=5u,5o

// air, are, ear, aer, ere, eir, ay
air=5are,5ear,5aer,5ere,5eir,5ay
are=5air,5ear,5aer,5ere,5eir,5ay
ear=5air,5are,5aer,5ere,5eir,5ay
aer=5air,5are,5ear,5ere,5eir,5ay
ere=5air,5are,5ear,5aer,5eir,5ay
eir=5air,5are,5ear,5aer,5ere,5ay
ay=5air,5are,5ear,5aer,5ere,5eir

// oo, u, o, ou, oe
5oo=5u,5o,5ou,5oe
5u=5oo,5o,5ou,5oe
5o=5oo,5u,5ou,5oe
5ou=5oo,5u,5o,5oe
5oe=5oo,5u,5o,5ou

// y, i, ea, ee
y=5i,5ea,5ee
i=5y,5ea,5ee
ea=5y,5i,5ee
ee=5y,5i,5ea

// er, ir, ur, yr, ear, our, or
er=5ir,5ur,5yr,5ear,5our,5or
ir=5er,5ur,5yr,5ear,5our,5or
ur=5er,5ir,5yr,5ear,5our,5or
yr=5er,5ir,5ur,5ear,5our,5or
ear=5er,5ir,5ur,5yr,5our,5or
our=5er,5ir,5ur,5yr,5ear,5or
or=5er,5ir,5ur,5yr,5ear,5our

// aw, au, or, ore| oo, oa, ough, a, ou
aw=5au,5or,5ore
au=5aw,5or,5ore
or=5aw,5au,5ore
ore=5aw,5au,5or

// o, ou, a, au
o=5ou,5a,5au
ou=5o,5a,5au
a=5o,5ou,5au
au=5o,5ou,5a

// ar, al, a| au, er, ear
ar=5al,5a,6au,6er,6ear
al=5ar,5a,6au,6er,6ear
a=5ar,5al,6au,6er,6ear
au=6ar,6al,6a,6er,6ear
er=6ar,6al,6a,6au,6ear
ear=6ar,6al,6a,6au,6er

// ow, ou
ow=5ou
ou=5ow

// ear, eer, ea, eir, ere, ier
ear=5eer,5ea,5eir,5ere,5ier
eer=5ear,5ea,5eir,5ere,5ier
ea=5ear,5eer,5eir,5ere,5ier
eir=5ear,5eer,5ea,5ere,5ier
ere=5ear,5eer,5ea,5eir,5ier
ier=5ear,5eer,5ea,5eir,5ere

// oy, oi
oy=5oi
oi=5oy

// oor, ure, ur, ou
oor=5ure,5ur,5ou
ure=5oor,5ur,5ou
ur=5oor,5ure,5ou
ou=5oor,5ure,5ur

// b, bb
b=4bb
bb=4b

// d, dd, ed
d=4dd,4ed
dd=4d,4ed
ed=4d,4dd

// p, pp| gh
p=4pp
pp=4p

// t, tt, th
t=4tt,4th
tt=4t,4th
th=4t,4tt

// c, cc, ck, k, ch, qu
c=4cc,4ck,4k,4ch,4que
cc=4c,4ck,4k,4ch,4que
ck=4c,4cc,4k,4ch,4que
k=4c,4cc,4ck,4ch,4que
ch=4c,4cc,4ck,4k,4que
que=4c,4cc,4ck,4k,4ch

// l, ll
l=4ll
ll=4l

// m, mm
m=4mm
mm=4m

// f, ff, ph, gh
f=4ff,4ph,4gh
ff=4f,4ph,4gh
ph=4f,4ff,4gh
gh=4f,4ff,4ph

// h, wh
h=4wh
wh=4h

// n, nn, kn, en
n=4nn,4kn,4en
nn=4n,4kn,4en
kn=4n,4nn,4en
en=4n,4nn,4kn

// r, rr, wr
r=4rr,4wr
rr=4r,4wr
wr=4r,4rr

// s, ss, c, sc
s=4ss,4c,4sc
ss=4s,4c,4sc
c=4s,4ss,4sc
sc=4s,4ss,4c

// w, u
w=4u
u=4w

// v| f, ph

// z, s, zz| ss tz
z=4s,4zz,4ss,4tz,4x
s=4z,4zz,4ss,4tz,4x
zz=4z,4s,4ss,4tz,4x
ss=4z,4s,4zz,4tz,4x
tz=4z,4s,4zz,4ss,4x
x=4z,4s,4zz,4ss,4tz

// g, gg, gu, gh
g=4gg,4gu,4gh
gg=4g,4gu,4gh
gu=4g,4gg,4gh
gh=4g,4gg,4gu

// ch, tch, t
ch=4tch,4t
tch=4ch,4t
t=4ch,4tch

// ch

// j, g, dg
j=4g,4dg
g=4j,4dg
dg=4j,4g

// ng, n
ng=4n
n=4ng

// th

// th

// y

// s, z, ge
s=4z,4ge
z=4s,4ge
ge=4s,4z

// sh, s, ss, ci, sci, ce, si, ti, ch, t
sh=4s,4ss,4ci,4sci,4ce,4si,4ti,4ch,4t
s=4sh,4ss,4ci,4sci,4ce,4si,4ti,4ch,4t
ss=4sh,4s,4ci,4sci,4ce,4si,4ti,4ch,4t
ci=4sh,4s,4ss,4sci,4ce,4si,4ti,4ch,4t
sci=4sh,4s,4ss,4ci,4ce,4si,4ti,4ch,4t
ce=4sh,4s,4ss,4ci,4sci,4si,4ti,4ch,4t
si=4sh,4s,4ss,4ci,4sci,4ce,4ti,4ch,4t
ti=4sh,4s,4ss,4ci,4sci,4ce,4si,4ch,4t
ch=4sh,4s,4ss,4ci,4sci,4ce,4si,4ti,4t
t=4sh,4s,4ss,4ci,4sci,4ce,4si,4ti,4ch

// Between phonemes
// b, bb <-> p, pp
b=5p,5pp
bb=5p,5pp
p=5b,5bb
pp=5b,5bb

// d, dd <-> t, tt, th
d=5t,5tt,5th
dd=5t,5tt,5th
t=5d,5dd
tt=5d,5dd
th=5d,5dd

// c, cc, ck, k, ch, qu
// g, gg, gu, gh
// k <-> g
c=5g,5gg,5gu,5gh
cc=5g,5gg,5gu,5gh
ck=5g,5gg,5gu,5gh
k=5g,5gg,5gu,5gh
ch=5g,5gg,5gu,5gh
qu=5g,5gg,5gu,5gh
g=5c,5cc,5ck,5k,5ch,5qu
gg=5c,5cc,5ck,5k,5ch,5qu
gu=5c,5cc,5ck,5k,5ch,5qu
gh=5c,5cc,5ck,5k,5ch,5qu

// v|, f, ph
// f, ff, ph, gh
// f <-> v
v=5f,5ff,5ph,5gh
f=5v
ff=5v
ph=5v
gh=5v


// ********** Advanced phonetic substitutions **********
// mute h
.=3h
h=4.

// mute e
.=3e
@=2e
e=3.
e@=2.

// additional vowels
a=4.

.=3a
.=3o

// [k][s] - x
x=5ks,5kz
ks=5x,5kz
kz=5x,5ks

// [g][z] - x
x=5gz,5gs
gz=5x,5gs
gs=5x,5gz


// ********** Double lettes **********
b=2bb
bb=2b
c=2cc
cc=2c
d=2dd
dd=2d
f=2ff
ff=2f
g=2gg
gg=2g
l=2ll
ll=2l
m=2mm
mm=2m
n=2nn
nn=2n
p=2pp
pp=2p
r=2rr
rr=2r
s=2ss
ss=2s
t=2tt
tt=2t
zz=2z
z=2zz


e=2ee
ee=2e
o=2oo
oo=2o


// ********** Nagative prefixes **********
// un, in, im, il, ir
#un=5in,5im,5il,5ir
#in=5un,5im,5il,5ir
#im=5un,5in,5il,5ir
#il=5un,5in,5im,5ir
#ir=5un,5in,5im,5il

// mis, mal
#mis=5mal
#mal=5mis

// a, an
#a=5an
#an=5a

// de, dis
#de=5dis
#dis=5de

// ********** Special prefixes **********
// macro, mega
#macro=5mega
#mega=5macro

// com, con, col
#com=5con,5col
#con=5com,5col
#col=5com,5con

// en, em, in
#en=5em,5in
#em=5en,5in
#in=5en,5em

// poly, multi
#poly=5multi
#multi=5poly


// ********** Nationalities suffixes **********
// an, e, er, i, ian, ese, ean
an@=5e,5er,5i,5ian,5ese,5ean
e@=5an,5er,5i,5ian,5ese,5ean
er@=5an,5e,5i,5ian,5ese,5ean
i@=5an,5e,5er,5ian,5ese,5ean
ian@=5an,5e,5er,5i,5ese,5ean
ese@=5an,5e,5er,5i,5ian,5ean
ean@=5an,5e,5er,5i,5ian,5ese


// ********** Verb suffixes **********
// ize, ise, ate, ify, en
ize@=5ate,5ify,5en
ise@=5ate,5ify,5en
ate@=5ize,5ise,5ify,5en
ify@=5ize,5ise,5ate,5en
en@=5ize,5ise,5ate,5ify

// t, ed
t@=4ed
ed@=4t


// ********** Noun suffixes **********
er@=5or,5ist,5ian
or@=5er,5ist,5ian
ist@=5er,5or,5ian
ian@=5er,5or,5ist

// tion, ation
tion@=5ation
ation@=5tion

// ness, ism, dom, ship
ness@=5dom,5ship
dom@=5ness,5ship
ship@=5ness,5dom

ion@=5ment
ment@=5ion
ion@=5ness
ness@=5ion
ism@=5ity
ity@=5ism

our@=5or
or@=5our

// ist, alist, yist
ist@=5alist
alist@=5ist

// ty, ness
ty@=5ness
ness@=5ty

// wise, ways, way
wise@=5ways,5way,5ward,5wards
ways@=5wise,5way,5ward,5wards
way@=5wise,5ways,5ward,5wards
ward@=5wise,5ways,5way,5wards
wards@=5wise,5ways,5way,5ward


// ********** Adjective suffixes **********
// al, ar, ic, ical, ed, ive
al@=5ar,5ic,5ical,5ed,5ive
ar@=5al,5ic,5ical,5ed,5ive
ic@=5al,5ar,5ical,5ed,5ive
ical@=5al,5ar,5ic,5ed,5ive
ed@=5al,5ar,5ic,5ical,5ive
ive@=5al,5ar,5ic,5ical,5ed


// ********** Adjective / adverb suffixes **********
// al@, ly@, ally@
al@=6ly,6ally
ly@=6al,6ally
ally@=6al,6ly

// ********** Other **********
nt@=5n't
s@=5's


//***************************************** Dvorak - right hand **************************************
[weights\2]
threshold=10
max_threshold=12
one_letter_insert=4
one_letter_delete=5
one_letter_replace=7
two_letters_change=2
split_word=8

[replacements\2]
a=5z,56,6o,6x
b=5y,6c,6k
c=5d,5k,6y,6b,6v,6g
d=5t,5c,6u,6y,6w,6v
e=5a,5h,6o,6r,6i
f=5m,5p,6s,6u
g=5v,6c,6k
h=5e,5t,6r,6s,6i,6n
i=5n,6e,6h
j=5l,6o
k=5c,6b,6g
l=5j,5m,5o,5r
m=5l,5f,6r,6s
n=5i,5w,6h,6t
o=5r,6j,6l,6a,6e
p=5f,6u,6y
q=6z
r=5o,5s,6l,6m,6e,6h
s=5r,5u,6m,6f,6h,6t
t=5h,5d,6s,6u,6n,6w
u=5s,5y,6f,6p,6t,6d
v=5w,5g,6d,6c
w=5n,5v,6t,6d
x=6z,6a
y=5u,5b,6p,6d,6c
z=5a,6q,6x
a=5A
b=5B
c=5C
d=5D
e=5E
f=5F
g=5G
h=5H
i=5I
j=5J
k=5K
l=5L
m=5M
n=5N
o=5O
p=5P
q=5Q
r=5R
s=5S
t=5T
u=5U
v=5V
w=5W
x=5X
y=5Y
z=5Z
A=5Z,5E,6O,6X
B=5Y,6C,6K
C=5D,5K,6Y,6B,6V,6G
D=5T,5C,6U,6Y,6W,6V
E=5A,5H,6O,6R,6I
F=5M,5P,6S,6U
G=5V,6C,6K
H=5E,5T,6R,6S,6I,6N
I=5N,6E,6H
J=5L,6O
K=5C,6B,6G
L=5J,5M,5O,5R
M=5L,5F,6R,6S
N=5I,5W,6H,6T
O=5R,6J,6L,6A,6E
P=5F,6U,6Y
Q=6Z
R=5O,5S,6L,6M,6E,6H
S=5R,5U,6M,6F,6H,6T
T=5H,5D,6S,6U,6N,6W
U=5S,5Y,6F,6P,6T,6D
V=5W,5G,6D,6C
W=5N,5V,6T,6D
X=6Z,6A
Y=5U,5B,6P,6D,6C
Z=5A,6Q,6X
A=5a
B=5b
C=5c
D=5d
E=5e
F=5f
G=5g
H=5h
I=5i
J=5j
K=5k
L=5l
M=5m
N=5n
O=5o
P=5p
Q=5q
R=5r
S=5s
T=5t
U=5u
V=5v
W=5w
X=5x
Y=5y
Z=5z

// ********** Phonetic substitutions **********
// a, e, i, o, u
a=3e,3i,3o,5u
e=3a,3i,4o,5u
i=3a,3e,5o,5u
o=3a,4e,5i,3u
u=5a,5e,5i,3o

// ay, a, ai, ei, ey, ea
ay=5a,5ai,5ei,5ey,5ea
a=5ay,5ai,5ei,5ey,5ea
ai=5ay,5a,5ei,5ey,5ea
ei=5ay,5a,5ai,5ey,5ea
ey=5ay,5a,5ai,5ei,5ea
ea=5ay,5a,5ai,5ei,5ey

// e, ee, ea, ie, i, ei
e=5ee,5ea,5ie,5i,5ei
ee=5e,5ea,5ie,5i,5ei
ea=5e,5ee,5ie,5i,5ei
ie=5e,5ee,5ea,5i,5ei
i=5e,5ee,5ea,5ie,5ei
ei=5e,5ee,5ea,5ie,5i

// o, oa, oe, ow, ou, eau
o=5oa,5oe,5ow,5ou,5eau
oa=5o,5oe,5ow,5ou,5eau
oe=5o,5oa,5ow,5ou,5eau
ow=5o,5oa,5oe,5ou,5eau
ou=5o,5oa,5oe,5ow,5eau
eau=5o,5oa,5oe,5ow,5ou

// u, o, oo, ou
u=5o,5oo,5ou
o=5u,5oo,5ou
oo=5u,5o,5ou
ou=5u,5o,5oo

// y, i, ie, ye, ei| uy
y=5i,5ie,5ye,5ei
i=5y,5ie,5ye,5ei
ie=5y,5i,5ye,5ei
ye=5y,5i,5ie,5ei
ei=5y,5i,5ie,5ye

// a| ai

// e, ea| a, ai
e=5ea
ea=5e

// i, y
i=5y
y=5i

// u, o, ou| oo, oe
u=5o,5ou
o=5u,5ou
ou=5u,5o

// air, are, ear, aer, ere, eir, ay
air=5are,5ear,5aer,5ere,5eir,5ay
are=5air,5ear,5aer,5ere,5eir,5ay
ear=5air,5are,5aer,5ere,5eir,5ay
aer=5air,5are,5ear,5ere,5eir,5ay
ere=5air,5are,5ear,5aer,5eir,5ay
eir=5air,5are,5ear,5aer,5ere,5ay
ay=5air,5are,5ear,5aer,5ere,5eir

// oo, u, o, ou, oe
5oo=5u,5o,5ou,5oe
5u=5oo,5o,5ou,5oe
5o=5oo,5u,5ou,5oe
5ou=5oo,5u,5o,5oe
5oe=5oo,5u,5o,5ou

// y, i, ea, ee
y=5i,5ea,5ee
i=5y,5ea,5ee
ea=5y,5i,5ee
ee=5y,5i,5ea

// er, ir, ur, yr, ear, our, or
er=5ir,5ur,5yr,5ear,5our,5or
ir=5er,5ur,5yr,5ear,5our,5or
ur=5er,5ir,5yr,5ear,5our,5or
yr=5er,5ir,5ur,5ear,5our,5or
ear=5er,5ir,5ur,5yr,5our,5or
our=5er,5ir,5ur,5yr,5ear,5or
or=5er,5ir,5ur,5yr,5ear,5our

// aw, au, or, ore| oo, oa, ough, a, ou
aw=5au,5or,5ore
au=5aw,5or,5ore
or=5aw,5au,5ore
ore=5aw,5au,5or

// o, ou, a, au
o=5ou,5a,5au
ou=5o,5a,5au
a=5o,5ou,5au
au=5o,5ou,5a

// ar, al, a| au, er, ear
ar=5al,5a,6au,6er,6ear
al=5ar,5a,6au,6er,6ear
a=5ar,5al,6au,6er,6ear
au=6ar,6al,6a,6er,6ear
er=6ar,6al,6a,6au,6ear
ear=6ar,6al,6a,6au,6er

// ow, ou
ow=5ou
ou=5ow

// ear, eer, ea, eir, ere, ier
ear=5eer,5ea,5eir,5ere,5ier
eer=5ear,5ea,5eir,5ere,5ier
ea=5ear,5eer,5eir,5ere,5ier
eir=5ear,5eer,5ea,5ere,5ier
ere=5ear,5eer,5ea,5eir,5ier
ier=5ear,5eer,5ea,5eir,5ere

// oy, oi
oy=5oi
oi=5oy

// oor, ure, ur, ou
oor=5ure,5ur,5ou
ure=5oor,5ur,5ou
ur=5oor,5ure,5ou
ou=5oor,5ure,5ur

// b, bb
b=4bb
bb=4b

// d, dd, ed
d=4dd,4ed
dd=4d,4ed
ed=4d,4dd

// p, pp| gh
p=4pp
pp=4p

// t, tt, th
t=4tt,4th
tt=4t,4th
th=4t,4tt

// c, cc, ck, k, ch, qu
c=4cc,4ck,4k,4ch,4que
cc=4c,4ck,4k,4ch,4que
ck=4c,4cc,4k,4ch,4que
k=4c,4cc,4ck,4ch,4que
ch=4c,4cc,4ck,4k,4que
que=4c,4cc,4ck,4k,4ch

// l, ll
l=4ll
ll=4l

// m, mm
m=4mm
mm=4m

// f, ff, ph, gh
f=4ff,4ph,4gh
ff=4f,4ph,4gh
ph=4f,4ff,4gh
gh=4f,4ff,4ph

// h, wh
h=4wh
wh=4h

// n, nn, kn, en
n=4nn,4kn,4en
nn=4n,4kn,4en
kn=4n,4nn,4en
en=4n,4nn,4kn

// r, rr, wr
r=4rr,4wr
rr=4r,4wr
wr=4r,4rr

// s, ss, c, sc
s=4ss,4c,4sc
ss=4s,4c,4sc
c=4s,4ss,4sc
sc=4s,4ss,4c

// w, u
w=4u
u=4w

// v| f, ph

// z, s, zz| ss tz
z=4s,4zz,4ss,4tz,4x
s=4z,4zz,4ss,4tz,4x
zz=4z,4s,4ss,4tz,4x
ss=4z,4s,4zz,4tz,4x
tz=4z,4s,4zz,4ss,4x
x=4z,4s,4zz,4ss,4tz

// g, gg, gu, gh
g=4gg,4gu,4gh
gg=4g,4gu,4gh
gu=4g,4gg,4gh
gh=4g,4gg,4gu

// ch, tch, t
ch=4tch,4t
tch=4ch,4t
t=4ch,4tch

// ch

// j, g, dg
j=4g,4dg
g=4j,4dg
dg=4j,4g

// ng, n
ng=4n
n=4ng

// th

// th

// y

// s, z, ge
s=4z,4ge
z=4s,4ge
ge=4s,4z

// sh, s, ss, ci, sci, ce, si, ti, ch, t
sh=4s,4ss,4ci,4sci,4ce,4si,4ti,4ch,4t
s=4sh,4ss,4ci,4sci,4ce,4si,4ti,4ch,4t
ss=4sh,4s,4ci,4sci,4ce,4si,4ti,4ch,4t
ci=4sh,4s,4ss,4sci,4ce,4si,4ti,4ch,4t
sci=4sh,4s,4ss,4ci,4ce,4si,4ti,4ch,4t
ce=4sh,4s,4ss,4ci,4sci,4si,4ti,4ch,4t
si=4sh,4s,4ss,4ci,4sci,4ce,4ti,4ch,4t
ti=4sh,4s,4ss,4ci,4sci,4ce,4si,4ch,4t
ch=4sh,4s,4ss,4ci,4sci,4ce,4si,4ti,4t
t=4sh,4s,4ss,4ci,4sci,4ce,4si,4ti,4ch

// Between phonemes
// b, bb <-> p, pp
b=5p,5pp
bb=5p,5pp
p=5b,5bb
pp=5b,5bb

// d, dd <-> t, tt, th
d=5t,5tt,5th
dd=5t,5tt,5th
t=5d,5dd
tt=5d,5dd
th=5d,5dd

// c, cc, ck, k, ch, qu
// g, gg, gu, gh
// k <-> g
c=5g,5gg,5gu,5gh
cc=5g,5gg,5gu,5gh
ck=5g,5gg,5gu,5gh
k=5g,5gg,5gu,5gh
ch=5g,5gg,5gu,5gh
qu=5g,5gg,5gu,5gh
g=5c,5cc,5ck,5k,5ch,5qu
gg=5c,5cc,5ck,5k,5ch,5qu
gu=5c,5cc,5ck,5k,5ch,5qu
gh=5c,5cc,5ck,5k,5ch,5qu

// v|, f, ph
// f, ff, ph, gh
// f <-> v
v=5f,5ff,5ph,5gh
f=5v
ff=5v
ph=5v
gh=5v


// ********** Advanced phonetic substitutions **********
// mute h
.=3h
h=4.

// mute e
.=3e
@=2e
e=3.
e@=2.

// additional vowels
a=4.

.=3a
.=3o

// [k][s] - x
x=5ks,5kz
ks=5x,5kz
kz=5x,5ks

// [g][z] - x
x=5gz,5gs
gz=5x,5gs
gs=5x,5gz


// ********** Double lettes **********
b=2bb
bb=2b
c=2cc
cc=2c
d=2dd
dd=2d
f=2ff
ff=2f
g=2gg
gg=2g
l=2ll
ll=2l
m=2mm
mm=2m
n=2nn
nn=2n
p=2pp
pp=2p
r=2rr
rr=2r
s=2ss
ss=2s
t=2tt
tt=2t
zz=2z
z=2zz


e=2ee
ee=2e
o=2oo
oo=2o


// ********** Nagative prefixes **********
// un, in, im, il, ir
#un=5in,5im,5il,5ir
#in=5un,5im,5il,5ir
#im=5un,5in,5il,5ir
#il=5un,5in,5im,5ir
#ir=5un,5in,5im,5il

// mis, mal
#mis=5mal
#mal=5mis

// a, an
#a=5an
#an=5a

// de, dis
#de=5dis
#dis=5de

// ********** Special prefixes **********
// macro, mega
#macro=5mega
#mega=5macro

// com, con, col
#com=5con,5col
#con=5com,5col
#col=5com,5con

// en, em, in
#en=5em,5in
#em=5en,5in
#in=5en,5em

// poly, multi
#poly=5multi
#multi=5poly


// ********** Nationalities suffixes **********
// an, e, er, i, ian, ese, ean
an@=5e,5er,5i,5ian,5ese,5ean
e@=5an,5er,5i,5ian,5ese,5ean
er@=5an,5e,5i,5ian,5ese,5ean
i@=5an,5e,5er,5ian,5ese,5ean
ian@=5an,5e,5er,5i,5ese,5ean
ese@=5an,5e,5er,5i,5ian,5ean
ean@=5an,5e,5er,5i,5ian,5ese


// ********** Verb suffixes **********
// ize, ise, ate, ify, en
ize@=5ate,5ify,5en
ise@=5ate,5ify,5en
ate@=5ize,5ise,5ify,5en
ify@=5ize,5ise,5ate,5en
en@=5ize,5ise,5ate,5ify

// t, ed
t@=4ed
ed@=4t


// ********** Noun suffixes **********
er@=5or,5ist,5ian
or@=5er,5ist,5ian
ist@=5er,5or,5ian
ian@=5er,5or,5ist

// tion, ation
tion@=5ation
ation@=5tion

// ness, ism, dom, ship
ness@=5dom,5ship
dom@=5ness,5ship
ship@=5ness,5dom

ion@=5ment
ment@=5ion
ion@=5ness
ness@=5ion
ism@=5ity
ity@=5ism

our@=5or
or@=5our

// ist, alist, yist
ist@=5alist
alist@=5ist

// ty, ness
ty@=5ness
ness@=5ty

// wise, ways, way
wise@=5ways,5way,5ward,5wards
ways@=5wise,5way,5ward,5wards
way@=5wise,5ways,5ward,5wards
ward@=5wise,5ways,5way,5wards
wards@=5wise,5ways,5way,5ward


// ********** Adjective suffixes **********
// al, ar, ic, ical, ed, ive
al@=5ar,5ic,5ical,5ed,5ive
ar@=5al,5ic,5ical,5ed,5ive
ic@=5al,5ar,5ical,5ed,5ive
ical@=5al,5ar,5ic,5ed,5ive
ed@=5al,5ar,5ic,5ical,5ive
ive@=5al,5ar,5ic,5ical,5ed


// ********** Adjective / adverb suffixes **********
// al@, ly@, ally@
al@=6ly,6ally
ly@=6al,6ally
ally@=6al,6ly

// ********** Other **********
nt@=5n't
s@=5's


//***************************************** Dvorak - left hand **************************************
[weights\3]
threshold=10
max_threshold=12
one_letter_insert=4
one_letter_delete=5
one_letter_replace=7
two_letters_change=2
split_word=8

[replacements\3]
a=5e,5z,6o,6i
b=5q,5y,6k,6p,6c
c=5k,5d,6b,6y,6x,6g
d=5c,5t,6y,6u,6g,6v
e=5h,5a,6s,6o,6n,6i
f=5p,5m,6y,6u
g=5x,5v,6c,6d
h=5t,5e,6r,6s,6w,6n
i=5n,6e,6a
j=5l,6s,6o
k=5c,6q,6b,6k
l=5m,5j,6r,6s
m=5f,5l,6r,6s
n=5w,5i,6h,6e
o=5s,6j,6e,6a
p=5f,6b,6y
q=5b,6k,6c
r=5u,5s,6m,6l,6t,6h
s=5r,5o,6l,6j,6h,6e
t=5d,5h,6u,6r,6v,6w
u=5y,5r,6f,6m,6d,6t
v=5g,5w,6d,6t
w=5v,5n,6t,6h
x=5g,6k,6c
y=5b,5u,6p,6f,6c,6d
z=5a
a=5A
b=5B
c=5C
d=5D
e=5E
f=5F
g=5G
h=5H
i=5I
j=5J
k=5K
l=5L
m=5M
n=5N
o=5O
p=5P
q=5Q
r=5R
s=5S
t=5T
u=5U
v=5V
w=5W
x=5X
y=5Y
z=5Z
A=5E,5Z,6O,6I
B=5Q,5Y,6K,6P,6C
C=5K,5D,6B,6Y,6X,6G
D=5C,5T,6Y,6U,6G,6V
E=5H,5A,6S,6O,6N,6I
F=5P,5M,6Y,6U
G=5X,5V,6C,6D
H=5T,5E,6R,6S,6W,6N
I=5N,6E,6A
J=5L,6S,6O
K=5C,6G,6B,6K
L=5M,5J,6R,6S
M=5F,5L,6R,6S
N=5W,5I,6H,6E
O=5S,6J,6E,6A
P=5F,6B,6Y
Q=5B,6K,6C
R=5U,5S,6M,6L,6T,6H
S=5R,5O,6L,6J,6H,6E
T=5D,5H,6U,6R,6V,6W
U=5Y,5R,6F,6M,6D,6T
V=5G,5W,6D,6T
W=5V,5N,6T,6H
X=5G,6K,6C
Y=5B,5U,6P,6F,6C,6D
Z=5A
A=5a
B=5b
C=5c
D=5d
E=5e
F=5f
G=5g
H=5h
I=5i
J=5j
K=5k
L=5l
M=5m
N=5n
O=5o
P=5p
Q=5q
R=5r
S=5s
T=5t
U=5u
V=5v
W=5w
X=5x
Y=5y
Z=5z

// ********** Phonetic substitutions **********
// a, e, i, o, u
a=3e,3i,3o,5u
e=3a,3i,4o,5u
i=3a,3e,5o,5u
o=3a,4e,5i,3u
u=5a,5e,5i,3o

// ay, a, ai, ei, ey, ea
ay=5a,5ai,5ei,5ey,5ea
a=5ay,5ai,5ei,5ey,5ea
ai=5ay,5a,5ei,5ey,5ea
ei=5ay,5a,5ai,5ey,5ea
ey=5ay,5a,5ai,5ei,5ea
ea=5ay,5a,5ai,5ei,5ey

// e, ee, ea, ie, i, ei
e=5ee,5ea,5ie,5i,5ei
ee=5e,5ea,5ie,5i,5ei
ea=5e,5ee,5ie,5i,5ei
ie=5e,5ee,5ea,5i,5ei
i=5e,5ee,5ea,5ie,5ei
ei=5e,5ee,5ea,5ie,5i

// o, oa, oe, ow, ou, eau
o=5oa,5oe,5ow,5ou,5eau
oa=5o,5oe,5ow,5ou,5eau
oe=5o,5oa,5ow,5ou,5eau
ow=5o,5oa,5oe,5ou,5eau
ou=5o,5oa,5oe,5ow,5eau
eau=5o,5oa,5oe,5ow,5ou

// u, o, oo, ou
u=5o,5oo,5ou
o=5u,5oo,5ou
oo=5u,5o,5ou
ou=5u,5o,5oo

// y, i, ie, ye, ei| uy
y=5i,5ie,5ye,5ei
i=5y,5ie,5ye,5ei
ie=5y,5i,5ye,5ei
ye=5y,5i,5ie,5ei
ei=5y,5i,5ie,5ye

// a| ai

// e, ea| a, ai
e=5ea
ea=5e

// i, y
i=5y
y=5i

// u, o, ou| oo, oe
u=5o,5ou
o=5u,5ou
ou=5u,5o

// air, are, ear, aer, ere, eir, ay
air=5are,5ear,5aer,5ere,5eir,5ay
are=5air,5ear,5aer,5ere,5eir,5ay
ear=5air,5are,5aer,5ere,5eir,5ay
aer=5air,5are,5ear,5ere,5eir,5ay
ere=5air,5are,5ear,5aer,5eir,5ay
eir=5air,5are,5ear,5aer,5ere,5ay
ay=5air,5are,5ear,5aer,5ere,5eir

// oo, u, o, ou, oe
5oo=5u,5o,5ou,5oe
5u=5oo,5o,5ou,5oe
5o=5oo,5u,5ou,5oe
5ou=5oo,5u,5o,5oe
5oe=5oo,5u,5o,5ou

// y, i, ea, ee
y=5i,5ea,5ee
i=5y,5ea,5ee
ea=5y,5i,5ee
ee=5y,5i,5ea

// er, ir, ur, yr, ear, our, or
er=5ir,5ur,5yr,5ear,5our,5or
ir=5er,5ur,5yr,5ear,5our,5or
ur=5er,5ir,5yr,5ear,5our,5or
yr=5er,5ir,5ur,5ear,5our,5or
ear=5er,5ir,5ur,5yr,5our,5or
our=5er,5ir,5ur,5yr,5ear,5or
or=5er,5ir,5ur,5yr,5ear,5our

// aw, au, or, ore| oo, oa, ough, a, ou
aw=5au,5or,5ore
au=5aw,5or,5ore
or=5aw,5au,5ore
ore=5aw,5au,5or

// o, ou, a, au
o=5ou,5a,5au
ou=5o,5a,5au
a=5o,5ou,5au
au=5o,5ou,5a

// ar, al, a| au, er, ear
ar=5al,5a,6au,6er,6ear
al=5ar,5a,6au,6er,6ear
a=5ar,5al,6au,6er,6ear
au=6ar,6al,6a,6er,6ear
er=6ar,6al,6a,6au,6ear
ear=6ar,6al,6a,6au,6er

// ow, ou
ow=5ou
ou=5ow

// ear, eer, ea, eir, ere, ier
ear=5eer,5ea,5eir,5ere,5ier
eer=5ear,5ea,5eir,5ere,5ier
ea=5ear,5eer,5eir,5ere,5ier
eir=5ear,5eer,5ea,5ere,5ier
ere=5ear,5eer,5ea,5eir,5ier
ier=5ear,5eer,5ea,5eir,5ere

// oy, oi
oy=5oi
oi=5oy

// oor, ure, ur, ou
oor=5ure,5ur,5ou
ure=5oor,5ur,5ou
ur=5oor,5ure,5ou
ou=5oor,5ure,5ur

// b, bb
b=4bb
bb=4b

// d, dd, ed
d=4dd,4ed
dd=4d,4ed
ed=4d,4dd

// p, pp| gh
p=4pp
pp=4p

// t, tt, th
t=4tt,4th
tt=4t,4th
th=4t,4tt

// c, cc, ck, k, ch, qu
c=4cc,4ck,4k,4ch,4que
cc=4c,4ck,4k,4ch,4que
ck=4c,4cc,4k,4ch,4que
k=4c,4cc,4ck,4ch,4que
ch=4c,4cc,4ck,4k,4que
que=4c,4cc,4ck,4k,4ch

// l, ll
l=4ll
ll=4l

// m, mm
m=4mm
mm=4m

// f, ff, ph, gh
f=4ff,4ph,4gh
ff=4f,4ph,4gh
ph=4f,4ff,4gh
gh=4f,4ff,4ph

// h, wh
h=4wh
wh=4h

// n, nn, kn, en
n=4nn,4kn,4en
nn=4n,4kn,4en
kn=4n,4nn,4en
en=4n,4nn,4kn

// r, rr, wr
r=4rr,4wr
rr=4r,4wr
wr=4r,4rr

// s, ss, c, sc
s=4ss,4c,4sc
ss=4s,4c,4sc
c=4s,4ss,4sc
sc=4s,4ss,4c

// w, u
w=4u
u=4w

// v| f, ph

// z, s, zz| ss tz
z=4s,4zz,4ss,4tz,4x
s=4z,4zz,4ss,4tz,4x
zz=4z,4s,4ss,4tz,4x
ss=4z,4s,4zz,4tz,4x
tz=4z,4s,4zz,4ss,4x
x=4z,4s,4zz,4ss,4tz

// g, gg, gu, gh
g=4gg,4gu,4gh
gg=4g,4gu,4gh
gu=4g,4gg,4gh
gh=4g,4gg,4gu

// ch, tch, t
ch=4tch,4t
tch=4ch,4t
t=4ch,4tch

// ch

// j, g, dg
j=4g,4dg
g=4j,4dg
dg=4j,4g

// ng, n
ng=4n
n=4ng

// th

// th

// y

// s, z, ge
s=4z,4ge
z=4s,4ge
ge=4s,4z

// sh, s, ss, ci, sci, ce, si, ti, ch, t
sh=4s,4ss,4ci,4sci,4ce,4si,4ti,4ch,4t
s=4sh,4ss,4ci,4sci,4ce,4si,4ti,4ch,4t
ss=4sh,4s,4ci,4sci,4ce,4si,4ti,4ch,4t
ci=4sh,4s,4ss,4sci,4ce,4si,4ti,4ch,4t
sci=4sh,4s,4ss,4ci,4ce,4si,4ti,4ch,4t
ce=4sh,4s,4ss,4ci,4sci,4si,4ti,4ch,4t
si=4sh,4s,4ss,4ci,4sci,4ce,4ti,4ch,4t
ti=4sh,4s,4ss,4ci,4sci,4ce,4si,4ch,4t
ch=4sh,4s,4ss,4ci,4sci,4ce,4si,4ti,4t
t=4sh,4s,4ss,4ci,4sci,4ce,4si,4ti,4ch

// Between phonemes
// b, bb <-> p, pp
b=5p,5pp
bb=5p,5pp
p=5b,5bb
pp=5b,5bb

// d, dd <-> t, tt, th
d=5t,5tt,5th
dd=5t,5tt,5th
t=5d,5dd
tt=5d,5dd
th=5d,5dd

// c, cc, ck, k, ch, qu
// g, gg, gu, gh
// k <-> g
c=5g,5gg,5gu,5gh
cc=5g,5gg,5gu,5gh
ck=5g,5gg,5gu,5gh
k=5g,5gg,5gu,5gh
ch=5g,5gg,5gu,5gh
qu=5g,5gg,5gu,5gh
g=5c,5cc,5ck,5k,5ch,5qu
gg=5c,5cc,5ck,5k,5ch,5qu
gu=5c,5cc,5ck,5k,5ch,5qu
gh=5c,5cc,5ck,5k,5ch,5qu

// v|, f, ph
// f, ff, ph, gh
// f <-> v
v=5f,5ff,5ph,5gh
f=5v
ff=5v
ph=5v
gh=5v


// ********** Advanced phonetic substitutions **********
// mute h
.=3h
h=4.

// mute e
.=3e
@=2e
e=3.
e@=2.

// additional vowels
a=4.

.=3a
.=3o

// [k][s] - x
x=5ks,5kz
ks=5x,5kz
kz=5x,5ks

// [g][z] - x
x=5gz,5gs
gz=5x,5gs
gs=5x,5gz


// ********** Double lettes **********
b=2bb
bb=2b
c=2cc
cc=2c
d=2dd
dd=2d
f=2ff
ff=2f
g=2gg
gg=2g
l=2ll
ll=2l
m=2mm
mm=2m
n=2nn
nn=2n
p=2pp
pp=2p
r=2rr
rr=2r
s=2ss
ss=2s
t=2tt
tt=2t
zz=2z
z=2zz


e=2ee
ee=2e
o=2oo
oo=2o


// ********** Nagative prefixes **********
// un, in, im, il, ir
#un=5in,5im,5il,5ir
#in=5un,5im,5il,5ir
#im=5un,5in,5il,5ir
#il=5un,5in,5im,5ir
#ir=5un,5in,5im,5il

// mis, mal
#mis=5mal
#mal=5mis

// a, an
#a=5an
#an=5a

// de, dis
#de=5dis
#dis=5de

// ********** Special prefixes **********
// macro, mega
#macro=5mega
#mega=5macro

// com, con, col
#com=5con,5col
#con=5com,5col
#col=5com,5con

// en, em, in
#en=5em,5in
#em=5en,5in
#in=5en,5em

// poly, multi
#poly=5multi
#multi=5poly


// ********** Nationalities suffixes **********
// an, e, er, i, ian, ese, ean
an@=5e,5er,5i,5ian,5ese,5ean
e@=5an,5er,5i,5ian,5ese,5ean
er@=5an,5e,5i,5ian,5ese,5ean
i@=5an,5e,5er,5ian,5ese,5ean
ian@=5an,5e,5er,5i,5ese,5ean
ese@=5an,5e,5er,5i,5ian,5ean
ean@=5an,5e,5er,5i,5ian,5ese


// ********** Verb suffixes **********
// ize, ise, ate, ify, en
ize@=5ate,5ify,5en
ise@=5ate,5ify,5en
ate@=5ize,5ise,5ify,5en
ify@=5ize,5ise,5ate,5en
en@=5ize,5ise,5ate,5ify

// t, ed
t@=4ed
ed@=4t


// ********** Noun suffixes **********
er@=5or,5ist,5ian
or@=5er,5ist,5ian
ist@=5er,5or,5ian
ian@=5er,5or,5ist

// tion, ation
tion@=5ation
ation@=5tion

// ness, ism, dom, ship
ness@=5dom,5ship
dom@=5ness,5ship
ship@=5ness,5dom

ion@=5ment
ment@=5ion
ion@=5ness
ness@=5ion
ism@=5ity
ity@=5ism

our@=5or
or@=5our

// ist, alist, yist
ist@=5alist
alist@=5ist

// ty, ness
ty@=5ness
ness@=5ty

// wise, ways, way
wise@=5ways,5way,5ward,5wards
ways@=5wise,5way,5ward,5wards
way@=5wise,5ways,5ward,5wards
ward@=5wise,5ways,5way,5wards
wards@=5wise,5ways,5way,5ward


// ********** Adjective suffixes **********
// al, ar, ic, ical, ed, ive
al@=5ar,5ic,5ical,5ed,5ive
ar@=5al,5ic,5ical,5ed,5ive
ic@=5al,5ar,5ical,5ed,5ive
ical@=5al,5ar,5ic,5ed,5ive
ed@=5al,5ar,5ic,5ical,5ive
ive@=5al,5ar,5ic,5ical,5ed


// ********** Adjective / adverb suffixes **********
// al@, ly@, ally@
al@=6ly,6ally
ly@=6al,6ally
ally@=6al,6ly

// ********** Other **********
nt@=5n't
s@=5's
