/*
ͻ
 What's it called: EPMTeX V1.3a                                             
                                                                            
 What does it do:  The E source code for the EPMTeX enhancements V1.3a      
                   for EPM.                                                                                                                             
                                                                            
 Who and When:     Jon Hacker 1/93 - 5/93                                   
                   Joachim Koenen 2/93     (syntax assist)                  
                   Thorsten Domsalla 2/93  (menus, batch files)             
                                                                            
ͼ
*/

/*
Ŀ
  Include the user edited environment file (texenv.e) that describes the       
  location of required TeX programs and files.                                 

*/

include 'texenv.e'

/*
Ŀ
  Start of EPMTeX fixed code                                                   

*/
-- startup default conditions

compile if not defined(TEX_SYNTAX_ASSIST)
const   TEX_SYNTAX_ASSIST = 1                --  default is to not include TeX syntax expansion 
compile endif

compile if not defined(TEX_MENU_ALWAYS_ON)
const   TEX_MENU_ALWAYS_ON = 0                --  default is to grey out TeX menu for non-teX files
compile endif

compile if not defined(TEX_MARGINS)
const   TEX_MARGINS = '1 80 1'               --  default margins for TeX syntax assist
compile endif

compile if not defined(TEX_TABS)
const   TEX_TABS = 8                         --  default tabs for TeX syntax assist
compile endif

compile if not defined(TEX_WANT_ACCELERATOR_KEYS)
const   TEX_WANT_ACCELERATOR_KEYS  = 0        -- default is not to add TeX keyboard accelerators
compile endif                                 -- if TeX syntax assist is enabled.

compile if not defined(TEX_LATEX_MODE)
const   TEX_LATEX_MODE = 0                    -- default is to turn off latex mode at startup
compile endif                                  

compile if not defined(TEX_USER_MODE)
const   TEX_USER_MODE = 0                    -- default is to turn off user mode at startup
compile endif                                  

compile if not defined(TEX_LANDSCAPE_MODE)
const   TEX_LANDSCAPE_MODE = 0                -- default is portrait mode at startup
compile endif

compile if not defined(TEX_AUTO_DELETE_LOG)
const   TEX_AUTO_DELETE_LOG = 1               -- default is to turn on log file auto-delete
compile endif                                 -- at startup

compile if not defined(TEX_AUTO_SAVE_DOC)
const   TEX_AUTO_SAVE_DOC = 1                 -- default is to turn on smart save before TeX
compile endif                                 -- at startup

compile if not defined(TEX_DEBUG_MODE)
const   TEX_DEBUG_MODE = 0                  -- default is to turn off verbose mode for debugging TeX
compile endif                               -- at startup


/*
Ŀ
   English language support for TeX menu help                                  

*/

const
TEX_BARP__MSG = \1'Menus related to TeX support'
TEX_TEXP__MSG = \1'TeX the current file'
TEX_VIEWP__MSG = \1'Preview the current associated DVI file'
TEX_PRP__MSG = \1'Print the current associated DVI output file'
TEX_LLOGP__MSG = \1'View the current associated LOG file'
TEX_DLOGP__MSG = \1'Delete the current associated LOG file'
TEX_DDVIP__MSG = \1'Delete the current associated DVI file'
TEX_LATEXP__MSG = \1'LaTeX mode'
TEX_USERP__MSG = \1'User defined mode'
TEX_LANDSCAPEP__MSG = \1'Preview and print in landscape orientation'
TEX_ADLOGP__MSG = \1'Automatic delete of the associated LOG file after View or Print'
TEX_ASAVEP__MSG = \1'Automatic smart save of TeX file before TeXing document.'
TEX_SYNTAXP__MSG = \1'Global syntax expansion mode (expand_on)'
TEX_DEBUGP__MSG = \1'Verbose mode for troubleshooting TeX commands.'




/*
Ŀ
  Define EPMTeX variables and post menu build                                  

*/
definit
    universal tex_latex
    universal tex_user
    universal tex_landscape
    universal tex_auto_log
    universal tex_auto_save
    universal tex_syntax
    universal tex_debug

    tex_latex=TEX_LATEX_MODE
    tex_user=TEX_USER_MODE
    tex_landscape=TEX_LANDSCAPE_MODE
    tex_auto_log=TEX_AUTO_DELETE_LOG
    tex_auto_save=TEX_AUTO_SAVE_DOC
    tex_syntax=TEX_SYNTAX_ASSIST
    tex_debug=TEX_DEBUG_MODE

    'PostMe BuildTexMenu'    -- delay creating menu until after the definit


/*
Ŀ
  TeX menu registering                                                         

*/
-- check for TeX file on load and ring select
defselect
   'PostMe TexMenuEnable'

-- check for TeX file on rename
defload
   'PostMe TexMenuEnable'


/*
Ŀ
  Tex Syntax Assist                                                            

*/

--    Only include syntax assist if ALTERNATE_KEYSETS flag is on
compile if ALTERNATE_KEYSETS
    compile if TEX_SYNTAX_ASSIST
        include 'texkeys.e'
    compile endif
compile endif



/*
Ŀ
  Define TeX menu system                                                       

*/
defc BuildTexMenu =
    universal defaultmenu

    buildsubmenu defaultmenu, 9, '~TeX', TEX_BARP__MSG, 0,0
    buildmenuitem defaultmenu, 9, 901, '~TeX Document',   'tex'TEX_TEXP__MSG, 0,0
    buildmenuitem defaultmenu, 9, 902, \0, '', 4, 0
    buildmenuitem defaultmenu, 9, 903, 'Pre~View Document','texvw'TEX_VIEWP__MSG,  0,0
    buildmenuitem defaultmenu, 9, 904, '~Print Document', 'texpr'TEX_PRP__MSG,  0,0
    buildmenuitem defaultmenu, 9, 905, 'View LOG ~File', 'texvwlog'TEX_LLOGP__MSG,  0,0
    buildmenuitem defaultmenu, 9, 906, \0, '', 4, 0
    buildmenuitem defaultmenu, 9, 907, 'Delete LO~G File','tex_del_log'TEX_DLOGP__MSG, 0,0
    buildmenuitem defaultmenu, 9, 908, 'Delete ~DVI File','tex_del_dvi'TEX_DDVIP__MSG, 0,0
    buildmenuitem defaultmenu, 9, 909, \0, '', 4, 0
    buildmenuitem defaultmenu, 9, 910, '~LaTeX Mode','toggle_latex'TEX_LATEXP__MSG, 0,0
    compile if TEX_USER_MENU_TEXT <> ''
        buildmenuitem defaultmenu, 9, 911, TEX_USER_MENU_TEXT,'toggle_user'TEX_USERP__MSG, 0,0
    compile endif
    buildmenuitem defaultmenu, 9, 912, 'La~ndscape Mode','toggle_landscape'TEX_LANDSCAPEP__MSG, 0,0
    buildmenuitem defaultmenu, 9, 913, '~Auto LOG Delete','toggle_auto_log'TEX_ADLOGP__MSG, 0,0
    buildmenuitem defaultmenu, 9, 914, 'Auto ~Save','toggle_auto_save'TEX_ASAVEP__MSG, 0,0
    compile if TEX_SYNTAX_ASSIST
        buildmenuitem defaultmenu, 9, 915, 'Synta~x Expansion','toggle_tex_expand'TEX_SYNTAXP__MSG, 0,0
    compile endif
    buildmenuitem defaultmenu, 9, 916, 'De~bug mode','toggle_debug'TEX_DEBUGP__MSG, 0,0

    showmenu defaultmenu
    'PostMe  TexMenuEnable'

--------------------------------------------------------------------------------------
-- enable the TeX menu only if TeX file loaded - disable if TEX_MENU_ALWAYS_ON is set

defc TexMenuEnable =
    compile if TEX_MENU_ALWAYS_ON = 1
       enabled = 1
    compile else
       ext = filetype()
       compile if defined(MY_TEX_FILE_TYPE)
          enabled = leftstr(ext,3)='TEX' or ext='LOG' or ext='STY' or ext='BBL' or ext=MY_TEX_FILE_TYPE
       compile else
          enabled = leftstr(ext,3)='TEX' or ext='LOG' or ext='STY' or ext='BBL'
       compile endif
    compile endif
    SetMenuAttribute(9, 16384, enabled)


/*
Ŀ
  Command definitions                                                          

*/
-- Create a OS/2 window & execute TeX in it.
defc tex =
    universal tex_latex, tex_user, tex_auto_save, tex_debug
    if .modify then               -- Modified since last Save?
       if tex_auto_save then      --  Want auto smart save feature?
           'Save'                 --   Yes - save it before TeXing document
            sayerror 'Saving modified document before calling TeX!'
       else                       --   No - warn user!
            sayerror 'TeXing stale document file... auto_save disabled!'
       endif
    endif
    n=lastpos('\',.filename)+1
    pathname=delstr(.filename,n-1)
    unixfilename = translate(.filename, '/', '\')
    call directory(pathname)
    
    compile if TEX_USER_MENU_TEXT = ''
        if not tex_latex then
            command=TEX_EXEC ' ' unixfilename
            isCMD = TEX_IS_CMD
        else 
            command=LATEX_EXEC ' ' unixfilename
            isCMD = LATEX_IS_CMD
        endif
    compile else
        if not tex_latex and not tex_user then
            command=TEX_EXEC ' ' unixfilename
            isCMD = TEX_IS_CMD
        else if tex_latex and not tex_user then
            command=LATEX_EXEC ' ' unixfilename
            isCMD = LATEX_IS_CMD
             else if not tex_latex and tex_user then
                    command=TEX_USER_EXEC ' ' unixfilename
                    isCMD = TEX_USER_IS_CMD
                  else if tex_latex and tex_user then
                      command=LATEX_USER_EXEC ' ' unixfilename
                      isCMD = LATEX_USER_IS_CMD
                       endif
                  endif
             endif
        endif
    compile endif

    if tex_debug then
        sayerror command
    endif

    if isCMD then                -- command is a batch file, use command processor
        'start /c /win 'command
    else
        'start /n /win 'command
    endif
    if rc <> 0 then
        sayerror"Caution! Could not start TeX. Exited with return code = "rc
    endif
-------------------------------------------------------------------------------
-- View current TeX file in previewer. 
defc texvw =
    universal tex_landscape, tex_auto_log, tex_debug
    n=lastpos('\',.filename)+1;
    filename=substr(.filename,n);
    pathname=delstr(.filename,n-1);
    n=lastpos('.',filename)+1;
    stem=delstr(filename,n-1);

    if  tex_auto_log and exist(pathname'\'stem'.log') then
        call tex_delete_log_file()
    endif

    if tex_landscape then
        command= TEX_VIEWLA_EXEC' 'pathname'\'stem'.dvi'
        isCMD = TEX_VIEWLA_IS_CMD
    else
        command= TEX_VIEW_EXEC' 'pathname'\'stem'.dvi'
        isCMD = TEX_VIEW_IS_CMD
    endif

    if tex_debug then
        sayerror command
    endif
----------
-- NOTE: add /fs or /win if previewer is not a PM app

    if isCMD then                -- command is a batch file, use command processor
        'start /c 'command
    else
        'start /n 'command
    endif
----------
    if rc <> 0 then
        sayerror"Caution! Could not start Previewer. Exited with return code = "rc
    endif


-------------------------------------------------------------------------------
-- Create a OS/2 window & execute TeX printer driver.
defc texpr =
    universal tex_landscape, tex_auto_log, tex_debug

    n=lastpos('\',.filename)+1;
    filename=substr(.filename,n);
    pathname=delstr(.filename,n-1);
    n=lastpos('.',filename)+1;
    stem=delstr(filename,n-1);

    if  tex_auto_log and exist(pathname'\'stem'.log') then
        call tex_delete_log_file()
    endif

    if tex_landscape then
        command= TEX_PRINTLA_EXEC' 'pathname'\'stem'.dvi'
        isCMD = TEX_PRINTLA_IS_CMD
    else
        command= TEX_PRINT_EXEC' 'pathname'\'stem'.dvi'
        isCMD = TEX_PRINT_IS_CMD
    endif

    if tex_debug then
        sayerror command
    endif

    if isCMD then                -- command is a batch file, use command processor
        'start /c /win 'command
    else
        'start /n /win 'command
    endif
    if rc <> 0 then
        sayerror"Caution! Could not start Printer driver. Exited with return code = "rc
    endif



-------------------------------------------------------------------------------
-- Load LOG file for current TeX file if it exists.
defc texvwlog =
    n=lastpos('\',.filename)+1;
    filename=substr(.filename,n);
    pathname=delstr(.filename,n-1);
    n=lastpos('.',filename)+1;
    stem=delstr(filename,n-1);

    if  exist(pathname'\'stem'.log') then
        logfile = pathname'\'stem'.log'
        'edit /d' logfile
    else
        sayerror'LOG file 'logfile' does not exist'
    endif

-------------------------------------------------------------------------------
-- Delete current TeX LOG file.
defc tex_del_log = call tex_delete_log_file()

-------------------------------------------------------------------------------
-- Delete current TeX DVI file.
defc tex_del_dvi = call tex_delete_dvi_file()

-------------------------------------------------------------------------------
-- Toggle LaTeX mode flag.
defc toggle_latex =
    universal tex_latex
    universal tex_debug
    tex_latex = not tex_latex
    if tex_debug then
        sayerror 'tex_latex = 'tex_latex
    endif

-------------------------------------------------------------------------------
-- Toggle user mode flag.
compile if TEX_USER_MENU_TEXT <> ''
    defc toggle_user =
    universal tex_user, tex_debug
    tex_user = not tex_user
    if tex_debug then
        sayerror 'tex_user = 'tex_user
    endif
compile endif

-------------------------------------------------------------------------------
-- Toggle Landscape mode flag.
defc toggle_landscape =
    universal tex_landscape
    universal tex_debug
    tex_landscape = not tex_landscape
    if tex_debug then
        sayerror 'tex_landscape = 'tex_landscape
    endif


-------------------------------------------------------------------------------
-- Toggle Auto-Delete current TeX LOG file after View or Print flag.
defc toggle_auto_log =
    universal tex_auto_log
    universal tex_debug
    tex_auto_log = not tex_auto_log
    if tex_debug then
        sayerror 'tex_auto_log = 'tex_auto_log
    endif


-------------------------------------------------------------------------------
-- Toggle Auto smart-save current TeX file before TeXing document .
defc toggle_auto_save =
    universal tex_auto_save
    universal tex_debug
    tex_auto_save = not tex_auto_save
    if tex_debug then
        sayerror 'tex_auto_save = 'tex_auto_save
    endif

-------------------------------------------------------------------------------
-- Toggle EPM syntax expansion flag.
compile if TEX_SYNTAX_ASSIST 
    defc toggle_tex_expand =
    universal expand_on, tex_debug
    if expand_on then    
        'expand 'OFF__MSG
    else
        'expand 'ON__MSG
    endif
    if tex_debug then
        sayerror 'expand_on = 'expand_on
    endif
compile endif

-------------------------------------------------------------------------------
-- Toggle debug mode for troubleshooting TeX commands.
defc toggle_debug =
    universal tex_debug
    tex_debug = not tex_debug
    if tex_debug then
        sayerror 'tex_debug = 'tex_debug
    endif

/*
Ŀ
  Procedure definitions                                                        

*/

-- Delete current TeX LOG file.
defproc tex_delete_log_file
    n=lastpos('\',.filename)+1;
    filename=substr(.filename,n);
    pathname=delstr(.filename,n-1);
    n=lastpos('.',filename)+1;
    stem=delstr(filename,n-1);
    rc = erasetemp(pathname'\'stem'.log')
    if rc = 0 then
       sayerror 'File 'stem'.LOG deleted'
    elseif rc = 2 then
        sayerror 'Delete LOG: file 'stem'.LOG could not be found'
    else
        sayerror 'Delete LOG: file 'stem'.LOG could not be deleted'
        beep(1000, 100)
    endif


-------------------------------------------------------------------------------
-- Delete current TeX DVI file.
defproc tex_delete_dvi_file
    n=lastpos('\',.filename)+1;
    filename=substr(.filename,n);
    pathname=delstr(.filename,n-1);
    n=lastpos('.',filename)+1;
    stem=delstr(filename,n-1);
    rc = erasetemp(pathname'\'stem'.dvi')
    if rc = 0 then
       sayerror 'File 'stem'.DVI deleted'
    elseif rc = 2 then
        sayerror 'Delete DVI: file 'stem'.DVI could not be found'
    else
        sayerror 'Delete DVI: file 'stem'.DVI could not be deleted'
        beep(1000, 100)
    endif


-------------------------------------------------------------------------------
-- called in mymnuini.e to get state of global TeX variable tex_latex

defproc get_tex_latex =
    universal tex_latex
    return tex_latex

-------------------------------------------------------------------------------
-- called in mymnuini.e to get info on user menu options
--  arg = 0 -> query tex_user_defined flag
--        1 -> query tex_user flag

defproc get_tex_user =
    compile if TEX_USER_MENU_TEXT = ''
        return 0             -- respond with user menu option undefined
    compile else
        universal tex_user
        if arg(1) = 0 then   -- respond with user menu option defined
            return 1
        else
            return tex_user  -- query tex_user flag
        endif
    compile endif

-------------------------------------------------------------------------------
-- called in mymnuini.e to get state of global TeX variable tex_landscape

defproc get_tex_landscape =
    universal tex_landscape
    return tex_landscape

-------------------------------------------------------------------------------
-- called in mymnuini.e to get state of global TeX variable tex_auto_log

defproc get_tex_auto_log =
    universal tex_auto_log
    return tex_auto_log

-------------------------------------------------------------------------------
-- called in mymnuini.e to get state of global TeX variable tex_auto_save

defproc get_tex_auto_save =
    universal tex_auto_save
    return tex_auto_save

-------------------------------------------------------------------------------
-- called in mymnuini.e to get info on syntax menu options
--  arg = 0 -> query tex_syntax flag
--        1 -> query  expand_on flag

defproc get_tex_syntax =
    universal tex_syntax, expand_on
    if arg(1) = 0 then           -- query tex_syntax
        return tex_syntax
    else
        return expand_on         -- query expand_on
    endif

-------------------------------------------------------------------------------
-- called in mymnuini.e to get state of global EPM variable expand_on

defproc get_tex_expand_on =
    universal expand_on
    return expand_on

-------------------------------------------------------------------------------
-- called in mymnuini.e to get state of global TeX variable tex_debug

defproc get_tex_debug =
    universal tex_debug
    return tex_debug

-------------------------------------------------------------------------------
-- called in mymnuini.e to determine if DVI or LOG file exist
--  arg = 0 -> query DVI file
--        1 -> query LOG file

defproc tex_check_exist =
    n=lastpos('.',.filename)+1;
    FileToFind=delstr(.filename,n-1);

    if arg(1) = 'LOG' then                -- query LOG file
        return(not exist(FileToFind'.log'))  -- 1 -> file does not exist
    endif
    if  arg(1) = 'DVI' then               -- query DVI file
        return(not exist(FileToFind'.dvi'))  -- 1 -> file does not exist
    endif
-------------------------------------------------------------------------------

