# The LaTeX package tcolorbox - version 6.0.3 (2023/03/17)


> Copyright (c) 2006-2023 by Prof. Dr. Dr. Thomas F. Sturm <thomas dot sturm at unibw dot de>

> This work may be distributed and/or modified under the
> conditions of the LaTeX Project Public License, either version 1.3
> of this license or (at your option) any later version.
> The latest version of this license is in
>   http://www.latex-project.org/lppl.txt
> and version 1.3 or later is part of all distributions of LaTeX
> version 2005/12/01 or later.

> This work has the LPPL maintenance status author-maintained.

> This work consists of all files listed in README.md


`tcolorbox` provides an environment for colored and framed text boxes with a
heading line. Optionally, such a box can be split in an upper and a lower
part. The package `tcolorbox` can be used for the setting of *LaTeX* examples where
one part of the box displays the source code and the other part shows the
output. Another common use case is the setting of theorems. The package supports
saving and reuse of source code and text parts.


## Contents of the package

- `README.md`                     this file
- `CHANGES.md`                    log of changes (history)
- `tcolorbox.sty`                 LaTeX package file (style file)
- `tcbbreakable.code.tex`         LaTeX package file (library of tcolorbox)
- `tcbdocumenation.code.tex`      LaTeX package file (library of tcolorbox)
- `tcbexternal.code.tex`          LaTeX package file (library of tcolorbox)
- `tcbfitting.code.tex`           LaTeX package file (library of tcolorbox)
- `tcbhooks.code.tex`             LaTeX package file (library of tcolorbox)
- `tcblistings.code.tex`          LaTeX package file (library of tcolorbox)
- `tcblistingscore.code.tex`      LaTeX package file (library of tcolorbox)
- `tcblistingsutf8.code.tex`      LaTeX package file (library of tcolorbox)
- `tcbmagazine.code.tex`          LaTeX package file (library of tcolorbox)
- `tcbminted.code.tex`            LaTeX package file (library of tcolorbox)
- `tcbposter.code.tex`            LaTeX package file (library of tcolorbox)
- `tcbprocessing.code.tex`        LaTeX package file (library of tcolorbox)
- `tcbraster.code.tex`            LaTeX package file (library of tcolorbox)
- `tcbskins.code.tex`             LaTeX package file (library of tcolorbox)
- `tcbskinsjigsaw.code.tex`       LaTeX package file (library of tcolorbox)
- `tcbtheorems.code.tex`          LaTeX package file (library of tcolorbox)
- `tcbvignette.code.tex`          LaTeX package file (library of tcolorbox)
- `tcbxparse.code.tex`            LaTeX package file (library of tcolorbox)
- `blueshade.png`                 Picture (package)
- `crinklepaper.png`              Picture (package)
- `goldshade.png`                 Picture (package)
- `pink_marble.png`               Picture (package)
- `tcolorbox.pdf`                 Documentation for tcolorbox
- `tcolorbox.tex`                 Source code of the documentation (main file)
- `*.doc.*`                       Source code of the documentation (include files)
- `tcolorbox-tutorial-poster.pdf` Tutorial for poster creation
- `tcolorbox-tutorial-poster.tex` Source code of the tutorial
- `tcolorbox-example.tex`         Example file for package usage
- `tcolorbox-example.pdf`         Compiled example
- `tcolorbox-example-poster.tex`  Example file for package usage
- `tcolorbox-example-poster.pdf`  Compiled example
- `Basilica_5.png`                Example picture
- `lichtspiel.jpg`                Example picture


## Installation

Copy the contents of the `tcolorbox.tds.zip` from CTAN to your local TeX file tree.

Alternatively, put the files to their respective locations within the TeX installation:

- `tcolorbox.sty`             ->  /tex/latex/tcolorbox
- `tcbbreakable.code.tex`     ->  /tex/latex/tcolorbox
- `tcbdocumentation.code.tex` ->  /tex/latex/tcolorbox
- `tcbexternal.code.tex`      ->  /tex/latex/tcolorbox
- `tcbfitting.code.tex`       ->  /tex/latex/tcolorbox
- `tcbhooks.code.tex`         ->  /tex/latex/tcolorbox
- `tcblistings.code.tex`      ->  /tex/latex/tcolorbox
- `tcblistingscore.code.tex`  ->  /tex/latex/tcolorbox
- `tcblistingsutf8.code.tex`  ->  /tex/latex/tcolorbox
- `tcbmagazine.code.tex`      ->  /tex/latex/tcolorbox
- `tcbminted.code.tex`        ->  /tex/latex/tcolorbox
- `tcbposter.code.tex`        ->  /tex/latex/tcolorbox
- `tcbprocessing.code.tex`    ->  /tex/latex/tcolorbox
- `tcbraster.code.tex`        ->  /tex/latex/tcolorbox
- `tcbskins.code.tex`         ->  /tex/latex/tcolorbox
- `tcbskinsjigsaw.code.tex`   ->  /tex/latex/tcolorbox
- `tcbtheorems.code.tex`      ->  /tex/latex/tcolorbox
- `tcbvignette.code.tex`      ->  /tex/latex/tcolorbox
- `tcbxparse.code.tex`        ->  /tex/latex/tcolorbox
- `blueshade.png`             ->  /tex/latex/tcolorbox
- `crinklepaper.png`          ->  /tex/latex/tcolorbox
- `goldshade.png`             ->  /tex/latex/tcolorbox
- `pink_marble.png`           ->  /tex/latex/tcolorbox
- all other files             ->  /doc/latex/tcolorbox
