# 1. Short Description

The `nameauth` package automates the correct formatting and indexing of names for professional writing. This aids the use of a name authority and the editing process without needing to retype name references.

# 2. Files in Zip Archive

The following files are included in the archive that is uploaded to CTAN:

| Filename       | Description                |
| :------------- | :------------------------- |
| `Makefile`     | for use with GNU make      |
| `cat01.pdf`    | manual illustration, ch. 7 |
| `beamer01.pdf` | manual illustration, ch. 9 |
| `beamer02.pdf` | manual illustration, ch. 9 |
| `beamer03.pdf` | manual illustration, ch. 9 |
| `nameauth.dtx` | commented macro file       |
| `compat.tex`   | compatibility module       |
| `examples.tex` | example file               |
| `nameauth.pdf` | package documentation      |
| `README.md`    | this file                  |

# 3. Installing a Distro Package

One can find `nameauth` in one's current TeX distribution. See the appropriate documentation in TeXlive, MikTeX, MacTeX, Linux distro, BSD, etc. Use those tools to ensure that `nameauth` is installed. You are done.

# 4. Installing from CTAN

## 4.1 Getting the Package Archive

If not using the tools above, one can download `nameauth.zip` from [CTAN](https://mirrors.ctan.org/macros/latex/contrib/nameauth.zip). After downloading, unpack `nameauth.zip` in an appropriate directory. Change to the directory containing the supplied files.

## 4.2 Using GNU make

### 4.2.1 Read the File

**Please inspect the included `Makefile` before using it.**

`Makefile` has an extensive comment on usage, as well as many other comments. This file lists all the programs that must be installed in order to use GNU make file, helping one to check for prerequisites and dependencies. This method is designed for a POSIX-compliant environment, such as GNU/Linux, various BSDs, MacOS, and WSL or Cygwin on Windows.

### 4.2.2 Prepare to Install, No Building

One does not need to build `nameauth` completely from source (although it may be a good idea to do a native build). If the provided files are sufficient, one can type:

    make unpack

This target only unpack the supplied generated files from `nameauth.dtx`. It does not try to create the documentation. One will have the following files now:

| Filename       | Description                | TDS-where to |
| :------------- | :------------------------- | :----------- |
| `Makefile`     | for use with GNU make      | source dir   |
| `cat01.pdf`    | manual illustration, ch. 7 | source dir   |
| `beamer01.pdf` | manual illustration, ch. 9 | source dir   |
| `beamer02.pdf` | manual illustration, ch. 9 | source dir   |
| `beamer03.pdf` | manual illustration, ch. 9 | source dir   |
| `nameauth.dtx` | commented macro file       | source dir   |
|                |                            |              |
| `nameauth.ins` | installation driver        | unneeded     |
|                |                            |              |
| `compat.tex`   | compatibility module       | doc dir      |
| `examples.tex` | example file               | doc dir      |
| `nameauth.pdf` | package documentation      | doc dir      |
| `README.md`    | this file                  | doc dir      |
|                |                            |              |
| `nameauth.sty` | style file                 | package dir  |

Take a look at **4.2.3 Specific Build Cases** and, depending on the use case, skip either to **4.2.5 Installation** (using make) or **4.3.3 Installation Prerequisites** (manual) below.

### 4.2.3 Specific Build Cases: Program Extensions

Windows presents some interesting cases. Both Cygwin and WSL provide POSIX environments that include respective TeX distros of their own. Yet they also will operate with native Windows-based TeX distros like MiokTeX and TeXlive.

When using the TeX distros built in to Cygwin and WSL exclusively, one can treat it basically as a POSIX-compliant environment.

Even when using Cygwin and a Windows-based TeX distro, one can treat package building as being mostly the same as a POSIX environment if all the preqequisite programs are installed. Installation, however, must be manual.

When one uses WSL with a Windows-based TeX distro, the `Makefile` will test whether an ".exe" extension is needed by the programs used in the building process.

With both Cygwin and WSL, tests will determine if the standard POSIX method is capable of installing and packaging as intended, or if manual methods are needed.

* Make will test if `ltxfileinfo` exists. If not, it will produce a zip file with just the package base name to avoid problems that otherwise could arise in Windows.

* Make will test if `dvipdf` from Ghostscript is installed and use that. Otherwise it will fall back to `dvipdfmx`.

* Make will test if `pdfjam` is installed, if one needs to remake the manual illustrations. Otherwise, it will advise on how to do that manually.

* Make will try to see if the path to the desired install directory exists. If it does not, make will produce an error message and exit. If this happens, which is likely under Windows, please refer to installation of local packages in MikTeX [here](https://docs.miktex.org/manual/localadditions.html#id573803) and [here](https://miktex.org/kb/texmf-roots). Otherwise see the [TeX FAQ](https://www.texfaq.org/FAQ-privinst) and [this page](https://en.wikibooks.org/wiki/LaTeX/Installing_Extra_Packages).

Here is a table showing the feasibility of a few scenarios:

| Platform | TeX Distro Platform       | Build package and zip with make | Install package with make       |
| :------- | :------------------------ | :------------------------------ | :------------------------------ |
| POSIX    | POSIX                     | Yes<sup>1</sup>                 | Yes                             |
| Cygwin   | Cygwin (distro packages)  | Not tested; likely<sup>1</sup>  | Not tested; likely <sup>2</sup> |
| Cygwin   | MikTeX (Windows)          | Yes<sup>1, 3</sup>              | No;<sup>4</sup> do manually     |
| Cygwin   | TeXlive (Windows)         | Not tested; likely<sup>1</sup>  | Not tested; do manually         |
| Cygwin   | Both Cygwin and Windows   | Not tested; not recommended     | Not tested; not recommended     |
| WSL      | WSL Linux distro packages | Yes<sup>1</sup>                 | Yes<sup>5</sup>                 |
| WSL      | MikTeX (Windows)          | Yes<sup>1, 3</sup>              | No;<sup>4</sup> do manually     |
| WSL      | TeXlive (Windows)         | Not tested; likely<sup>1</sup>  | Not tested; do manually         |
| WSL      | Both WSL and Windows      | Not tested; not recommended     | Not tested; not recommended     |
| WSL/Cyg  | Both WSL and Cygwin       | Not tested; not recommended     | Not tested; not recommended     |
| GNUWin   | any (Windows)             | Not tested; not recommended     | Not tested; not recommended     |

<sup>1</sup> All dependencies must be met. Bear in mind MacOS quirks.

<sup>2</sup> Installs only to Cygwin environment; not to Windows environment.

<sup>3</sup> If one attempts the `make images` target, it is unlikely that `pdfjam` will work; one must create pdf page examples included in the manual by compiling the appropriate test files and extracting the pages using a different app.

<sup>4</sup> Neither `ltxfileinfo` nor `kpsewhich` will give useful results; do a manual install.

<sup>5</sup> Installs only to WSL Linux distro environment; not to Windows environment.

### 4.2.4 Building the Package

In the directory where the files unpacked from the zip archive are located, type `make`. This will do a fresh build of the package using `pdflatex`.

### 4.2.5 Installation

The user must already have a TDS-compliant tree set up in order for installation to work. Thus, one must have created a `texmf` directory to which TEXMFHOME refers, if in a POSIX environment, or have the equivalent in another environment. Currently, `Makefile` only installs into POSIX environments.

Assuming that one has a use case where one can use GNU make, one can choose the following:

* Type `make inst` to install the package files in the user's personal TDS-compliant directory tree.

* Type `make install` to install the package files in the system-wide, local TDS-compliant directory tree. The user will be prompted for the `sudo` password.

  If, for some reason, this fails, do a manual install (below).

Note that these make targets depend on `package`, which does not do a clean build. To ensure a clean build, use `make release inst` or `make release install`.

### 4.2.6 Removal

The same constraints that apply to installation also apply to removal. If one can do the former, one can do the latter.

* Type `make uninst` to remove the package files in the user's personal TDS-compliant directory tree.

* Type `make uninstall` to remove the package files in the system-wide, local TDS-compliant directory tree. The user will be prompted for the `sudo` password.

  If, for some reason, this fails, do a manual removal (opposite of steps used below).

The approach of `Makefile` is not to get too aggressive with deletions from the texmf tree, just in case. One may see harmless, extra empty directories after removal.

## 4.3 Manual Method

Unlike when using GNU make, which automates adding extensions, in the case of working with WSL together with native Windows TeX distros, in the command lines below there may be certain cases where one may have to add the ".exe" extension to the programs. Those cases should, however, be few.

### 4.3.1 Prepare to Install, No Building

One does not need to build `nameauth` completely from source (although it may be a good idea to do a native build). If the provided files are sufficient, one can type:

    pdftex nameauth.dtx

This only unpacks the supplied generated files from `nameauth.dtx`. It does not try to create the documentation. One will have the following files now:

| Filename       | Description                | TDS-where to |
| :------------- | :------------------------- | :----------- |
| `Makefile`     | for use with GNU make      | source dir   |
| `cat01.pdf`    | manual illustration, ch. 7 | source dir   |
| `beamer01.pdf` | manual illustration, ch. 9 | source dir   |
| `beamer02.pdf` | manual illustration, ch. 9 | source dir   |
| `beamer03.pdf` | manual illustration, ch. 9 | source dir   |
| `nameauth.dtx` | commented macro file       | source dir   |
|                |                            |              |
| `nameauth.ins` | installation driver        | unneeded     |
|                |                            |              |
| `compat.tex`   | compatibility module       | doc dir      |
| `examples.tex` | example file               | doc dir      |
| `nameauth.pdf` | package documentation      | doc dir      |
| `README.md`    | this file                  | doc dir      |
|                |                            |              |
| `nameauth.sty` | style file                 | package dir  |

One may skip past building to **4.3.3 Installation Prerequisites** below.

### 4.3.2 Building the Package

1. Using the unpacked files from the zip archive, we begin by creating the installation driver, unpacking additional files from `nameauth.dtx`, and generating a copy of the documentation without the table of contents and cross-references:

       pdflatex --shell-escape --recorder --interaction=batchmode nameauth.dtx

   Now we should have the following files:

| Filename       | Description                  |
| :------------- | :--------------------------- |
| `Makefile`     | for use with GNU make        |
| `cat01.pdf`    | manual illustration, ch. 7   |
| `beamer01.pdf` | manual illustration, ch. 9   |
| `beamer02.pdf` | manual illustration, ch. 9   |
| `beamer03.pdf` | manual illustration, ch. 9   |
| `nameauth.dtx` | commented style file         |
|                |                              |
| `compat.tex`   | compatibility module         |
| `examples.tex` | example file                 |
| `nameauth.pdf` | package documentation        |
| `README.md`    | this file                    |
|                |                              |
| `nameauth.ins` | installation driver          |
| `nameauth.sty` | style file                   |

   In addition, we have the following temporary files:

| Filename       | Description                  |
| :------------- | :--------------------------- |
| `nameauth.aux` | auxiliary file               |
| `nameauth.fls` | shows files read             |
| `nameauth.glo` | raw glossary entries         |
| `nameauth.hd ` |                              |
| `nameauth.idx` | raw index entries            |
| `nameauth.log` | log file                     |
| `nameauth.out` | pdf bookmark/hypertext info  |
| `nameauth.tmp` | temp file used with fancyvrb |
| `nameauth.toc` | table of contents info       |

2. Generate the TOC and cross-references within the documentation:

       pdflatex --recorder --interaction=nonstopmode nameauth.dtx

3. Generate the index and glossary files using `makeindex`:

       makeindex -q -s gglo.ist -o nameauth.gls nameauth.glo
       makeindex -q -s gind.ist -o nameauth.ind nameauth.idx

   This adds the following files:

| Filename       | Description              |
| :------------- | :----------------------- |
| `nameauth.gls` | typeset glossary entries |
| `nameauth.ilg` | `makeindex` log file     |
| `nameauth.ind` | typeset index entries    |

4. Integrate the glossary (list of changes) and index into the documentation. The second run updates the TOC:

       pdflatex --recorder --interaction=nonstopmode nameauth.dtx
       pdflatex --recorder --interaction=nonstopmode nameauth.dtx

### 4.3.3 Installation Prerequisites

In order to perform manual installation, one should be familiar with the general information at the [TeX FAQ](https://www.texfaq.org/FAQ-installthings).

Different TeX distributions have somewhat different ways to store TDS-compliant configuration and package data. See, for example, for MikTeX [here](https://docs.miktex.org/manual/localadditions.html#id573803) and [here](https://miktex.org/kb/texmf-roots). Otherwise see the [TeX FAQ](https://www.texfaq.org/FAQ-privinst) and [this page](https://en.wikibooks.org/wiki/LaTeX/Installing_Extra_Packages).

The instructions below conform generally to a Unix-based system. There are some cases under Windows where this method may not work. For other systems, please consult the appropriate documentation as needed.

The user must already have a TDS-compliant tree set up in order for installation to work. We assume that one knows how to become superuser, create directories, move files, and the like.

### 4.3.4 User's Home Directory

`TEXMFHOME` is a variable that points to the root of a TDS-compliant directory tree available to a user. To get its value on POSIX-compliant systems, use:

    kpsewhich --var-value TEXMFHOME

Quite often, `$TEXMFHOME` is equivalent to `$HOME/texmf`. The dollar sign in front of the variable denotes the value of the variable instead of its name. If `$HOME` is `/home/bob`, then `$TEXMFHOME` would be `/home/bob/texmf`. We can understand the following paths to be under this home directory.

| Path                               | Files          |
| :--------------------------------- | :------------- |
| `$TEXMFHOME/source/latex/nameauth` | `Makefile`     |
|                                    | `cat01.pdf`    |
|                                    | `beamer01.pdf` |
|                                    | `beamer02.pdf` |
|                                    | `beamer03.pdf` |
|                                    | `nameauth.dtx` |
|                                    |                |
| `$TEXMFHOME/doc/latex/nameauth`    | `compat.tex`   |
|                                    | `examples.tex` |
|                                    | `nameauth.pdf` |
|                                    | `README.md`    |
|                                    |                |
| `$TEXMFHOME/tex/latex/nameauth`    | `nameauth.sty` |

Create the directories in the left-hand column, or whatever one needs to do in one's own case. Move or copy the files in the right-hand column to their respective directories in the left-hand column. On older TeX distributions, run `mktexlsr` on `$TEXMFHOME` to complete the install process (current distributions may not need this).

### 4.3.5 System-Wide Directory

`TEXMFLOCAL` is a variable that points to the root of a TDS-compliant directory tree available to all users on a local site, system-wide installation.To get its value, use:

    kpsewhich --var-value TEXMFLOCAL

See the [TeX FAQ](https://www.texfaq.org/FAQ-what-TDS). We can understand the following paths to be under this local site, system-wide directory:

| Path                                | Files          |
| :---------------------------------- | :------------- |
| `$TEXMFLOCAL/source/latex/nameauth` | `Makefile`     |
|                                     | `cat01.pdf`    |
|                                     | `beamer01.pdf` |
|                                     | `beamer02.pdf` |
|                                     | `beamer03.pdf` |
|                                     | `nameauth.dtx` |
|                                     |                |
| `$TEXMFLOCAL/doc/latex/nameauth`    | `compat.tex`   |
|                                     | `examples.tex` |
|                                     | `nameauth.pdf` |
|                                     | `README.md`    |
|                                     |                |
| `$TEXMFLOCAL/tex/latex/nameauth`    | `nameauth.sty` |

Create the directories in the left-hand column, or whatever one needs to do in one's own case. Move or copy the files in the right-hand column to their respective directories in the left-hand column. Change file ownership as needed (not so much on Windows). If needed, run `mktexlsr` with the appropriate permissions on `$TEXMFLOCAL` to complete the install process. See also the discussion on [this page](https://tex.stackexchange.com/questions/45231/how-to-install-system-wide-packages-without-requiring-an-ls-r-database-with-tex).

# 5. More on Package Building

* `Makefile` has been upgraded to handle more special cases and not to do unexpected or bad things in those cases, especially on Windows.

* The package and manual build on current and older TeX distributions. In a number of examples, some Unicode characters have been replaced with control sequences in order for this compatibility to work, due to how files written out and read back in affects the expansion of active Unicode characters.

* The documentation now builds only with `pdflatex`, but the examples and tests can use any LaTeX engine. This is because several typesetting decisions that are quite helpful for the manual work only with `pdflatex`.

* This release was tested on Linux (Pop! OS; vanilla TL 2022 and 2017) and Windows 10 (MikTeX with both Cygwin and WSL). The tests using TL 2017 include my published book manuscript, *Breath of God, Yet Work of Man: Scripture, Philosophy, Dialogue, and Conflict*, with Dr. Albert B. Collver III.

* The CTAN release was created with vanilla TL 2022 on Pop! OS. The most recent `equivs` file was used to meet package equivalencies. See also [this page](https://tug.org/texlive/debian.html).

* TeXlive 2022 and TL 2017 are managed on Pop! OS using [tl-switch](https://github.com/ServusCarolus/tl-switch).

* Four pdf files (`cat01.pdf` and `beamer*.pdf`) used in graphic illustrations are created from the output of test files associated with this manual (see below). Normally, the user need not generate them; they are supplied as source files.

# 6. Examples / Testing

The file `examples.tex`, which also uses `compat.tex`, usually should be enough to illustrate various non-trivial features of this package. It includes most of the longer examples in the manual, edited to fit together in a single document.

In addition to this file, a special run of `nameauth.dtx` that defines the macro `\NameauthDoTestFiles` will generate many separate test files. Normally they are written out to `nameauth.tmp` and read in again as verbatim text. They are not included in the package archive by default in order to minimize clutter.

To test `nameauth`, either test the files right after installing, or create a new testing directory. One can copy the files from the TDS-compliant source dir and optionally, the documentation directory as well, or unpack the CTAN zip file and build the package.

## 6.1 GNU make: Examples, Tests, Images

* Use the default: `make examples`.

* To create `examples.pdf` with other LaTeX engines, one can do the following:

      make examples ENGINE=xelatex
      make examples ENGINE=lualatex
      make examples ENGINE=dvilualatex
      make examples ENGINE=latex

* If one wants to change engines and re-test the file, type `make exclean`.

* To generate additional test files, type `make tests`.

  This will produce many test files numbered by chapter and example within that chapter from the `nameauth.dtx` file. It will compile all of the test files using `pdflatex`. One can add the value of ENGINE:

      make tests ENGINE=xelatex
      make tests ENGINE=lualatex
      make tests ENGINE=dvilualatex
      make tests ENGINE=latex

* If one wants to change engines and re-test the files, type `make testclean`.

* If, for some reason, one wanted to make the manual illustrations (usually not required), one would type `make images`.

## 6.2 Manual Method

### 6.2.1 Examples

Compile `examples.tex`. In the following command lines, one may substitute `latex`, `xelatex`, `lualatex`, and `dvilualatex` for `pdflatex`.

    pdflatex --interaction=nonstopmode examples
    pdflatex --interaction=nonstopmode examples
    makeindex -o examples.ind examples.idx

This next line is needed because the `index` package makes an index of persons.

    makeindex -o examples.rnd examples.rdx

These lines complete the indexes and TOC.

    pdflatex --interaction=nonstopmode examples
    pdflatex --interaction=nonstopmode examples

Another step is used only with `latex` and `dvilualatex`. We default to `dvipdfmx` in case Ghostscript is not installed. If Ghostscript is already installed, one can use `dvipdf` instead. If a file `examples.out.ps` exists, one may delete it after creating the pdf file.

    dvipdfmx examples

If one changes LaTeX engines, one must remove all of the auxiliary files.

### 6.2.2 Tests

Generate the test files in the following manner from the `dtx`:

    pdflatex "\def\NameauthDoTestFiles{}\input{nameauth.dtx}"

Compile the test files. In the following command lines, one may substitute `latex`, `xelatex`, `lualatex`, and `dvilualatex` for `pdflatex`. One must change the root or base file name for each test file.

    pdflatex --interaction=nonstopmode test01-01
    pdflatex --interaction=nonstopmode test01-01
    makeindex -o test01-01.ind test01-01.idx

This next line is needed only for `test07-01.tex` because the `index` package is used for an index of persons.

    makeindex -o test07-01.rnd test07-01.rdx

These lines complete the indexes and TOC.

    pdflatex --interaction=nonstopmode test01-01
    pdflatex --interaction=nonstopmode test01-01

This step is used only when using `latex` and `dvilualatex`.

    dvipdfmx test01-01

If one changes LaTeX engines, one must remove all of the auxiliary files.

### 6.2.3 Images

If, for some reason, one wants to make the manual illustrations (usually not required), this would be the default procedure:

Generate the test files in the following manner from the `dtx`:

    pdflatex "\def\NameauthDoTestFiles{}\input{nameauth.dtx}"

Compile the test files:

    pdflatex --interaction=nonstopmode test07-02
    pdflatex --interaction=nonstopmode test07-02
    makeindex -o test07-02.ind test07-02.idx
    pdflatex --interaction=nonstopmode test07-02
    pdflatex --interaction=nonstopmode test07-02

    pdflatex --interaction=nonstopmode test09-01
    pdflatex --interaction=nonstopmode test09-01
    makeindex -o test09-01.ind test09-01.idx
    pdflatex --interaction=nonstopmode test09-01
    pdflatex --interaction=nonstopmode test09-01

    pdfjam --paper a6paper --landscape --quiet test07_02.pdf 3 --outfile cat01.pdf
    pdfjam --paper a5paper --landscape --quiet test09_01.pdf 1 --outfile beamer01.pdf
    pdfjam --paper a5paper --landscape --quiet test09_01.pdf 2 --outfile beamer02.pdf
    pdfjam --paper a5paper --landscape --quiet test09_01.pdf 3 --outfile beamer03.pdf

# 7. Additional Notes

In version 3.7 I spent over seven months analyzing and optimizing both code and documentation. Stepping away from this package for a bit gave me the perspective and clarity to improve it greatly.

* I cast aside a number of stale presuppositions that had built up over time. I explored all the ways that one could use certain features and fixed the bugs that appeared by using a better general approach.

* I brought back some thorough tests reminiscent of early package versions, but moved to the examples file.

* I rewrote the documentation to remove a lot of idiosyncratic formatting. It looks much cleaner, both as source code and as typeset documentation.

* Extensive rewriting has led to the TOC becoming the principal expression of scope and sequence. The goal was greater rigor in keeping the easy stuff easy and the complex stuff more accessible.

* The package itself has been reorganized to follow the same sequence as the documentation, letting the rhythm of repetition aid learning. One sees this right away in the TOC.

* Several macros have been optimized, leading to simpler and cleaner designs that are easier to debug.

* A few bugs that could result from directly changing internal package flags have been fixed, allowing the user-accessible parser to work in all cases as intended.

* Any name arguments shown in warnings are detokenized in order to prevent potential errors. Regressions caused by a reverted edit in an earlier version that I failed to catch caused several package warnings to halt with errors. These "lameauth" errors are fixed.

# 8. Copyright

Copyright (C) 2023 by Charles P. Schaum <charles[dot]schaum@comcast.net>

This file may be distributed and/or modified under the
conditions of the LaTeX Project Public License, either version 1.3
of this license or (at your option) any later version.
The latest version of this license is in:

   [https://www.latex-project.org/lppl.txt](https://www.latex-project.org/lppl.txt)

and version 1.3 or later is part of all distributions of LaTeX
version 2005/12/01 or later.

