%{
#ifndef lint
static char *copyright = "Copyright (C) 1985, Sven Mattisson.";
#endif

#include "l2sl.h"
#include "hash.h"
#include "comtab.h"

#define UP	optarg++
#define ZO	if (!seen_lb) optarg = 0
#define OOPS	else fprintf (stderr, "OOPS: yytext = \"%s\"\n", yytext)
#define PARMIS	fprintf (stderr, "%%%% Possible paren mismatch in line %d\n",\
			yylineno)
#define CHK(ZZ)	fprintf (stderr, "%%%% Check ZZ at line %d\n", yylineno)
#define COMCHK	fprintf (stderr,\
		    "%%%% Check command \"\\%s\" (type %d) at line %d\n",\
		    p -> name, p -> type, yylineno)
#define FLAGS	if (seen_lb && lb_lines++) {\
		    fprintf (stderr,\
			"%%%% Optional argument mismatch at line %d\n",\
			yylineno-2);\
		    seen_lb = lb_lines = 0;\
		 };\
		 if (!seen_lb) lb_lines = 0;\
		 seen_array = 0
#define ECHO1	printf ("!%s", &yytext[1])
#define ECHO2	printf ("!!%s", &yytext[2])
%}

%e  8000
%p  20000
%a  32000
%k  8000
%n  2000
%o  20000
S   [ \t\n\f]*
W   \\[A-Za-z]+
N   [A-Za-z]+
A   (\{{W}{S}\})|({W})
D   [0-9\.]+
C   \((-?({D})|({W}))\,(-?({D})|({W}))\)
%START SOPT PNT SPNT NTHRM NCMND
%%
	struct command *p;
\%.*			{ECHO;}	    /* ignore comments */
!			{printf ("!bang<>"); ZO;}	/* preserve '!' */
\\!			{printf ("!nspace<>"); ZO;}	/* preserve '\!' */
\\\%			|
\\\{			|
\\\}			{ECHO1; ZO;}	/* preserve '\%', '\{' and '\}' */
\\\[			|
\\\]			{ECHO1; ZO;}	/* preserve '\[' and '\]' */
(\<)|(\>)		{putchar ('!'); ECHO; ZO;}	/* preserve angels */
(\\)|(\{)|(\})		{subst(yytext); ECHO; ZO;}  /* substitute escapechar */
\\\|			{printf ("!Vert<>"); ZO;}   /* '\|' in math mode */
\.sty			{ECHO; CHK(.sty);} /* Check file name extension */
array			|
\\multicolumn		|
tabular			{seen_array++; ECHO; ZO;}   /* look out for '|' */
\|			{   if (seen_array) {
				putchar (':');
				CHK(colon);
			    } else {
			        printf ("!|");
			    }
			    ZO;
			}    /* '|' => ':' */
<SOPT>\*?{S}\[		|
\[			{   if (optarg > seen_lb) {
				putchar ('(');	/* substitute delimiter */
				seen_lb++;
			    } else {
				if (seen_lb) seen_lb++;
				printf ("!lbrack<>");
				CHK(!lbrack);
			    }; BEGIN 0;
			}
\]			{   if (seen_lb && seen_lb == optarg) {
				putchar (')');	/* substitute delimiter */
				seen_lb--;
				optarg--;
			    } else {
				if (seen_lb) seen_lb--;
				printf ("!rbrack<>");
				CHK(!rbrack);
			    };
			}
\(			|
\)			{ECHO; ZO;}	/* regular parens in text */
\\\\{S}\*?{S}/\[	{ECHO2; UP;}	/* \\*[...]-command */
\\\\{S}\*?{S}/[^\[]	{ECHO2; ZO;}	/* \\*-command */
<NTHRM>\{{N}\}(\{{N}\})?{S} {subst(yytext); ECHO; BEGIN 0;}  /* takes [] */
<NCMND>((\{{W}\})|{W}){S}   {subst(yytext); ECHO; BEGIN 0;}	/* takes [] */
<PNT>{C}{S}		{if (!parens(yytext)) PARMIS; ECHO; BEGIN 0;}
<SPNT>\*?{S}{C}{S}	{if (!parens(yytext)) PARMIS; ECHO; BEGIN 0;}
{C}			{if (!parens(yytext)) PARMIS;
			    CHK(double quotes); ECHO; ZO;}
{W}{S}			{   if ((p=lookup (strip (&yytext[1]))) == NULL) {
				ECHO1;
				ZO;
				BEGIN 0;	/* regular command */
			    } else switch ((int) p -> type) {
				    case ONEOPT:
					ECHO1;
					UP;
					BEGIN 0;
					break;
				    case STAROPT:
					ECHO1;
					UP;
					BEGIN SOPT;
					break;
				    case PNTOPT:
					ECHO1;
					UP;
					BEGIN PNT;
					break;
				    case ONLYPNT:
					ECHO1;
					ZO;
					BEGIN PNT;
					break;
				    case STARPNT:
					ECHO1;
					UP;
					BEGIN SPNT;
					break;
				    case NEWTHEOREM:
					ECHO1;
					UP;
					BEGIN NTHRM;
					break;
				    case NEWCOMMAND:
					ECHO1;
					UP;
					BEGIN NCMND;
					break;
				    default:
					ECHO1;
					ZO;
					BEGIN 0;
					COMCHK;
					break;
				};
			}
({N}{S})+		{ECHO; ZO; BEGIN 0;}	/* regular text */
[^ \t\n\f]		{ECHO; ZO;}	/* everything else */
\n			{ECHO; FLAGS; ZO;}  /* zero flags */
%%
