/* Copyright by JB Wang 1990 */
/* This program is intended for making bitmap fonts of different sizes from
   a set of bitmap fonts,  such as 24x24, with aid of  an IRIS 4D NeWS window
   and PostScript psview.

   The basic principle is to build  PostScript images of characters from an
   available font library (if bitmap fonts worked with psview or psh, we would
   not have to do this), display at different scales with psview or psh and
   snapshot the bitmap from the image-buffer into a file to obtain bitmap fonts
   of new sizes. This is important in building TeX pk files.



   J.B. Wang 4/8/1990
*/

#include <gl.h>
#include <stdio.h>
#include <fcntl.h>
#define nc 127


#define LEN16 32
#define LEN24 72
#define LEN48 288
#define CCLIB16jt "/usr/people/jbw/usr/src/chtex/cclib.16"
#define CCLIB24jt "/usr/people/jbw/usr/src/chtex/cclib.24"
#define CCLIB32jt "/usr/people/ftp/ch-series/cclib.32"
#define CCLIB48jt "/usr/people/ftp/ch-series/cclib.48"


unsigned char GB_array[2544861]; /* CCLIB 16x16 to 48x48 bitmap raster */

extern char *getenv();

main(argc, argv)
int argc;
char **argv;
{
int i, j;
int lens=LEN24;
int k;
int fontsize = 24;
int fontpos = 1410;
float fontscale = 24.;
char tmpstr[127];
int ht=24, wd=24;
int int_lens = 24; /* length in short integer */
int x2, y2;
char name[40];

if (argc>1) sscanf(argv[1], "%d", &fontpos);
if (argc>2) sscanf(argv[2], "%d", &fontsize);


if ((fontsize!=24)&&(fontsize!=48)&&(fontsize!=16)) fontsize = 24;


if (fontsize==16)
  {
    lens = 32;
    int_lens = 16;
    ht = 16;
    wd = 16;
  }
if (fontsize==32)
  {
    lens = 128;
    int_lens = 64;
    ht = 32;
    wd = 32;
  }
else if (fontsize==48)
  {
    lens = 288;
    int_lens = 144;
    ht = 48;
    wd = 48;
  }


read_cclib(lens); /* store cclib raster font into the raster array */

k =1 ;
while(1)
  {

    fprintf(stderr, "Character QuWei>");
    scanf("%d", &fontpos);
    fprintf(stderr, "Font Scale (in point)>");
    scanf("%f", &fontscale);
    fontscale --;
    make_image(fontpos, lens, ht, wd, fontscale/1.3);
/* display the PS image */
    system("psh /tmp/chimage.ps");
/* save the screen message */
 x2 = 
 y2 = fontscale;
    sprintf(name, "/tmp/ch.%d", k);
    savescreen(name,0,x2,0,y2);
    k ++;
    }


}


make_image(fontpos, lens, ht, wd, fontscale)
int fontpos, lens, ht, wd;
float fontscale;
{
FILE *outp;
int i;
float newht, newwd;

/* convert from 72dpi to 300 dpi */

newwd = fontscale+0.5;
newht = fontscale;

   outp = fopen("/tmp/chimage.ps", "w");



    fprintf(outp, "%%!\n0 0 translate\n%.3f %.3f scale\n", newwd, newht);
    fprintf(outp, "%d %d 1 [%d 0 0 -%d 0 %d] {<\n",
	    wd, ht, wd, ht, ht);

for(i=0; i<lens; i++)
  fprintf(outp, "%02x", GB_array[fontpos*lens+i]);

fprintf(outp, ">} image\nshowpage\n");


fclose(outp);
}

read_cclib(lens)
int lens;
{
int cclibhandle;
char *cclibfile;
int i;



if (lens == 32) /* 16 x 16 fonts */
  {
   	if (!(cclibfile = getenv("CCLIB16jt")))
		 cclibfile = CCLIB16jt;
      }
else 
if (lens == 72) /* 24 x 24 fonts */
  {
   	if (!(cclibfile = getenv("CCLIB24jt")))
		 cclibfile = CCLIB24jt;
      }
else 
if (lens == 128) /* 24 x 24 fonts */
  {
   	if (!(cclibfile = getenv("CCLIB32jt")))
		 cclibfile = CCLIB32jt;
      }
else if (lens == 288) /* 48 x 48 fonts */
  {
   	if (!(cclibfile = getenv("CCLIB48jt")))
		 cclibfile = CCLIB48jt;
      }


   if (( cclibhandle = open(cclibfile, O_RDONLY) ) <0 )
    {fputs("Missing library file", stderr); exit(-1);}

 lens *= (94*87);

	read(cclibhandle, &GB_array[0], lens);

     close(cclibhandle);
fprintf(stderr, " Font bitmap loaded\n");
	return(1);

}




/* now dump the screen into RGB format */
#include "gl.h"
#include "port.h"
#include "image.h"

char rbuf[2048];
char gbuf[2048];
char bbuf[2048];
short obuf[2048];
short rs[2048];
short gs[2048];
short bs[2048];

short all[127][127];

savescreen(name,x1,x2,y1,y2)
char *name;
int x1, x2, y1, y2;
{
    IMAGE *oimage;
    int xsize, ysize;
    int xorg, yorg;
    int temp, y, i;
    int pos, togo, n;
    FILE *newps;


    newps = fopen("/tmp/nch.ps", "w");

    foreground();
    noport();
    winopen("scrsave");
    xorg = MIN(x1,x2);
    yorg = MIN(y1,y2);
    if(xorg<0)
       xorg = 0;
    if(yorg<0)
       yorg = 0;
    xsize = ABS(x2-x1);
    ysize = ABS(y2-y1);
    if((xorg+xsize)>XMAXSCREEN)
	xsize = XMAXSCREEN-xorg;
    if((yorg+ysize)>YMAXSCREEN)
	ysize = YMAXSCREEN-yorg;
    xsize++;
    ysize++;
    oimage = iopen(name,"w",RLE(1),2,xsize,ysize);

    wmplanes();
    screenspace();

    for(y=0; y<ysize; y++) {
#define READSCREENBROKEN 
#ifdef READSCREENBROKEN
	togo = xsize;
	pos = 0;
	while(togo) {
	    n = togo;
	    if(n>256)
		n = 256;
	    cmov2i(xorg+pos,yorg+y);
	    gl_readscreen(n,rbuf+pos,gbuf+pos,bbuf+pos);
	    pos += n;
	    togo -= n;
	}
#else
	cmov2i(xorg,yorg+y);
	gl_readscreen(xsize,rbuf,gbuf,bbuf);
#endif
	ctos(rbuf,rs,xsize);
	ctos(gbuf,gs,xsize);
	ctos(bbuf,bs,xsize);
	compress(rs,gs,bs,obuf,xsize);
	putrow(oimage,obuf,y,0);
	putnewps(obuf, xsize, ysize, y);
    }

    savenewps(newps, xsize, ysize);
    iclose(oimage);
    fclose(newps);
}


compress(rbuf,gbuf,bbuf,obuf,n)
register unsigned short *rbuf, *gbuf, *bbuf, *obuf;
int n;
{
    register short i;
    int rval, gval, bval;
    int temp;

    for(i=n; i--; ) 
	    *obuf++ = (77*(*rbuf++) + 151*(*gbuf++) + 28*(*bbuf++))>>8;
}


putnewps(buf, n, ysize, y)
register short *buf;
int n, ysize, y;
{
int xsize=n;

    while (n--) {
      if (*buf==255) *buf=1;
      all[ysize-y-1][xsize-n] = *buf;
	buf++;
    }
}

savenewps(newps, xsize, ysize)
FILE *newps;
int xsize, ysize;
{
int i, j;

  for (i=0; i<ysize; i++)
    {
    for (j=0; j<xsize; j++)
      if (all[i][j]) putc('%', newps);
    else  fprintf(newps, " ");
    fprintf(newps, "\n");
  }
}


