/*
 * extpro.c - Copyright (C) 1995 by Giuseppe Ghibo`
 *
 * Written by Giuseppe Ghibo`
 *
 * Version 1.0 - 16 May 1995
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

typedef int bool;
#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

#define TMPLEN 2048
char tmpbuf[TMPLEN];

void main(int argc, char **argv)
{
	FILE *fpin, *fpout;
	char *fnamein, *fnameout, *p;
	bool copylines, mathstart;

	if (argc < 3)
	{
		fprintf(stderr,"extpro v1.0 (C) 1995 by Giuseppe Ghib\n"
		              "Usage:\n"
		              "\textpro <mma psfile> <prologue file>\n\n"
		              "extracts a PS prologue file from a MMA PS file <mma psfile>,\n"
		              "and writes it into <prologue file>.\n");
		exit(1);
	}
	else
	{
		fnamein = argv[1];
		fnameout = argv[2];
	}

	if ((fpin = fopen(fnamein,"r")) == NULL)
	{
		fprintf(stderr,"Can't open file `%s' (r): %s\n",
		       fnamein, strerror(errno));
		exit(1);
	}

	if ((fpout = fopen(fnameout,"w")) == NULL)
	{
		fprintf(stderr,"Can't open file `%s' (w): %s\n",
		        fnameout, strerror(errno));
		exit(1);
	}

	fprintf(fpout,"%%%% Mathematica prologue.\n"
	              "%%%% Extracted from a picture saved by Mathematica in 'PS' form.\n%%%%\n");

	copylines = FALSE;
	mathstart = FALSE;

	while ((fgets(tmpbuf, TMPLEN, fpin) != NULL))
	{
		if ((p = strstr(tmpbuf,"/Mathdict")) && !mathstart)
		{
			copylines = TRUE;
			fputs(p, fpout);
			continue;
		}
		else if (strstr(tmpbuf,"MathPictureStart") && !mathstart)
			mathstart = TRUE;
		else if (strstr(tmpbuf,"/Mlmarg") && !mathstart)
		{
			fprintf(fpout,"/Mlmarg\t\t0 def\n");
			continue;
		}
		else if (strstr(tmpbuf,"/Mrmarg") && !mathstart)
		{
			fprintf(fpout,"/Mrmarg\t\t0 def\n");
			continue;
		}
		else if (strstr(tmpbuf,"/Mbmarg") && !mathstart)
		{
			fprintf(fpout,"/Mbmarg\t\t0 def\n");
			continue;
		}
		else if (strstr(tmpbuf,"/Mtmarg") && !mathstart)
		{
			fprintf(fpout,"/Mtmarg\t\t0 def\n");
			continue;
		}
		else if (strstr(tmpbuf,"/Mwidth") && !mathstart)
			continue;
		else if (strstr(tmpbuf,"/Mheight") && !mathstart)
			continue;
		else if (strstr(tmpbuf,"/Mtransform") && !mathstart)
		{
			fprintf(fpout,"/Mtransform\t\173  \175 bind def\n");
			continue;
		}
		else if (strstr(tmpbuf,"/Mnodistort") && !mathstart)
			continue;
		else if (strstr(tmpbuf,"%!") && mathstart)
			break;

		if (copylines)
			fputs(tmpbuf,fpout);
	}

	fprintf(fpout,"end\n");

	fclose(fpin);
	fclose(fpout);
}
